// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.Alarm
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class PutScalingPolicyOperationDeserializer: HttpDeserialize<PutScalingPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutScalingPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutScalingPolicyError(context, call)
        }
        val builder = PutScalingPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutScalingPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutScalingPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceLinkedRoleFailure" -> ServiceLinkedRoleFailureDeserializer().deserialize(context, wrappedCall)
        "LimitExceeded" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutScalingPolicyOperationBody(builder: PutScalingPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PutScalingPolicyResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("PutScalingPolicyResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap PutScalingPolicy response")
    }
    // end unwrap response wrapper

    val ALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Alarms"))
    val POLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PolicyARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://autoscaling.amazonaws.com/doc/2011-01-01/"))
        trait(XmlSerialName("PutScalingPolicyResult"))
        field(ALARMS_DESCRIPTOR)
        field(POLICYARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALARMS_DESCRIPTOR.index -> builder.alarms =
                    deserializer.deserializeList(ALARMS_DESCRIPTOR) {
                        val col0 = mutableListOf<Alarm>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAlarmDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                POLICYARN_DESCRIPTOR.index -> builder.policyArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
