// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.CapacityForecast
import aws.sdk.kotlin.services.autoscaling.model.GetPredictiveScalingForecastResponse
import aws.sdk.kotlin.services.autoscaling.model.LoadForecast
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetPredictiveScalingForecastOperationDeserializer: HttpDeserialize<GetPredictiveScalingForecastResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetPredictiveScalingForecastResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPredictiveScalingForecastError(context, call)
        }
        val builder = GetPredictiveScalingForecastResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPredictiveScalingForecastOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetPredictiveScalingForecastError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPredictiveScalingForecastOperationBody(builder: GetPredictiveScalingForecastResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GetPredictiveScalingForecastResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetPredictiveScalingForecastResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap GetPredictiveScalingForecast response")
    }
    // end unwrap response wrapper

    val CAPACITYFORECAST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CapacityForecast"))
    val LOADFORECAST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("LoadForecast"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("UpdateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://autoscaling.amazonaws.com/doc/2011-01-01/"))
        trait(XmlSerialName("GetPredictiveScalingForecastResult"))
        field(CAPACITYFORECAST_DESCRIPTOR)
        field(LOADFORECAST_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPACITYFORECAST_DESCRIPTOR.index -> builder.capacityForecast = deserializeCapacityForecastDocument(deserializer)
                LOADFORECAST_DESCRIPTOR.index -> builder.loadForecast =
                    deserializer.deserializeList(LOADFORECAST_DESCRIPTOR) {
                        val col0 = mutableListOf<LoadForecast>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLoadForecastDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
