// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.paginators

import aws.sdk.kotlin.services.autoscaling.AutoScalingClient
import aws.sdk.kotlin.services.autoscaling.model.Activity
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingGroup
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingInstanceDetails
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingInstancesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingInstancesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeInstanceRefreshesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeInstanceRefreshesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLaunchConfigurationsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLaunchConfigurationsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeNotificationConfigurationsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeNotificationConfigurationsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribePoliciesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribePoliciesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingActivitiesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingActivitiesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeScheduledActionsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeTagsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeTagsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeWarmPoolRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeWarmPoolResponse
import aws.sdk.kotlin.services.autoscaling.model.Instance
import aws.sdk.kotlin.services.autoscaling.model.LaunchConfiguration
import aws.sdk.kotlin.services.autoscaling.model.NotificationConfiguration
import aws.sdk.kotlin.services.autoscaling.model.ScalingPolicy
import aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupAction
import aws.sdk.kotlin.services.autoscaling.model.TagDescription
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAutoScalingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAutoScalingGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingGroupsResponse]
 */
public fun AutoScalingClient.describeAutoScalingGroupsPaginated(initialRequest: DescribeAutoScalingGroupsRequest = DescribeAutoScalingGroupsRequest { }): Flow<DescribeAutoScalingGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAutoScalingGroupsPaginated.describeAutoScalingGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAutoScalingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingGroupsResponse]
 */
public fun AutoScalingClient.describeAutoScalingGroupsPaginated(block: DescribeAutoScalingGroupsRequest.Builder.() -> Unit): Flow<DescribeAutoScalingGroupsResponse> =
    describeAutoScalingGroupsPaginated(DescribeAutoScalingGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAutoScalingGroupsPaginated]
 * to access the nested member [AutoScalingGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AutoScalingGroup]
 */
@JvmName("describeAutoScalingGroupsResponseAutoScalingGroup")
public fun Flow<DescribeAutoScalingGroupsResponse>.autoScalingGroups(): Flow<AutoScalingGroup> =
    transform() { response ->
        response.autoScalingGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeAutoScalingInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAutoScalingInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingInstancesResponse]
 */
public fun AutoScalingClient.describeAutoScalingInstancesPaginated(initialRequest: DescribeAutoScalingInstancesRequest = DescribeAutoScalingInstancesRequest { }): Flow<DescribeAutoScalingInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAutoScalingInstancesPaginated.describeAutoScalingInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAutoScalingInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingInstancesResponse]
 */
public fun AutoScalingClient.describeAutoScalingInstancesPaginated(block: DescribeAutoScalingInstancesRequest.Builder.() -> Unit): Flow<DescribeAutoScalingInstancesResponse> =
    describeAutoScalingInstancesPaginated(DescribeAutoScalingInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAutoScalingInstancesPaginated]
 * to access the nested member [AutoScalingInstanceDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AutoScalingInstanceDetails]
 */
@JvmName("describeAutoScalingInstancesResponseAutoScalingInstanceDetails")
public fun Flow<DescribeAutoScalingInstancesResponse>.autoScalingInstances(): Flow<AutoScalingInstanceDetails> =
    transform() { response ->
        response.autoScalingInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeInstanceRefreshesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeInstanceRefreshesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInstanceRefreshesResponse]
 */
public fun AutoScalingClient.describeInstanceRefreshesPaginated(initialRequest: DescribeInstanceRefreshesRequest): Flow<DescribeInstanceRefreshesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeInstanceRefreshesPaginated.describeInstanceRefreshes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeInstanceRefreshesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInstanceRefreshesResponse]
 */
public fun AutoScalingClient.describeInstanceRefreshesPaginated(block: DescribeInstanceRefreshesRequest.Builder.() -> Unit): Flow<DescribeInstanceRefreshesResponse> =
    describeInstanceRefreshesPaginated(DescribeInstanceRefreshesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeLaunchConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLaunchConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLaunchConfigurationsResponse]
 */
public fun AutoScalingClient.describeLaunchConfigurationsPaginated(initialRequest: DescribeLaunchConfigurationsRequest = DescribeLaunchConfigurationsRequest { }): Flow<DescribeLaunchConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeLaunchConfigurationsPaginated.describeLaunchConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLaunchConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLaunchConfigurationsResponse]
 */
public fun AutoScalingClient.describeLaunchConfigurationsPaginated(block: DescribeLaunchConfigurationsRequest.Builder.() -> Unit): Flow<DescribeLaunchConfigurationsResponse> =
    describeLaunchConfigurationsPaginated(DescribeLaunchConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeLaunchConfigurationsPaginated]
 * to access the nested member [LaunchConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LaunchConfiguration]
 */
@JvmName("describeLaunchConfigurationsResponseLaunchConfiguration")
public fun Flow<DescribeLaunchConfigurationsResponse>.launchConfigurations(): Flow<LaunchConfiguration> =
    transform() { response ->
        response.launchConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLoadBalancersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun AutoScalingClient.describeLoadBalancersPaginated(initialRequest: DescribeLoadBalancersRequest): Flow<DescribeLoadBalancersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeLoadBalancersPaginated.describeLoadBalancers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun AutoScalingClient.describeLoadBalancersPaginated(block: DescribeLoadBalancersRequest.Builder.() -> Unit): Flow<DescribeLoadBalancersResponse> =
    describeLoadBalancersPaginated(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeLoadBalancerTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLoadBalancerTargetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancerTargetGroupsResponse]
 */
public fun AutoScalingClient.describeLoadBalancerTargetGroupsPaginated(initialRequest: DescribeLoadBalancerTargetGroupsRequest): Flow<DescribeLoadBalancerTargetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeLoadBalancerTargetGroupsPaginated.describeLoadBalancerTargetGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLoadBalancerTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancerTargetGroupsResponse]
 */
public fun AutoScalingClient.describeLoadBalancerTargetGroupsPaginated(block: DescribeLoadBalancerTargetGroupsRequest.Builder.() -> Unit): Flow<DescribeLoadBalancerTargetGroupsResponse> =
    describeLoadBalancerTargetGroupsPaginated(DescribeLoadBalancerTargetGroupsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeNotificationConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeNotificationConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationConfigurationsResponse]
 */
public fun AutoScalingClient.describeNotificationConfigurationsPaginated(initialRequest: DescribeNotificationConfigurationsRequest = DescribeNotificationConfigurationsRequest { }): Flow<DescribeNotificationConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeNotificationConfigurationsPaginated.describeNotificationConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeNotificationConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationConfigurationsResponse]
 */
public fun AutoScalingClient.describeNotificationConfigurationsPaginated(block: DescribeNotificationConfigurationsRequest.Builder.() -> Unit): Flow<DescribeNotificationConfigurationsResponse> =
    describeNotificationConfigurationsPaginated(DescribeNotificationConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeNotificationConfigurationsPaginated]
 * to access the nested member [NotificationConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NotificationConfiguration]
 */
@JvmName("describeNotificationConfigurationsResponseNotificationConfiguration")
public fun Flow<DescribeNotificationConfigurationsResponse>.notificationConfigurations(): Flow<NotificationConfiguration> =
    transform() { response ->
        response.notificationConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePoliciesResponse]
 */
public fun AutoScalingClient.describePoliciesPaginated(initialRequest: DescribePoliciesRequest = DescribePoliciesRequest { }): Flow<DescribePoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePoliciesPaginated.describePolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePoliciesResponse]
 */
public fun AutoScalingClient.describePoliciesPaginated(block: DescribePoliciesRequest.Builder.() -> Unit): Flow<DescribePoliciesResponse> =
    describePoliciesPaginated(DescribePoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describePoliciesPaginated]
 * to access the nested member [ScalingPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScalingPolicy]
 */
@JvmName("describePoliciesResponseScalingPolicy")
public fun Flow<DescribePoliciesResponse>.scalingPolicies(): Flow<ScalingPolicy> =
    transform() { response ->
        response.scalingPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScalingActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScalingActivitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingActivitiesResponse]
 */
public fun AutoScalingClient.describeScalingActivitiesPaginated(initialRequest: DescribeScalingActivitiesRequest = DescribeScalingActivitiesRequest { }): Flow<DescribeScalingActivitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScalingActivitiesPaginated.describeScalingActivities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScalingActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingActivitiesResponse]
 */
public fun AutoScalingClient.describeScalingActivitiesPaginated(block: DescribeScalingActivitiesRequest.Builder.() -> Unit): Flow<DescribeScalingActivitiesResponse> =
    describeScalingActivitiesPaginated(DescribeScalingActivitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScalingActivitiesPaginated]
 * to access the nested member [Activity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Activity]
 */
@JvmName("describeScalingActivitiesResponseActivity")
public fun Flow<DescribeScalingActivitiesResponse>.activities(): Flow<Activity> =
    transform() { response ->
        response.activities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScheduledActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
public fun AutoScalingClient.describeScheduledActionsPaginated(initialRequest: DescribeScheduledActionsRequest = DescribeScheduledActionsRequest { }): Flow<DescribeScheduledActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScheduledActionsPaginated.describeScheduledActions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
public fun AutoScalingClient.describeScheduledActionsPaginated(block: DescribeScheduledActionsRequest.Builder.() -> Unit): Flow<DescribeScheduledActionsResponse> =
    describeScheduledActionsPaginated(DescribeScheduledActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScheduledActionsPaginated]
 * to access the nested member [ScheduledUpdateGroupAction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduledUpdateGroupAction]
 */
@JvmName("describeScheduledActionsResponseScheduledUpdateGroupAction")
public fun Flow<DescribeScheduledActionsResponse>.scheduledUpdateGroupActions(): Flow<ScheduledUpdateGroupAction> =
    transform() { response ->
        response.scheduledUpdateGroupActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun AutoScalingClient.describeTagsPaginated(initialRequest: DescribeTagsRequest = DescribeTagsRequest { }): Flow<DescribeTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeTagsPaginated.describeTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun AutoScalingClient.describeTagsPaginated(block: DescribeTagsRequest.Builder.() -> Unit): Flow<DescribeTagsResponse> =
    describeTagsPaginated(DescribeTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTagsPaginated]
 * to access the nested member [TagDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TagDescription]
 */
@JvmName("describeTagsResponseTagDescription")
public fun Flow<DescribeTagsResponse>.tags(): Flow<TagDescription> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTrafficSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTrafficSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrafficSourcesResponse]
 */
public fun AutoScalingClient.describeTrafficSourcesPaginated(initialRequest: DescribeTrafficSourcesRequest): Flow<DescribeTrafficSourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeTrafficSourcesPaginated.describeTrafficSources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTrafficSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTrafficSourcesResponse]
 */
public fun AutoScalingClient.describeTrafficSourcesPaginated(block: DescribeTrafficSourcesRequest.Builder.() -> Unit): Flow<DescribeTrafficSourcesResponse> =
    describeTrafficSourcesPaginated(DescribeTrafficSourcesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeWarmPoolResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeWarmPoolRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWarmPoolResponse]
 */
public fun AutoScalingClient.describeWarmPoolPaginated(initialRequest: DescribeWarmPoolRequest): Flow<DescribeWarmPoolResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeWarmPoolPaginated.describeWarmPool(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeWarmPoolResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeWarmPoolResponse]
 */
public fun AutoScalingClient.describeWarmPoolPaginated(block: DescribeWarmPoolRequest.Builder.() -> Unit): Flow<DescribeWarmPoolResponse> =
    describeWarmPoolPaginated(DescribeWarmPoolRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeWarmPoolPaginated]
 * to access the nested member [Instance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Instance]
 */
@JvmName("describeWarmPoolResponseInstance")
public fun Flow<DescribeWarmPoolResponse>.instances(): Flow<Instance> =
    transform() { response ->
        response.instances?.forEach {
            emit(it)
        }
    }
