// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



public class UpdateAutoScalingGroupRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * One or more Availability Zones for the group.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Enables or disables Capacity Rebalancing. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val capacityRebalance: kotlin.Boolean? = builder.capacityRebalance
    /**
     * Reserved.
     */
    public val context: kotlin.String? = builder.context
    /**
     * *Only needed if you use simple scaling policies.*
     *
     * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val defaultCooldown: kotlin.Int? = builder.defaultCooldown
    /**
     * The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the `InService` state.
     *
     * During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify `-1` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of `0` or other nominal value.
     */
    public val defaultInstanceWarmup: kotlin.Int? = builder.defaultInstanceWarmup
    /**
     * The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.
     */
    public val desiredCapacity: kotlin.Int? = builder.desiredCapacity
    /**
     * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports `DesiredCapacityType` for attribute-based instance type selection only. For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * By default, Amazon EC2 Auto Scaling specifies `units`, which translates into number of instances.
     *
     * Valid values: `units` | `vcpu` | `memory-mib`
     */
    public val desiredCapacityType: kotlin.String? = builder.desiredCapacityType
    /**
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the `InService` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val healthCheckGracePeriod: kotlin.Int? = builder.healthCheckGracePeriod
    /**
     * A comma-separated value string of one or more health check types.
     *
     * The valid values are `EC2`, `ELB`, and `VPC_LATTICE`. `EC2` is the default health check and cannot be disabled. For more information, see [Health checks for Auto Scaling instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Only specify `EC2` if you must clear a value that was previously set.
     */
    public val healthCheckType: kotlin.String? = builder.healthCheckType
    /**
     * An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val instanceMaintenancePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy? = builder.instanceMaintenancePolicy
    /**
     * The name of the launch configuration. If you specify `LaunchConfigurationName` in your update request, you can't specify `LaunchTemplate` or `MixedInstancesPolicy`.
     */
    public val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The launch template and version to use to specify the updates. If you specify `LaunchTemplate` in your update request, you can't specify `LaunchConfigurationName` or `MixedInstancesPolicy`.
     */
    public val launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see [Replacing Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val maxInstanceLifetime: kotlin.Int? = builder.maxInstanceLifetime
    /**
     * The maximum size of the Auto Scaling group.
     *
     * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above `MaxSize` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above `MaxSize` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum size of the Auto Scaling group.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The mixed instances policy. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = builder.mixedInstancesPolicy
    /**
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val newInstancesProtectedFromScaleIn: kotlin.Boolean? = builder.newInstancesProtectedFromScaleIn
    /**
     * The name of an existing placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
     */
    public val placementGroup: kotlin.String? = builder.placementGroup
    /**
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val serviceLinkedRoleArn: kotlin.String? = builder.serviceLinkedRoleArn
    /**
     * A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see [Work with Amazon EC2 Auto Scaling termination policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Valid values: `Default` | `AllocationStrategy` | `ClosestToNextInstanceHour` | `NewestInstance` | `OldestInstance` | `OldestLaunchConfiguration` | `OldestLaunchTemplate` | `arn:aws:lambda:region:account-id:function:my-function:my-alias`
     */
    public val terminationPolicies: List<String>? = builder.terminationPolicies
    /**
     * A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify `VPCZoneIdentifier` with `AvailabilityZones`, the subnets that you specify must reside in those Availability Zones.
     */
    public val vpcZoneIdentifier: kotlin.String? = builder.vpcZoneIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.UpdateAutoScalingGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAutoScalingGroupRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("availabilityZones=$availabilityZones,")
        append("capacityRebalance=$capacityRebalance,")
        append("context=$context,")
        append("defaultCooldown=$defaultCooldown,")
        append("defaultInstanceWarmup=$defaultInstanceWarmup,")
        append("desiredCapacity=$desiredCapacity,")
        append("desiredCapacityType=$desiredCapacityType,")
        append("healthCheckGracePeriod=$healthCheckGracePeriod,")
        append("healthCheckType=$healthCheckType,")
        append("instanceMaintenancePolicy=$instanceMaintenancePolicy,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("launchTemplate=$launchTemplate,")
        append("maxInstanceLifetime=$maxInstanceLifetime,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("mixedInstancesPolicy=$mixedInstancesPolicy,")
        append("newInstancesProtectedFromScaleIn=$newInstancesProtectedFromScaleIn,")
        append("placementGroup=$placementGroup,")
        append("serviceLinkedRoleArn=$serviceLinkedRoleArn,")
        append("terminationPolicies=$terminationPolicies,")
        append("vpcZoneIdentifier=$vpcZoneIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (capacityRebalance?.hashCode() ?: 0)
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (defaultCooldown ?: 0)
        result = 31 * result + (defaultInstanceWarmup ?: 0)
        result = 31 * result + (desiredCapacity ?: 0)
        result = 31 * result + (desiredCapacityType?.hashCode() ?: 0)
        result = 31 * result + (healthCheckGracePeriod ?: 0)
        result = 31 * result + (healthCheckType?.hashCode() ?: 0)
        result = 31 * result + (instanceMaintenancePolicy?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (maxInstanceLifetime ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (mixedInstancesPolicy?.hashCode() ?: 0)
        result = 31 * result + (newInstancesProtectedFromScaleIn?.hashCode() ?: 0)
        result = 31 * result + (placementGroup?.hashCode() ?: 0)
        result = 31 * result + (serviceLinkedRoleArn?.hashCode() ?: 0)
        result = 31 * result + (terminationPolicies?.hashCode() ?: 0)
        result = 31 * result + (vpcZoneIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAutoScalingGroupRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (availabilityZones != other.availabilityZones) return false
        if (capacityRebalance != other.capacityRebalance) return false
        if (context != other.context) return false
        if (defaultCooldown != other.defaultCooldown) return false
        if (defaultInstanceWarmup != other.defaultInstanceWarmup) return false
        if (desiredCapacity != other.desiredCapacity) return false
        if (desiredCapacityType != other.desiredCapacityType) return false
        if (healthCheckGracePeriod != other.healthCheckGracePeriod) return false
        if (healthCheckType != other.healthCheckType) return false
        if (instanceMaintenancePolicy != other.instanceMaintenancePolicy) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (launchTemplate != other.launchTemplate) return false
        if (maxInstanceLifetime != other.maxInstanceLifetime) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (mixedInstancesPolicy != other.mixedInstancesPolicy) return false
        if (newInstancesProtectedFromScaleIn != other.newInstancesProtectedFromScaleIn) return false
        if (placementGroup != other.placementGroup) return false
        if (serviceLinkedRoleArn != other.serviceLinkedRoleArn) return false
        if (terminationPolicies != other.terminationPolicies) return false
        if (vpcZoneIdentifier != other.vpcZoneIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.UpdateAutoScalingGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * One or more Availability Zones for the group.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Enables or disables Capacity Rebalancing. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var capacityRebalance: kotlin.Boolean? = null
        /**
         * Reserved.
         */
        public var context: kotlin.String? = null
        /**
         * *Only needed if you use simple scaling policies.*
         *
         * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var defaultCooldown: kotlin.Int? = null
        /**
         * The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the `InService` state.
         *
         * During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify `-1` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of `0` or other nominal value.
         */
        public var defaultInstanceWarmup: kotlin.Int? = null
        /**
         * The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.
         */
        public var desiredCapacity: kotlin.Int? = null
        /**
         * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports `DesiredCapacityType` for attribute-based instance type selection only. For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * By default, Amazon EC2 Auto Scaling specifies `units`, which translates into number of instances.
         *
         * Valid values: `units` | `vcpu` | `memory-mib`
         */
        public var desiredCapacityType: kotlin.String? = null
        /**
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the `InService` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var healthCheckGracePeriod: kotlin.Int? = null
        /**
         * A comma-separated value string of one or more health check types.
         *
         * The valid values are `EC2`, `ELB`, and `VPC_LATTICE`. `EC2` is the default health check and cannot be disabled. For more information, see [Health checks for Auto Scaling instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Only specify `EC2` if you must clear a value that was previously set.
         */
        public var healthCheckType: kotlin.String? = null
        /**
         * An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var instanceMaintenancePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy? = null
        /**
         * The name of the launch configuration. If you specify `LaunchConfigurationName` in your update request, you can't specify `LaunchTemplate` or `MixedInstancesPolicy`.
         */
        public var launchConfigurationName: kotlin.String? = null
        /**
         * The launch template and version to use to specify the updates. If you specify `LaunchTemplate` in your update request, you can't specify `LaunchConfigurationName` or `MixedInstancesPolicy`.
         */
        public var launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = null
        /**
         * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see [Replacing Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var maxInstanceLifetime: kotlin.Int? = null
        /**
         * The maximum size of the Auto Scaling group.
         *
         * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above `MaxSize` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above `MaxSize` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum size of the Auto Scaling group.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The mixed instances policy. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = null
        /**
         * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var newInstancesProtectedFromScaleIn: kotlin.Boolean? = null
        /**
         * The name of an existing placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
         */
        public var placementGroup: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var serviceLinkedRoleArn: kotlin.String? = null
        /**
         * A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see [Work with Amazon EC2 Auto Scaling termination policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Valid values: `Default` | `AllocationStrategy` | `ClosestToNextInstanceHour` | `NewestInstance` | `OldestInstance` | `OldestLaunchConfiguration` | `OldestLaunchTemplate` | `arn:aws:lambda:region:account-id:function:my-function:my-alias`
         */
        public var terminationPolicies: List<String>? = null
        /**
         * A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify `VPCZoneIdentifier` with `AvailabilityZones`, the subnets that you specify must reside in those Availability Zones.
         */
        public var vpcZoneIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.UpdateAutoScalingGroupRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.availabilityZones = x.availabilityZones
            this.capacityRebalance = x.capacityRebalance
            this.context = x.context
            this.defaultCooldown = x.defaultCooldown
            this.defaultInstanceWarmup = x.defaultInstanceWarmup
            this.desiredCapacity = x.desiredCapacity
            this.desiredCapacityType = x.desiredCapacityType
            this.healthCheckGracePeriod = x.healthCheckGracePeriod
            this.healthCheckType = x.healthCheckType
            this.instanceMaintenancePolicy = x.instanceMaintenancePolicy
            this.launchConfigurationName = x.launchConfigurationName
            this.launchTemplate = x.launchTemplate
            this.maxInstanceLifetime = x.maxInstanceLifetime
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.mixedInstancesPolicy = x.mixedInstancesPolicy
            this.newInstancesProtectedFromScaleIn = x.newInstancesProtectedFromScaleIn
            this.placementGroup = x.placementGroup
            this.serviceLinkedRoleArn = x.serviceLinkedRoleArn
            this.terminationPolicies = x.terminationPolicies
            this.vpcZoneIdentifier = x.vpcZoneIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.UpdateAutoScalingGroupRequest = UpdateAutoScalingGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy] inside the given [block]
         */
        public fun instanceMaintenancePolicy(block: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy.Builder.() -> kotlin.Unit) {
            this.instanceMaintenancePolicy = aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy] inside the given [block]
         */
        public fun mixedInstancesPolicy(block: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.Builder.() -> kotlin.Unit) {
            this.mixedInstancesPolicy = aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
