// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Identifying information for a traffic source.
 */
public class TrafficSourceIdentifier private constructor(builder: Builder) {
    /**
     * Identifies the traffic source.
     *
     * For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
     *
     * For example:
     * + Application Load Balancer ARN: `arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456`
     * + Classic Load Balancer name: `my-classic-load-balancer`
     * + VPC Lattice ARN: `arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456`
     *
     * To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) and [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operations.
     *
     * To get the ARN of a target group for VPC Lattice, use the VPC Lattice [GetTargetGroup](https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html) API operation.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * Provides additional context for the value of `Identifier`.
     *
     * The following lists the valid values:
     * + `elb` if `Identifier` is the name of a Classic Load Balancer.
     * + `elbv2` if `Identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
     * + `vpc-lattice` if `Identifier` is the ARN of a VPC Lattice target group.
     *
     * Required if the identifier is the name of a Classic Load Balancer.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.TrafficSourceIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficSourceIdentifier(")
        append("identifier=$identifier,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identifier?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficSourceIdentifier

        if (identifier != other.identifier) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.TrafficSourceIdentifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies the traffic source.
         *
         * For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
         *
         * For example:
         * + Application Load Balancer ARN: `arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/1234567890123456`
         * + Classic Load Balancer name: `my-classic-load-balancer`
         * + VPC Lattice ARN: `arn:aws:vpc-lattice:us-west-2:123456789012:targetgroup/tg-1234567890123456`
         *
         * To get the ARN of a target group for a Application Load Balancer, Gateway Load Balancer, or Network Load Balancer, or the name of a Classic Load Balancer, use the Elastic Load Balancing [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) and [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operations.
         *
         * To get the ARN of a target group for VPC Lattice, use the VPC Lattice [GetTargetGroup](https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html) API operation.
         */
        public var identifier: kotlin.String? = null
        /**
         * Provides additional context for the value of `Identifier`.
         *
         * The following lists the valid values:
         * + `elb` if `Identifier` is the name of a Classic Load Balancer.
         * + `elbv2` if `Identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
         * + `vpc-lattice` if `Identifier` is the ARN of a VPC Lattice target group.
         *
         * Required if the identifier is the name of a Classic Load Balancer.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.TrafficSourceIdentifier) : this() {
            this.identifier = x.identifier
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.TrafficSourceIdentifier = TrafficSourceIdentifier(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
