// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Represents a target tracking scaling policy configuration to use with Amazon EC2 Auto Scaling.
 */
public class TargetTrackingConfiguration private constructor(builder: Builder) {
    /**
     * A customized metric. You must specify either a predefined metric or a customized metric.
     */
    public val customizedMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.CustomizedMetricSpecification? = builder.customizedMetricSpecification
    /**
     * Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is `false`.
     */
    public val disableScaleIn: kotlin.Boolean? = builder.disableScaleIn
    /**
     * A predefined metric. You must specify either a predefined metric or a customized metric.
     */
    public val predefinedMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification? = builder.predefinedMetricSpecification
    /**
     * The target value for the metric.
     *
     * Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
     */
    public val targetValue: kotlin.Double? = builder.targetValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingConfiguration(")
        append("customizedMetricSpecification=$customizedMetricSpecification,")
        append("disableScaleIn=$disableScaleIn,")
        append("predefinedMetricSpecification=$predefinedMetricSpecification,")
        append("targetValue=$targetValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableScaleIn?.hashCode() ?: 0)
        result = 31 * result + (predefinedMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (targetValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetTrackingConfiguration

        if (customizedMetricSpecification != other.customizedMetricSpecification) return false
        if (disableScaleIn != other.disableScaleIn) return false
        if (predefinedMetricSpecification != other.predefinedMetricSpecification) return false
        if (targetValue != other.targetValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A customized metric. You must specify either a predefined metric or a customized metric.
         */
        public var customizedMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.CustomizedMetricSpecification? = null
        /**
         * Indicates whether scaling in by the target tracking scaling policy is disabled. If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is `false`.
         */
        public var disableScaleIn: kotlin.Boolean? = null
        /**
         * A predefined metric. You must specify either a predefined metric or a customized metric.
         */
        public var predefinedMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification? = null
        /**
         * The target value for the metric.
         *
         * Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
         */
        public var targetValue: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration) : this() {
            this.customizedMetricSpecification = x.customizedMetricSpecification
            this.disableScaleIn = x.disableScaleIn
            this.predefinedMetricSpecification = x.predefinedMetricSpecification
            this.targetValue = x.targetValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration = TargetTrackingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.CustomizedMetricSpecification] inside the given [block]
         */
        public fun customizedMetricSpecification(block: aws.sdk.kotlin.services.autoscaling.model.CustomizedMetricSpecification.Builder.() -> kotlin.Unit) {
            this.customizedMetricSpecification = aws.sdk.kotlin.services.autoscaling.model.CustomizedMetricSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification] inside the given [block]
         */
        public fun predefinedMetricSpecification(block: aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification.Builder.() -> kotlin.Unit) {
            this.predefinedMetricSpecification = aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
