// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Specifies the minimum and maximum for the `NetworkBandwidthGbps` object when you specify InstanceRequirements for an Auto Scaling group.
 *
 * Setting the minimum bandwidth does not guarantee that your instance will achieve the minimum bandwidth. Amazon EC2 will identify instance types that support the specified minimum bandwidth, but the actual bandwidth of your instance might go below the specified minimum at times. For more information, see [Available instance bandwidth](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth) in the *Amazon EC2 User Guide for Linux Instances*.
 */
public class NetworkBandwidthGbpsRequest private constructor(builder: Builder) {
    /**
     * The maximum amount of network bandwidth, in gigabits per second (Gbps).
     */
    public val max: kotlin.Double? = builder.max
    /**
     * The minimum amount of network bandwidth, in gigabits per second (Gbps).
     */
    public val min: kotlin.Double? = builder.min

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkBandwidthGbpsRequest(")
        append("max=$max,")
        append("min=$min")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = max?.hashCode() ?: 0
        result = 31 * result + (min?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkBandwidthGbpsRequest

        if (max != other.max) return false
        if (min != other.min) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum amount of network bandwidth, in gigabits per second (Gbps).
         */
        public var max: kotlin.Double? = null
        /**
         * The minimum amount of network bandwidth, in gigabits per second (Gbps).
         */
        public var min: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest) : this() {
            this.max = x.max
            this.min = x.min
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest = NetworkBandwidthGbpsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
