// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * The attributes for the instance types for a mixed instances policy. Amazon EC2 Auto Scaling uses your specified requirements to identify instance types. Then, it uses your On-Demand and Spot allocation strategies to launch instances from these instance types.
 *
 * When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
 *
 * To limit the list of instance types from which Amazon EC2 Auto Scaling can identify matching instance types, you can use one of the following parameters, but not both in the same request:
 * + `AllowedInstanceTypes` - The instance types to include in the list. All other instance types are ignored, even if they match your specified attributes.
 * + `ExcludedInstanceTypes` - The instance types to exclude from the list, even if they match your specified attributes.
 *
 * You must specify `VCpuCount` and `MemoryMiB`. All other attributes are optional. Any unspecified optional attribute is set to its default.
 *
 * For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*. For help determining which instance types match your attributes before you apply them to your Auto Scaling group, see [Preview instance types with specified attributes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html#ec2fleet-get-instance-types-from-instance-requirements) in the *Amazon EC2 User Guide for Linux Instances*.
 */
public class InstanceRequirements private constructor(builder: Builder) {
    /**
     * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) for an instance type.
     *
     * To exclude accelerator-enabled instance types, set `Max` to `0`.
     *
     * Default: No minimum or maximum limits
     */
    public val acceleratorCount: aws.sdk.kotlin.services.autoscaling.model.AcceleratorCountRequest? = builder.acceleratorCount
    /**
     * Indicates whether instance types must have accelerators by specific manufacturers.
     * + For instance types with NVIDIA devices, specify `nvidia`.
     * + For instance types with AMD devices, specify `amd`.
     * + For instance types with Amazon Web Services devices, specify `amazon-web-services`.
     * + For instance types with Xilinx devices, specify `xilinx`.
     *
     * Default: Any manufacturer
     */
    public val acceleratorManufacturers: List<AcceleratorManufacturer>? = builder.acceleratorManufacturers
    /**
     * Lists the accelerators that must be on an instance type.
     * + For instance types with NVIDIA A100 GPUs, specify `a100`.
     * + For instance types with NVIDIA V100 GPUs, specify `v100`.
     * + For instance types with NVIDIA K80 GPUs, specify `k80`.
     * + For instance types with NVIDIA T4 GPUs, specify `t4`.
     * + For instance types with NVIDIA M60 GPUs, specify `m60`.
     * + For instance types with AMD Radeon Pro V520 GPUs, specify `radeon-pro-v520`.
     * + For instance types with Xilinx VU9P FPGAs, specify `vu9p`.
     *
     * Default: Any accelerator
     */
    public val acceleratorNames: List<AcceleratorName>? = builder.acceleratorNames
    /**
     * The minimum and maximum total memory size for the accelerators on an instance type, in MiB.
     *
     * Default: No minimum or maximum limits
     */
    public val acceleratorTotalMemoryMib: aws.sdk.kotlin.services.autoscaling.model.AcceleratorTotalMemoryMibRequest? = builder.acceleratorTotalMemoryMib
    /**
     * Lists the accelerator types that must be on an instance type.
     * + For instance types with GPU accelerators, specify `gpu`.
     * + For instance types with FPGA accelerators, specify `fpga`.
     * + For instance types with inference accelerators, specify `inference`.
     *
     * Default: Any accelerator type
     */
    public val acceleratorTypes: List<AcceleratorType>? = builder.acceleratorTypes
    /**
     * The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.
     *
     * You can use strings with one or more wild cards, represented by an asterisk (`*`), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`.
     *
     * For example, if you specify `c5*`, Amazon EC2 Auto Scaling will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, Amazon EC2 Auto Scaling will allow all the M5a instance types, but not the M5n instance types.
     *
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     *
     * Default: All instance types
     */
    public val allowedInstanceTypes: List<String>? = builder.allowedInstanceTypes
    /**
     * Indicates whether bare metal instance types are included, excluded, or required.
     *
     * Default: `excluded`
     */
    public val bareMetal: aws.sdk.kotlin.services.autoscaling.model.BareMetal? = builder.bareMetal
    /**
     * The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see [Amazon EBS–optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * Default: No minimum or maximum limits
     */
    public val baselineEbsBandwidthMbps: aws.sdk.kotlin.services.autoscaling.model.BaselineEbsBandwidthMbpsRequest? = builder.baselineEbsBandwidthMbps
    /**
     * Indicates whether burstable performance instance types are included, excluded, or required. For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * Default: `excluded`
     */
    public val burstablePerformance: aws.sdk.kotlin.services.autoscaling.model.BurstablePerformance? = builder.burstablePerformance
    /**
     * Lists which specific CPU manufacturers to include.
     * + For instance types with Intel CPUs, specify `intel`.
     * + For instance types with AMD CPUs, specify `amd`.
     * + For instance types with Amazon Web Services CPUs, specify `amazon-web-services`.
     *
     * Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     *
     * Default: Any manufacturer
     */
    public val cpuManufacturers: List<CpuManufacturer>? = builder.cpuManufacturers
    /**
     * The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (`*`), to exclude an instance family, type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`.
     *
     * For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n instance types.
     *
     * If you specify `ExcludedInstanceTypes`, you can't specify `AllowedInstanceTypes`.
     *
     * Default: No excluded instance types
     */
    public val excludedInstanceTypes: List<String>? = builder.excludedInstanceTypes
    /**
     * Indicates whether current or previous generation instance types are included.
     * + For current generation instance types, specify `current`. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
     * + For previous generation instance types, specify `previous`.
     *
     * Default: Any current or previous generation
     */
    public val instanceGenerations: List<InstanceGeneration>? = builder.instanceGenerations
    /**
     * Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * Default: `included`
     */
    public val localStorage: aws.sdk.kotlin.services.autoscaling.model.LocalStorage? = builder.localStorage
    /**
     * Indicates the type of local storage that is required.
     * + For instance types with hard disk drive (HDD) storage, specify `hdd`.
     * + For instance types with solid state drive (SSD) storage, specify `ssd`.
     *
     * Default: Any local storage type
     */
    public val localStorageTypes: List<LocalStorageType>? = builder.localStorageTypes
    /**
     * The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
     *
     * Default: No minimum or maximum limits
     */
    public val memoryGibPerVCpu: aws.sdk.kotlin.services.autoscaling.model.MemoryGibPerVCpuRequest? = builder.memoryGibPerVCpu
    /**
     * The minimum and maximum instance memory size for an instance type, in MiB.
     */
    public val memoryMib: aws.sdk.kotlin.services.autoscaling.model.MemoryMibRequest? = builder.memoryMib
    /**
     * The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
     *
     * Default: No minimum or maximum limits
     */
    public val networkBandwidthGbps: aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest? = builder.networkBandwidthGbps
    /**
     * The minimum and maximum number of network interfaces for an instance type.
     *
     * Default: No minimum or maximum limits
     */
    public val networkInterfaceCount: aws.sdk.kotlin.services.autoscaling.model.NetworkInterfaceCountRequest? = builder.networkInterfaceCount
    /**
     * The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as `999999`.
     *
     * If you set `DesiredCapacityType` to `vcpu` or `memory-mib`, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     *
     * Default: `20`
     */
    public val onDemandMaxPricePercentageOverLowestPrice: kotlin.Int? = builder.onDemandMaxPricePercentageOverLowestPrice
    /**
     * Indicates whether instance types must provide On-Demand Instance hibernation support.
     *
     * Default: `false`
     */
    public val requireHibernateSupport: kotlin.Boolean? = builder.requireHibernateSupport
    /**
     * The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as `999999`.
     *
     * If you set `DesiredCapacityType` to `vcpu` or `memory-mib`, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     *
     * Default: `100`
     */
    public val spotMaxPricePercentageOverLowestPrice: kotlin.Int? = builder.spotMaxPricePercentageOverLowestPrice
    /**
     * The minimum and maximum total local storage size for an instance type, in GB.
     *
     * Default: No minimum or maximum limits
     */
    public val totalLocalStorageGb: aws.sdk.kotlin.services.autoscaling.model.TotalLocalStorageGbRequest? = builder.totalLocalStorageGb
    /**
     * The minimum and maximum number of vCPUs for an instance type.
     */
    public val vCpuCount: aws.sdk.kotlin.services.autoscaling.model.VCpuCountRequest? = builder.vCpuCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceRequirements(")
        append("acceleratorCount=$acceleratorCount,")
        append("acceleratorManufacturers=$acceleratorManufacturers,")
        append("acceleratorNames=$acceleratorNames,")
        append("acceleratorTotalMemoryMib=$acceleratorTotalMemoryMib,")
        append("acceleratorTypes=$acceleratorTypes,")
        append("allowedInstanceTypes=$allowedInstanceTypes,")
        append("bareMetal=$bareMetal,")
        append("baselineEbsBandwidthMbps=$baselineEbsBandwidthMbps,")
        append("burstablePerformance=$burstablePerformance,")
        append("cpuManufacturers=$cpuManufacturers,")
        append("excludedInstanceTypes=$excludedInstanceTypes,")
        append("instanceGenerations=$instanceGenerations,")
        append("localStorage=$localStorage,")
        append("localStorageTypes=$localStorageTypes,")
        append("memoryGibPerVCpu=$memoryGibPerVCpu,")
        append("memoryMib=$memoryMib,")
        append("networkBandwidthGbps=$networkBandwidthGbps,")
        append("networkInterfaceCount=$networkInterfaceCount,")
        append("onDemandMaxPricePercentageOverLowestPrice=$onDemandMaxPricePercentageOverLowestPrice,")
        append("requireHibernateSupport=$requireHibernateSupport,")
        append("spotMaxPricePercentageOverLowestPrice=$spotMaxPricePercentageOverLowestPrice,")
        append("totalLocalStorageGb=$totalLocalStorageGb,")
        append("vCpuCount=$vCpuCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorCount?.hashCode() ?: 0
        result = 31 * result + (acceleratorManufacturers?.hashCode() ?: 0)
        result = 31 * result + (acceleratorNames?.hashCode() ?: 0)
        result = 31 * result + (acceleratorTotalMemoryMib?.hashCode() ?: 0)
        result = 31 * result + (acceleratorTypes?.hashCode() ?: 0)
        result = 31 * result + (allowedInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (bareMetal?.hashCode() ?: 0)
        result = 31 * result + (baselineEbsBandwidthMbps?.hashCode() ?: 0)
        result = 31 * result + (burstablePerformance?.hashCode() ?: 0)
        result = 31 * result + (cpuManufacturers?.hashCode() ?: 0)
        result = 31 * result + (excludedInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (instanceGenerations?.hashCode() ?: 0)
        result = 31 * result + (localStorage?.hashCode() ?: 0)
        result = 31 * result + (localStorageTypes?.hashCode() ?: 0)
        result = 31 * result + (memoryGibPerVCpu?.hashCode() ?: 0)
        result = 31 * result + (memoryMib?.hashCode() ?: 0)
        result = 31 * result + (networkBandwidthGbps?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceCount?.hashCode() ?: 0)
        result = 31 * result + (onDemandMaxPricePercentageOverLowestPrice ?: 0)
        result = 31 * result + (requireHibernateSupport?.hashCode() ?: 0)
        result = 31 * result + (spotMaxPricePercentageOverLowestPrice ?: 0)
        result = 31 * result + (totalLocalStorageGb?.hashCode() ?: 0)
        result = 31 * result + (vCpuCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceRequirements

        if (acceleratorCount != other.acceleratorCount) return false
        if (acceleratorManufacturers != other.acceleratorManufacturers) return false
        if (acceleratorNames != other.acceleratorNames) return false
        if (acceleratorTotalMemoryMib != other.acceleratorTotalMemoryMib) return false
        if (acceleratorTypes != other.acceleratorTypes) return false
        if (allowedInstanceTypes != other.allowedInstanceTypes) return false
        if (bareMetal != other.bareMetal) return false
        if (baselineEbsBandwidthMbps != other.baselineEbsBandwidthMbps) return false
        if (burstablePerformance != other.burstablePerformance) return false
        if (cpuManufacturers != other.cpuManufacturers) return false
        if (excludedInstanceTypes != other.excludedInstanceTypes) return false
        if (instanceGenerations != other.instanceGenerations) return false
        if (localStorage != other.localStorage) return false
        if (localStorageTypes != other.localStorageTypes) return false
        if (memoryGibPerVCpu != other.memoryGibPerVCpu) return false
        if (memoryMib != other.memoryMib) return false
        if (networkBandwidthGbps != other.networkBandwidthGbps) return false
        if (networkInterfaceCount != other.networkInterfaceCount) return false
        if (onDemandMaxPricePercentageOverLowestPrice != other.onDemandMaxPricePercentageOverLowestPrice) return false
        if (requireHibernateSupport != other.requireHibernateSupport) return false
        if (spotMaxPricePercentageOverLowestPrice != other.spotMaxPricePercentageOverLowestPrice) return false
        if (totalLocalStorageGb != other.totalLocalStorageGb) return false
        if (vCpuCount != other.vCpuCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) for an instance type.
         *
         * To exclude accelerator-enabled instance types, set `Max` to `0`.
         *
         * Default: No minimum or maximum limits
         */
        public var acceleratorCount: aws.sdk.kotlin.services.autoscaling.model.AcceleratorCountRequest? = null
        /**
         * Indicates whether instance types must have accelerators by specific manufacturers.
         * + For instance types with NVIDIA devices, specify `nvidia`.
         * + For instance types with AMD devices, specify `amd`.
         * + For instance types with Amazon Web Services devices, specify `amazon-web-services`.
         * + For instance types with Xilinx devices, specify `xilinx`.
         *
         * Default: Any manufacturer
         */
        public var acceleratorManufacturers: List<AcceleratorManufacturer>? = null
        /**
         * Lists the accelerators that must be on an instance type.
         * + For instance types with NVIDIA A100 GPUs, specify `a100`.
         * + For instance types with NVIDIA V100 GPUs, specify `v100`.
         * + For instance types with NVIDIA K80 GPUs, specify `k80`.
         * + For instance types with NVIDIA T4 GPUs, specify `t4`.
         * + For instance types with NVIDIA M60 GPUs, specify `m60`.
         * + For instance types with AMD Radeon Pro V520 GPUs, specify `radeon-pro-v520`.
         * + For instance types with Xilinx VU9P FPGAs, specify `vu9p`.
         *
         * Default: Any accelerator
         */
        public var acceleratorNames: List<AcceleratorName>? = null
        /**
         * The minimum and maximum total memory size for the accelerators on an instance type, in MiB.
         *
         * Default: No minimum or maximum limits
         */
        public var acceleratorTotalMemoryMib: aws.sdk.kotlin.services.autoscaling.model.AcceleratorTotalMemoryMibRequest? = null
        /**
         * Lists the accelerator types that must be on an instance type.
         * + For instance types with GPU accelerators, specify `gpu`.
         * + For instance types with FPGA accelerators, specify `fpga`.
         * + For instance types with inference accelerators, specify `inference`.
         *
         * Default: Any accelerator type
         */
        public var acceleratorTypes: List<AcceleratorType>? = null
        /**
         * The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes.
         *
         * You can use strings with one or more wild cards, represented by an asterisk (`*`), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`.
         *
         * For example, if you specify `c5*`, Amazon EC2 Auto Scaling will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, Amazon EC2 Auto Scaling will allow all the M5a instance types, but not the M5n instance types.
         *
         * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
         *
         * Default: All instance types
         */
        public var allowedInstanceTypes: List<String>? = null
        /**
         * Indicates whether bare metal instance types are included, excluded, or required.
         *
         * Default: `excluded`
         */
        public var bareMetal: aws.sdk.kotlin.services.autoscaling.model.BareMetal? = null
        /**
         * The minimum and maximum baseline bandwidth performance for an instance type, in Mbps. For more information, see [Amazon EBS–optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * Default: No minimum or maximum limits
         */
        public var baselineEbsBandwidthMbps: aws.sdk.kotlin.services.autoscaling.model.BaselineEbsBandwidthMbpsRequest? = null
        /**
         * Indicates whether burstable performance instance types are included, excluded, or required. For more information, see [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * Default: `excluded`
         */
        public var burstablePerformance: aws.sdk.kotlin.services.autoscaling.model.BurstablePerformance? = null
        /**
         * Lists which specific CPU manufacturers to include.
         * + For instance types with Intel CPUs, specify `intel`.
         * + For instance types with AMD CPUs, specify `amd`.
         * + For instance types with Amazon Web Services CPUs, specify `amazon-web-services`.
         *
         * Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
         *
         * Default: Any manufacturer
         */
        public var cpuManufacturers: List<CpuManufacturer>? = null
        /**
         * The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (`*`), to exclude an instance family, type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`.
         *
         * For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, Amazon EC2 Auto Scaling will exclude all the M5a instance types, but not the M5n instance types.
         *
         * If you specify `ExcludedInstanceTypes`, you can't specify `AllowedInstanceTypes`.
         *
         * Default: No excluded instance types
         */
        public var excludedInstanceTypes: List<String>? = null
        /**
         * Indicates whether current or previous generation instance types are included.
         * + For current generation instance types, specify `current`. The current generation includes EC2 instance types currently recommended for use. This typically includes the latest two to three generations in each instance family. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide for Linux Instances*.
         * + For previous generation instance types, specify `previous`.
         *
         * Default: Any current or previous generation
         */
        public var instanceGenerations: List<InstanceGeneration>? = null
        /**
         * Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * Default: `included`
         */
        public var localStorage: aws.sdk.kotlin.services.autoscaling.model.LocalStorage? = null
        /**
         * Indicates the type of local storage that is required.
         * + For instance types with hard disk drive (HDD) storage, specify `hdd`.
         * + For instance types with solid state drive (SSD) storage, specify `ssd`.
         *
         * Default: Any local storage type
         */
        public var localStorageTypes: List<LocalStorageType>? = null
        /**
         * The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
         *
         * Default: No minimum or maximum limits
         */
        public var memoryGibPerVCpu: aws.sdk.kotlin.services.autoscaling.model.MemoryGibPerVCpuRequest? = null
        /**
         * The minimum and maximum instance memory size for an instance type, in MiB.
         */
        public var memoryMib: aws.sdk.kotlin.services.autoscaling.model.MemoryMibRequest? = null
        /**
         * The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
         *
         * Default: No minimum or maximum limits
         */
        public var networkBandwidthGbps: aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest? = null
        /**
         * The minimum and maximum number of network interfaces for an instance type.
         *
         * Default: No minimum or maximum limits
         */
        public var networkInterfaceCount: aws.sdk.kotlin.services.autoscaling.model.NetworkInterfaceCountRequest? = null
        /**
         * The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as `999999`.
         *
         * If you set `DesiredCapacityType` to `vcpu` or `memory-mib`, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
         *
         * Default: `20`
         */
        public var onDemandMaxPricePercentageOverLowestPrice: kotlin.Int? = null
        /**
         * Indicates whether instance types must provide On-Demand Instance hibernation support.
         *
         * Default: `false`
         */
        public var requireHibernateSupport: kotlin.Boolean? = null
        /**
         * The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as `999999`.
         *
         * If you set `DesiredCapacityType` to `vcpu` or `memory-mib`, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
         *
         * Default: `100`
         */
        public var spotMaxPricePercentageOverLowestPrice: kotlin.Int? = null
        /**
         * The minimum and maximum total local storage size for an instance type, in GB.
         *
         * Default: No minimum or maximum limits
         */
        public var totalLocalStorageGb: aws.sdk.kotlin.services.autoscaling.model.TotalLocalStorageGbRequest? = null
        /**
         * The minimum and maximum number of vCPUs for an instance type.
         */
        public var vCpuCount: aws.sdk.kotlin.services.autoscaling.model.VCpuCountRequest? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements) : this() {
            this.acceleratorCount = x.acceleratorCount
            this.acceleratorManufacturers = x.acceleratorManufacturers
            this.acceleratorNames = x.acceleratorNames
            this.acceleratorTotalMemoryMib = x.acceleratorTotalMemoryMib
            this.acceleratorTypes = x.acceleratorTypes
            this.allowedInstanceTypes = x.allowedInstanceTypes
            this.bareMetal = x.bareMetal
            this.baselineEbsBandwidthMbps = x.baselineEbsBandwidthMbps
            this.burstablePerformance = x.burstablePerformance
            this.cpuManufacturers = x.cpuManufacturers
            this.excludedInstanceTypes = x.excludedInstanceTypes
            this.instanceGenerations = x.instanceGenerations
            this.localStorage = x.localStorage
            this.localStorageTypes = x.localStorageTypes
            this.memoryGibPerVCpu = x.memoryGibPerVCpu
            this.memoryMib = x.memoryMib
            this.networkBandwidthGbps = x.networkBandwidthGbps
            this.networkInterfaceCount = x.networkInterfaceCount
            this.onDemandMaxPricePercentageOverLowestPrice = x.onDemandMaxPricePercentageOverLowestPrice
            this.requireHibernateSupport = x.requireHibernateSupport
            this.spotMaxPricePercentageOverLowestPrice = x.spotMaxPricePercentageOverLowestPrice
            this.totalLocalStorageGb = x.totalLocalStorageGb
            this.vCpuCount = x.vCpuCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.InstanceRequirements = InstanceRequirements(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.AcceleratorCountRequest] inside the given [block]
         */
        public fun acceleratorCount(block: aws.sdk.kotlin.services.autoscaling.model.AcceleratorCountRequest.Builder.() -> kotlin.Unit) {
            this.acceleratorCount = aws.sdk.kotlin.services.autoscaling.model.AcceleratorCountRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.AcceleratorTotalMemoryMibRequest] inside the given [block]
         */
        public fun acceleratorTotalMemoryMib(block: aws.sdk.kotlin.services.autoscaling.model.AcceleratorTotalMemoryMibRequest.Builder.() -> kotlin.Unit) {
            this.acceleratorTotalMemoryMib = aws.sdk.kotlin.services.autoscaling.model.AcceleratorTotalMemoryMibRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.BaselineEbsBandwidthMbpsRequest] inside the given [block]
         */
        public fun baselineEbsBandwidthMbps(block: aws.sdk.kotlin.services.autoscaling.model.BaselineEbsBandwidthMbpsRequest.Builder.() -> kotlin.Unit) {
            this.baselineEbsBandwidthMbps = aws.sdk.kotlin.services.autoscaling.model.BaselineEbsBandwidthMbpsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.MemoryGibPerVCpuRequest] inside the given [block]
         */
        public fun memoryGibPerVCpu(block: aws.sdk.kotlin.services.autoscaling.model.MemoryGibPerVCpuRequest.Builder.() -> kotlin.Unit) {
            this.memoryGibPerVCpu = aws.sdk.kotlin.services.autoscaling.model.MemoryGibPerVCpuRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.MemoryMibRequest] inside the given [block]
         */
        public fun memoryMib(block: aws.sdk.kotlin.services.autoscaling.model.MemoryMibRequest.Builder.() -> kotlin.Unit) {
            this.memoryMib = aws.sdk.kotlin.services.autoscaling.model.MemoryMibRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest] inside the given [block]
         */
        public fun networkBandwidthGbps(block: aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest.Builder.() -> kotlin.Unit) {
            this.networkBandwidthGbps = aws.sdk.kotlin.services.autoscaling.model.NetworkBandwidthGbpsRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.NetworkInterfaceCountRequest] inside the given [block]
         */
        public fun networkInterfaceCount(block: aws.sdk.kotlin.services.autoscaling.model.NetworkInterfaceCountRequest.Builder.() -> kotlin.Unit) {
            this.networkInterfaceCount = aws.sdk.kotlin.services.autoscaling.model.NetworkInterfaceCountRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.TotalLocalStorageGbRequest] inside the given [block]
         */
        public fun totalLocalStorageGb(block: aws.sdk.kotlin.services.autoscaling.model.TotalLocalStorageGbRequest.Builder.() -> kotlin.Unit) {
            this.totalLocalStorageGb = aws.sdk.kotlin.services.autoscaling.model.TotalLocalStorageGbRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.VCpuCountRequest] inside the given [block]
         */
        public fun vCpuCount(block: aws.sdk.kotlin.services.autoscaling.model.VCpuCountRequest.Builder.() -> kotlin.Unit) {
            this.vCpuCount = aws.sdk.kotlin.services.autoscaling.model.VCpuCountRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
