// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes an instance maintenance policy.
 *
 * For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public class InstanceMaintenancePolicy private constructor(builder: Builder) {
    /**
     * Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. Value range is 100 to 200. After it's set, a value of `-1` will clear the previously set value.
     *
     * Both `MinHealthyPercentage` and `MaxHealthyPercentage` must be specified, and the difference between them cannot be greater than 100. A large range increases the number of instances that can be replaced at the same time.
     */
    public val maxHealthyPercentage: kotlin.Int? = builder.maxHealthyPercentage
    /**
     * Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when replacing instances. Value range is 0 to 100. After it's set, a value of `-1` will clear the previously set value.
     */
    public val minHealthyPercentage: kotlin.Int? = builder.minHealthyPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceMaintenancePolicy(")
        append("maxHealthyPercentage=$maxHealthyPercentage,")
        append("minHealthyPercentage=$minHealthyPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxHealthyPercentage ?: 0
        result = 31 * result + (minHealthyPercentage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceMaintenancePolicy

        if (maxHealthyPercentage != other.maxHealthyPercentage) return false
        if (minHealthyPercentage != other.minHealthyPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. Value range is 100 to 200. After it's set, a value of `-1` will clear the previously set value.
         *
         * Both `MinHealthyPercentage` and `MaxHealthyPercentage` must be specified, and the difference between them cannot be greater than 100. A large range increases the number of instances that can be replaced at the same time.
         */
        public var maxHealthyPercentage: kotlin.Int? = null
        /**
         * Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. It represents the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload when replacing instances. Value range is 0 to 100. After it's set, a value of `-1` will clear the previously set value.
         */
        public var minHealthyPercentage: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy) : this() {
            this.maxHealthyPercentage = x.maxHealthyPercentage
            this.minHealthyPercentage = x.minHealthyPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy = InstanceMaintenancePolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
