// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



public class ExecutePolicyRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The breach threshold for the alarm.
     *
     * Required if the policy type is `StepScaling` and not supported otherwise.
     */
    public val breachThreshold: kotlin.Double? = builder.breachThreshold
    /**
     * Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.
     *
     * Valid only if the policy type is `SimpleScaling`. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val honorCooldown: kotlin.Boolean? = builder.honorCooldown
    /**
     * The metric value to compare to `BreachThreshold`. This enables you to execute a policy of type `StepScaling` and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.
     *
     * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an error.
     *
     * Required if the policy type is `StepScaling` and not supported otherwise.
     */
    public val metricValue: kotlin.Double? = builder.metricValue
    /**
     * The name or ARN of the policy.
     */
    public val policyName: kotlin.String? = builder.policyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.ExecutePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutePolicyRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("breachThreshold=$breachThreshold,")
        append("honorCooldown=$honorCooldown,")
        append("metricValue=$metricValue,")
        append("policyName=$policyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (breachThreshold?.hashCode() ?: 0)
        result = 31 * result + (honorCooldown?.hashCode() ?: 0)
        result = 31 * result + (metricValue?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutePolicyRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (breachThreshold != other.breachThreshold) return false
        if (honorCooldown != other.honorCooldown) return false
        if (metricValue != other.metricValue) return false
        if (policyName != other.policyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.ExecutePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The breach threshold for the alarm.
         *
         * Required if the policy type is `StepScaling` and not supported otherwise.
         */
        public var breachThreshold: kotlin.Double? = null
        /**
         * Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.
         *
         * Valid only if the policy type is `SimpleScaling`. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var honorCooldown: kotlin.Boolean? = null
        /**
         * The metric value to compare to `BreachThreshold`. This enables you to execute a policy of type `StepScaling` and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.
         *
         * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an error.
         *
         * Required if the policy type is `StepScaling` and not supported otherwise.
         */
        public var metricValue: kotlin.Double? = null
        /**
         * The name or ARN of the policy.
         */
        public var policyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.ExecutePolicyRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.breachThreshold = x.breachThreshold
            this.honorCooldown = x.honorCooldown
            this.metricValue = x.metricValue
            this.policyName = x.policyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.ExecutePolicyRequest = ExecutePolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
