// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



public class CreateAutoScalingGroupRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group. This name must be unique per Region per account.
     *
     * The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
     *
     * You cannot use a colon (:) in the name.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `VPCZoneIdentifier` property, or for attaching a network interface when an existing network interface ID is specified in a launch template.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val capacityRebalance: kotlin.Boolean? = builder.capacityRebalance
    /**
     * Reserved.
     */
    public val context: kotlin.String? = builder.context
    /**
     * *Only needed if you use simple scaling policies.*
     *
     * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Default: `300` seconds
     */
    public val defaultCooldown: kotlin.Int? = builder.defaultCooldown
    /**
     * The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the `InService` state.
     *
     * During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify `-1` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of `0` or other nominal value.
     *
     * Default: None
     */
    public val defaultInstanceWarmup: kotlin.Int? = builder.defaultInstanceWarmup
    /**
     * The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.
     */
    public val desiredCapacity: kotlin.Int? = builder.desiredCapacity
    /**
     * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports `DesiredCapacityType` for attribute-based instance type selection only. For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * By default, Amazon EC2 Auto Scaling specifies `units`, which translates into number of instances.
     *
     * Valid values: `units` | `vcpu` | `memory-mib`
     */
    public val desiredCapacityType: kotlin.String? = builder.desiredCapacityType
    /**
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the `InService` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Default: `0` seconds
     */
    public val healthCheckGracePeriod: kotlin.Int? = builder.healthCheckGracePeriod
    /**
     * A comma-separated value string of one or more health check types.
     *
     * The valid values are `EC2`, `ELB`, and `VPC_LATTICE`. `EC2` is the default health check and cannot be disabled. For more information, see [Health checks for Auto Scaling instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Only specify `EC2` if you must clear a value that was previously set.
     */
    public val healthCheckType: kotlin.String? = builder.healthCheckType
    /**
     * The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html) API operation. For more information, see [Creating an Auto Scaling group using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val instanceMaintenancePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy? = builder.instanceMaintenancePolicy
    /**
     * The name of the launch configuration to use to launch instances.
     *
     * Conditional: You must specify either a launch template (`LaunchTemplate` or `MixedInstancesPolicy`) or a launch configuration (`LaunchConfigurationName` or `InstanceId`).
     */
    public val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * Information used to specify the launch template and version to use to launch instances.
     *
     * Conditional: You must specify either a launch template (`LaunchTemplate` or `MixedInstancesPolicy`) or a launch configuration (`LaunchConfigurationName` or `InstanceId`).
     *
     * The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see [Creating a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
     */
    public val lifecycleHookSpecificationList: List<LifecycleHookSpecification>? = builder.lifecycleHookSpecificationList
    /**
     * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the `TargetGroupARNs` property instead.
     */
    public val loadBalancerNames: List<String>? = builder.loadBalancerNames
    /**
     * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see [Replacing Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val maxInstanceLifetime: kotlin.Int? = builder.maxInstanceLifetime
    /**
     * The maximum size of the group.
     *
     * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above `MaxSize` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above `MaxSize` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum size of the group.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The mixed instances policy. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = builder.mixedInstancesPolicy
    /**
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val newInstancesProtectedFromScaleIn: kotlin.Boolean? = builder.newInstancesProtectedFromScaleIn
    /**
     * The name of the placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
     */
    public val placementGroup: kotlin.String? = builder.placementGroup
    /**
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named `AWSServiceRoleForAutoScaling`, which it creates if it does not exist. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val serviceLinkedRoleArn: kotlin.String? = builder.serviceLinkedRoleArn
    /**
     * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and route requests to one or more registered targets. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val targetGroupArns: List<String>? = builder.targetGroupArns
    /**
     * A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see [Work with Amazon EC2 Auto Scaling termination policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Valid values: `Default` | `AllocationStrategy` | `ClosestToNextInstanceHour` | `NewestInstance` | `OldestInstance` | `OldestLaunchConfiguration` | `OldestLaunchTemplate` | `arn:aws:lambda:region:account-id:function:my-function:my-alias`
     */
    public val terminationPolicies: List<String>? = builder.terminationPolicies
    /**
     * The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as traffic sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway Load Balancer, Network Load Balancer, and VPC Lattice.
     */
    public val trafficSources: List<TrafficSourceIdentifier>? = builder.trafficSources
    /**
     * A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify `VPCZoneIdentifier` with `AvailabilityZones`, the subnets that you specify must reside in those Availability Zones.
     */
    public val vpcZoneIdentifier: kotlin.String? = builder.vpcZoneIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.CreateAutoScalingGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAutoScalingGroupRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("availabilityZones=$availabilityZones,")
        append("capacityRebalance=$capacityRebalance,")
        append("context=$context,")
        append("defaultCooldown=$defaultCooldown,")
        append("defaultInstanceWarmup=$defaultInstanceWarmup,")
        append("desiredCapacity=$desiredCapacity,")
        append("desiredCapacityType=$desiredCapacityType,")
        append("healthCheckGracePeriod=$healthCheckGracePeriod,")
        append("healthCheckType=$healthCheckType,")
        append("instanceId=$instanceId,")
        append("instanceMaintenancePolicy=$instanceMaintenancePolicy,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("launchTemplate=$launchTemplate,")
        append("lifecycleHookSpecificationList=$lifecycleHookSpecificationList,")
        append("loadBalancerNames=$loadBalancerNames,")
        append("maxInstanceLifetime=$maxInstanceLifetime,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("mixedInstancesPolicy=$mixedInstancesPolicy,")
        append("newInstancesProtectedFromScaleIn=$newInstancesProtectedFromScaleIn,")
        append("placementGroup=$placementGroup,")
        append("serviceLinkedRoleArn=$serviceLinkedRoleArn,")
        append("tags=$tags,")
        append("targetGroupArns=$targetGroupArns,")
        append("terminationPolicies=$terminationPolicies,")
        append("trafficSources=$trafficSources,")
        append("vpcZoneIdentifier=$vpcZoneIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (capacityRebalance?.hashCode() ?: 0)
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (defaultCooldown ?: 0)
        result = 31 * result + (defaultInstanceWarmup ?: 0)
        result = 31 * result + (desiredCapacity ?: 0)
        result = 31 * result + (desiredCapacityType?.hashCode() ?: 0)
        result = 31 * result + (healthCheckGracePeriod ?: 0)
        result = 31 * result + (healthCheckType?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceMaintenancePolicy?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (lifecycleHookSpecificationList?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerNames?.hashCode() ?: 0)
        result = 31 * result + (maxInstanceLifetime ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (mixedInstancesPolicy?.hashCode() ?: 0)
        result = 31 * result + (newInstancesProtectedFromScaleIn?.hashCode() ?: 0)
        result = 31 * result + (placementGroup?.hashCode() ?: 0)
        result = 31 * result + (serviceLinkedRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArns?.hashCode() ?: 0)
        result = 31 * result + (terminationPolicies?.hashCode() ?: 0)
        result = 31 * result + (trafficSources?.hashCode() ?: 0)
        result = 31 * result + (vpcZoneIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAutoScalingGroupRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (availabilityZones != other.availabilityZones) return false
        if (capacityRebalance != other.capacityRebalance) return false
        if (context != other.context) return false
        if (defaultCooldown != other.defaultCooldown) return false
        if (defaultInstanceWarmup != other.defaultInstanceWarmup) return false
        if (desiredCapacity != other.desiredCapacity) return false
        if (desiredCapacityType != other.desiredCapacityType) return false
        if (healthCheckGracePeriod != other.healthCheckGracePeriod) return false
        if (healthCheckType != other.healthCheckType) return false
        if (instanceId != other.instanceId) return false
        if (instanceMaintenancePolicy != other.instanceMaintenancePolicy) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (launchTemplate != other.launchTemplate) return false
        if (lifecycleHookSpecificationList != other.lifecycleHookSpecificationList) return false
        if (loadBalancerNames != other.loadBalancerNames) return false
        if (maxInstanceLifetime != other.maxInstanceLifetime) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (mixedInstancesPolicy != other.mixedInstancesPolicy) return false
        if (newInstancesProtectedFromScaleIn != other.newInstancesProtectedFromScaleIn) return false
        if (placementGroup != other.placementGroup) return false
        if (serviceLinkedRoleArn != other.serviceLinkedRoleArn) return false
        if (tags != other.tags) return false
        if (targetGroupArns != other.targetGroupArns) return false
        if (terminationPolicies != other.terminationPolicies) return false
        if (trafficSources != other.trafficSources) return false
        if (vpcZoneIdentifier != other.vpcZoneIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.CreateAutoScalingGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Auto Scaling group. This name must be unique per Region per account.
         *
         * The name can contain any ASCII character 33 to 126 including most punctuation characters, digits, and upper and lowercased letters.
         *
         * You cannot use a colon (:) in the name.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `VPCZoneIdentifier` property, or for attaching a network interface when an existing network interface ID is specified in a launch template.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see [Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html) in the in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var capacityRebalance: kotlin.Boolean? = null
        /**
         * Reserved.
         */
        public var context: kotlin.String? = null
        /**
         * *Only needed if you use simple scaling policies.*
         *
         * The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Default: `300` seconds
         */
        public var defaultCooldown: kotlin.Int? = null
        /**
         * The amount of time, in seconds, until a new instance is considered to have finished initializing and resource consumption to become stable after it enters the `InService` state.
         *
         * During an instance refresh, Amazon EC2 Auto Scaling waits for the warm-up period after it replaces an instance before it moves on to replacing the next instance. Amazon EC2 Auto Scaling also waits for the warm-up period before aggregating the metrics for new instances with existing instances in the Amazon CloudWatch metrics that are used for scaling, resulting in more reliable usage data. For more information, see [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * To manage various warm-up settings at the group level, we recommend that you set the default instance warmup, *even if it is set to 0 seconds*. To remove a value that you previously set, include the property but specify `-1` for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a value of `0` or other nominal value.
         *
         * Default: None
         */
        public var defaultInstanceWarmup: kotlin.Int? = null
        /**
         * The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.
         */
        public var desiredCapacity: kotlin.Int? = null
        /**
         * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports `DesiredCapacityType` for attribute-based instance type selection only. For more information, see [Creating an Auto Scaling group using attribute-based instance type selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * By default, Amazon EC2 Auto Scaling specifies `units`, which translates into number of instances.
         *
         * Valid values: `units` | `vcpu` | `memory-mib`
         */
        public var desiredCapacityType: kotlin.String? = null
        /**
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check. This is useful if your instances do not immediately pass their health checks after they enter the `InService` state. For more information, see [Set the health check grace period for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Default: `0` seconds
         */
        public var healthCheckGracePeriod: kotlin.Int? = null
        /**
         * A comma-separated value string of one or more health check types.
         *
         * The valid values are `EC2`, `ELB`, and `VPC_LATTICE`. `EC2` is the default health check and cannot be disabled. For more information, see [Health checks for Auto Scaling instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Only specify `EC2` if you must clear a value that was previously set.
         */
        public var healthCheckType: kotlin.String? = null
        /**
         * The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html) API operation. For more information, see [Creating an Auto Scaling group using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var instanceId: kotlin.String? = null
        /**
         * An instance maintenance policy. For more information, see [Set instance maintenance policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var instanceMaintenancePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy? = null
        /**
         * The name of the launch configuration to use to launch instances.
         *
         * Conditional: You must specify either a launch template (`LaunchTemplate` or `MixedInstancesPolicy`) or a launch configuration (`LaunchConfigurationName` or `InstanceId`).
         */
        public var launchConfigurationName: kotlin.String? = null
        /**
         * Information used to specify the launch template and version to use to launch instances.
         *
         * Conditional: You must specify either a launch template (`LaunchTemplate` or `MixedInstancesPolicy`) or a launch configuration (`LaunchConfigurationName` or `InstanceId`).
         *
         * The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see [Creating a launch template for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = null
        /**
         * One or more lifecycle hooks to add to the Auto Scaling group before instances are launched.
         */
        public var lifecycleHookSpecificationList: List<LifecycleHookSpecification>? = null
        /**
         * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the `TargetGroupARNs` property instead.
         */
        public var loadBalancerNames: List<String>? = null
        /**
         * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see [Replacing Auto Scaling instances based on maximum instance lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var maxInstanceLifetime: kotlin.Int? = null
        /**
         * The maximum size of the group.
         *
         * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above `MaxSize` to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above `MaxSize` by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum size of the group.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The mixed instances policy. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = null
        /**
         * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var newInstancesProtectedFromScaleIn: kotlin.Boolean? = null
        /**
         * The name of the placement group into which to launch your instances. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * A *cluster* placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
         */
        public var placementGroup: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services service on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named `AWSServiceRoleForAutoScaling`, which it creates if it does not exist. For more information, see [Service-linked roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var serviceLinkedRoleArn: kotlin.String? = null
        /**
         * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon Resource Names (ARN) of the Elastic Load Balancing target groups to associate with the Auto Scaling group. Instances are registered as targets with the target groups. The target groups receive incoming traffic and route requests to one or more registered targets. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var targetGroupArns: List<String>? = null
        /**
         * A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see [Work with Amazon EC2 Auto Scaling termination policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Valid values: `Default` | `AllocationStrategy` | `ClosestToNextInstanceHour` | `NewestInstance` | `OldestInstance` | `OldestLaunchConfiguration` | `OldestLaunchTemplate` | `arn:aws:lambda:region:account-id:function:my-function:my-alias`
         */
        public var terminationPolicies: List<String>? = null
        /**
         * The list of traffic sources to attach to this Auto Scaling group. You can use any of the following as traffic sources for an Auto Scaling group: Classic Load Balancer, Application Load Balancer, Gateway Load Balancer, Network Load Balancer, and VPC Lattice.
         */
        public var trafficSources: List<TrafficSourceIdentifier>? = null
        /**
         * A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify `VPCZoneIdentifier` with `AvailabilityZones`, the subnets that you specify must reside in those Availability Zones.
         */
        public var vpcZoneIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.CreateAutoScalingGroupRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.availabilityZones = x.availabilityZones
            this.capacityRebalance = x.capacityRebalance
            this.context = x.context
            this.defaultCooldown = x.defaultCooldown
            this.defaultInstanceWarmup = x.defaultInstanceWarmup
            this.desiredCapacity = x.desiredCapacity
            this.desiredCapacityType = x.desiredCapacityType
            this.healthCheckGracePeriod = x.healthCheckGracePeriod
            this.healthCheckType = x.healthCheckType
            this.instanceId = x.instanceId
            this.instanceMaintenancePolicy = x.instanceMaintenancePolicy
            this.launchConfigurationName = x.launchConfigurationName
            this.launchTemplate = x.launchTemplate
            this.lifecycleHookSpecificationList = x.lifecycleHookSpecificationList
            this.loadBalancerNames = x.loadBalancerNames
            this.maxInstanceLifetime = x.maxInstanceLifetime
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.mixedInstancesPolicy = x.mixedInstancesPolicy
            this.newInstancesProtectedFromScaleIn = x.newInstancesProtectedFromScaleIn
            this.placementGroup = x.placementGroup
            this.serviceLinkedRoleArn = x.serviceLinkedRoleArn
            this.tags = x.tags
            this.targetGroupArns = x.targetGroupArns
            this.terminationPolicies = x.terminationPolicies
            this.trafficSources = x.trafficSources
            this.vpcZoneIdentifier = x.vpcZoneIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.CreateAutoScalingGroupRequest = CreateAutoScalingGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy] inside the given [block]
         */
        public fun instanceMaintenancePolicy(block: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy.Builder.() -> kotlin.Unit) {
            this.instanceMaintenancePolicy = aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy] inside the given [block]
         */
        public fun mixedInstancesPolicy(block: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.Builder.() -> kotlin.Unit) {
            this.mixedInstancesPolicy = aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
