// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Auto Scaling group.
 */
public class AutoScalingGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public val autoScalingGroupArn: kotlin.String? = builder.autoScalingGroupArn
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * One or more Availability Zones for the group.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Indicates whether Capacity Rebalancing is enabled.
     */
    public val capacityRebalance: kotlin.Boolean? = builder.capacityRebalance
    /**
     * Reserved.
     */
    public val context: kotlin.String? = builder.context
    /**
     * The date and time the group was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The duration of the default cooldown period, in seconds.
     */
    public val defaultCooldown: kotlin.Int? = builder.defaultCooldown
    /**
     * The duration of the default instance warmup, in seconds.
     */
    public val defaultInstanceWarmup: kotlin.Int? = builder.defaultInstanceWarmup
    /**
     * The desired size of the group.
     */
    public val desiredCapacity: kotlin.Int? = builder.desiredCapacity
    /**
     * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports `DesiredCapacityType` for attribute-based instance type selection only.
     */
    public val desiredCapacityType: kotlin.String? = builder.desiredCapacityType
    /**
     * The metrics enabled for the group.
     */
    public val enabledMetrics: List<EnabledMetric>? = builder.enabledMetrics
    /**
     * The duration of the health check grace period, in seconds.
     */
    public val healthCheckGracePeriod: kotlin.Int? = builder.healthCheckGracePeriod
    /**
     * A comma-separated value string of one or more health check types.
     */
    public val healthCheckType: kotlin.String? = builder.healthCheckType
    /**
     * An instance maintenance policy.
     */
    public val instanceMaintenancePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy? = builder.instanceMaintenancePolicy
    /**
     * The EC2 instances associated with the group.
     */
    public val instances: List<Instance>? = builder.instances
    /**
     * The name of the associated launch configuration.
     */
    public val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The launch template for the group.
     */
    public val launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * One or more load balancers associated with the group.
     */
    public val loadBalancerNames: List<String>? = builder.loadBalancerNames
    /**
     * The maximum amount of time, in seconds, that an instance can be in service.
     *
     * Valid Range: Minimum value of 0.
     */
    public val maxInstanceLifetime: kotlin.Int? = builder.maxInstanceLifetime
    /**
     * The maximum size of the group.
     */
    public val maxSize: kotlin.Int? = builder.maxSize
    /**
     * The minimum size of the group.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * The mixed instances policy for the group.
     */
    public val mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = builder.mixedInstancesPolicy
    /**
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
     */
    public val newInstancesProtectedFromScaleIn: kotlin.Boolean? = builder.newInstancesProtectedFromScaleIn
    /**
     * The name of the placement group into which to launch your instances, if any.
     */
    public val placementGroup: kotlin.String? = builder.placementGroup
    /**
     * The predicted capacity of the group when it has a predictive scaling policy.
     */
    public val predictedCapacity: kotlin.Int? = builder.predictedCapacity
    /**
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf.
     */
    public val serviceLinkedRoleArn: kotlin.String? = builder.serviceLinkedRoleArn
    /**
     * The current state of the group when the DeleteAutoScalingGroup operation is in progress.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The suspended processes associated with the group.
     */
    public val suspendedProcesses: List<SuspendedProcess>? = builder.suspendedProcesses
    /**
     * The tags for the group.
     */
    public val tags: List<TagDescription>? = builder.tags
    /**
     * The Amazon Resource Names (ARN) of the target groups for your load balancer.
     */
    public val targetGroupArns: List<String>? = builder.targetGroupArns
    /**
     * The termination policies for the group.
     */
    public val terminationPolicies: List<String>? = builder.terminationPolicies
    /**
     * The traffic sources associated with this Auto Scaling group.
     */
    public val trafficSources: List<TrafficSourceIdentifier>? = builder.trafficSources
    /**
     * One or more subnet IDs, if applicable, separated by commas.
     */
    public val vpcZoneIdentifier: kotlin.String? = builder.vpcZoneIdentifier
    /**
     * The warm pool for the group.
     */
    public val warmPoolConfiguration: aws.sdk.kotlin.services.autoscaling.model.WarmPoolConfiguration? = builder.warmPoolConfiguration
    /**
     * The current size of the warm pool.
     */
    public val warmPoolSize: kotlin.Int? = builder.warmPoolSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.AutoScalingGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroup(")
        append("autoScalingGroupArn=$autoScalingGroupArn,")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("availabilityZones=$availabilityZones,")
        append("capacityRebalance=$capacityRebalance,")
        append("context=$context,")
        append("createdTime=$createdTime,")
        append("defaultCooldown=$defaultCooldown,")
        append("defaultInstanceWarmup=$defaultInstanceWarmup,")
        append("desiredCapacity=$desiredCapacity,")
        append("desiredCapacityType=$desiredCapacityType,")
        append("enabledMetrics=$enabledMetrics,")
        append("healthCheckGracePeriod=$healthCheckGracePeriod,")
        append("healthCheckType=$healthCheckType,")
        append("instanceMaintenancePolicy=$instanceMaintenancePolicy,")
        append("instances=$instances,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("launchTemplate=$launchTemplate,")
        append("loadBalancerNames=$loadBalancerNames,")
        append("maxInstanceLifetime=$maxInstanceLifetime,")
        append("maxSize=$maxSize,")
        append("minSize=$minSize,")
        append("mixedInstancesPolicy=$mixedInstancesPolicy,")
        append("newInstancesProtectedFromScaleIn=$newInstancesProtectedFromScaleIn,")
        append("placementGroup=$placementGroup,")
        append("predictedCapacity=$predictedCapacity,")
        append("serviceLinkedRoleArn=$serviceLinkedRoleArn,")
        append("status=$status,")
        append("suspendedProcesses=$suspendedProcesses,")
        append("tags=$tags,")
        append("targetGroupArns=$targetGroupArns,")
        append("terminationPolicies=$terminationPolicies,")
        append("trafficSources=$trafficSources,")
        append("vpcZoneIdentifier=$vpcZoneIdentifier,")
        append("warmPoolConfiguration=$warmPoolConfiguration,")
        append("warmPoolSize=$warmPoolSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupArn?.hashCode() ?: 0
        result = 31 * result + (autoScalingGroupName?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (capacityRebalance?.hashCode() ?: 0)
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (defaultCooldown ?: 0)
        result = 31 * result + (defaultInstanceWarmup ?: 0)
        result = 31 * result + (desiredCapacity ?: 0)
        result = 31 * result + (desiredCapacityType?.hashCode() ?: 0)
        result = 31 * result + (enabledMetrics?.hashCode() ?: 0)
        result = 31 * result + (healthCheckGracePeriod ?: 0)
        result = 31 * result + (healthCheckType?.hashCode() ?: 0)
        result = 31 * result + (instanceMaintenancePolicy?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerNames?.hashCode() ?: 0)
        result = 31 * result + (maxInstanceLifetime ?: 0)
        result = 31 * result + (maxSize ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (mixedInstancesPolicy?.hashCode() ?: 0)
        result = 31 * result + (newInstancesProtectedFromScaleIn?.hashCode() ?: 0)
        result = 31 * result + (placementGroup?.hashCode() ?: 0)
        result = 31 * result + (predictedCapacity ?: 0)
        result = 31 * result + (serviceLinkedRoleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (suspendedProcesses?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArns?.hashCode() ?: 0)
        result = 31 * result + (terminationPolicies?.hashCode() ?: 0)
        result = 31 * result + (trafficSources?.hashCode() ?: 0)
        result = 31 * result + (vpcZoneIdentifier?.hashCode() ?: 0)
        result = 31 * result + (warmPoolConfiguration?.hashCode() ?: 0)
        result = 31 * result + (warmPoolSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroup

        if (autoScalingGroupArn != other.autoScalingGroupArn) return false
        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (availabilityZones != other.availabilityZones) return false
        if (capacityRebalance != other.capacityRebalance) return false
        if (context != other.context) return false
        if (createdTime != other.createdTime) return false
        if (defaultCooldown != other.defaultCooldown) return false
        if (defaultInstanceWarmup != other.defaultInstanceWarmup) return false
        if (desiredCapacity != other.desiredCapacity) return false
        if (desiredCapacityType != other.desiredCapacityType) return false
        if (enabledMetrics != other.enabledMetrics) return false
        if (healthCheckGracePeriod != other.healthCheckGracePeriod) return false
        if (healthCheckType != other.healthCheckType) return false
        if (instanceMaintenancePolicy != other.instanceMaintenancePolicy) return false
        if (instances != other.instances) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (launchTemplate != other.launchTemplate) return false
        if (loadBalancerNames != other.loadBalancerNames) return false
        if (maxInstanceLifetime != other.maxInstanceLifetime) return false
        if (maxSize != other.maxSize) return false
        if (minSize != other.minSize) return false
        if (mixedInstancesPolicy != other.mixedInstancesPolicy) return false
        if (newInstancesProtectedFromScaleIn != other.newInstancesProtectedFromScaleIn) return false
        if (placementGroup != other.placementGroup) return false
        if (predictedCapacity != other.predictedCapacity) return false
        if (serviceLinkedRoleArn != other.serviceLinkedRoleArn) return false
        if (status != other.status) return false
        if (suspendedProcesses != other.suspendedProcesses) return false
        if (tags != other.tags) return false
        if (targetGroupArns != other.targetGroupArns) return false
        if (terminationPolicies != other.terminationPolicies) return false
        if (trafficSources != other.trafficSources) return false
        if (vpcZoneIdentifier != other.vpcZoneIdentifier) return false
        if (warmPoolConfiguration != other.warmPoolConfiguration) return false
        if (warmPoolSize != other.warmPoolSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.AutoScalingGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Auto Scaling group.
         */
        public var autoScalingGroupArn: kotlin.String? = null
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * One or more Availability Zones for the group.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Indicates whether Capacity Rebalancing is enabled.
         */
        public var capacityRebalance: kotlin.Boolean? = null
        /**
         * Reserved.
         */
        public var context: kotlin.String? = null
        /**
         * The date and time the group was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The duration of the default cooldown period, in seconds.
         */
        public var defaultCooldown: kotlin.Int? = null
        /**
         * The duration of the default instance warmup, in seconds.
         */
        public var defaultInstanceWarmup: kotlin.Int? = null
        /**
         * The desired size of the group.
         */
        public var desiredCapacity: kotlin.Int? = null
        /**
         * The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports `DesiredCapacityType` for attribute-based instance type selection only.
         */
        public var desiredCapacityType: kotlin.String? = null
        /**
         * The metrics enabled for the group.
         */
        public var enabledMetrics: List<EnabledMetric>? = null
        /**
         * The duration of the health check grace period, in seconds.
         */
        public var healthCheckGracePeriod: kotlin.Int? = null
        /**
         * A comma-separated value string of one or more health check types.
         */
        public var healthCheckType: kotlin.String? = null
        /**
         * An instance maintenance policy.
         */
        public var instanceMaintenancePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy? = null
        /**
         * The EC2 instances associated with the group.
         */
        public var instances: List<Instance>? = null
        /**
         * The name of the associated launch configuration.
         */
        public var launchConfigurationName: kotlin.String? = null
        /**
         * The launch template for the group.
         */
        public var launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = null
        /**
         * One or more load balancers associated with the group.
         */
        public var loadBalancerNames: List<String>? = null
        /**
         * The maximum amount of time, in seconds, that an instance can be in service.
         *
         * Valid Range: Minimum value of 0.
         */
        public var maxInstanceLifetime: kotlin.Int? = null
        /**
         * The maximum size of the group.
         */
        public var maxSize: kotlin.Int? = null
        /**
         * The minimum size of the group.
         */
        public var minSize: kotlin.Int? = null
        /**
         * The mixed instances policy for the group.
         */
        public var mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = null
        /**
         * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
         */
        public var newInstancesProtectedFromScaleIn: kotlin.Boolean? = null
        /**
         * The name of the placement group into which to launch your instances, if any.
         */
        public var placementGroup: kotlin.String? = null
        /**
         * The predicted capacity of the group when it has a predictive scaling policy.
         */
        public var predictedCapacity: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf.
         */
        public var serviceLinkedRoleArn: kotlin.String? = null
        /**
         * The current state of the group when the DeleteAutoScalingGroup operation is in progress.
         */
        public var status: kotlin.String? = null
        /**
         * The suspended processes associated with the group.
         */
        public var suspendedProcesses: List<SuspendedProcess>? = null
        /**
         * The tags for the group.
         */
        public var tags: List<TagDescription>? = null
        /**
         * The Amazon Resource Names (ARN) of the target groups for your load balancer.
         */
        public var targetGroupArns: List<String>? = null
        /**
         * The termination policies for the group.
         */
        public var terminationPolicies: List<String>? = null
        /**
         * The traffic sources associated with this Auto Scaling group.
         */
        public var trafficSources: List<TrafficSourceIdentifier>? = null
        /**
         * One or more subnet IDs, if applicable, separated by commas.
         */
        public var vpcZoneIdentifier: kotlin.String? = null
        /**
         * The warm pool for the group.
         */
        public var warmPoolConfiguration: aws.sdk.kotlin.services.autoscaling.model.WarmPoolConfiguration? = null
        /**
         * The current size of the warm pool.
         */
        public var warmPoolSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.AutoScalingGroup) : this() {
            this.autoScalingGroupArn = x.autoScalingGroupArn
            this.autoScalingGroupName = x.autoScalingGroupName
            this.availabilityZones = x.availabilityZones
            this.capacityRebalance = x.capacityRebalance
            this.context = x.context
            this.createdTime = x.createdTime
            this.defaultCooldown = x.defaultCooldown
            this.defaultInstanceWarmup = x.defaultInstanceWarmup
            this.desiredCapacity = x.desiredCapacity
            this.desiredCapacityType = x.desiredCapacityType
            this.enabledMetrics = x.enabledMetrics
            this.healthCheckGracePeriod = x.healthCheckGracePeriod
            this.healthCheckType = x.healthCheckType
            this.instanceMaintenancePolicy = x.instanceMaintenancePolicy
            this.instances = x.instances
            this.launchConfigurationName = x.launchConfigurationName
            this.launchTemplate = x.launchTemplate
            this.loadBalancerNames = x.loadBalancerNames
            this.maxInstanceLifetime = x.maxInstanceLifetime
            this.maxSize = x.maxSize
            this.minSize = x.minSize
            this.mixedInstancesPolicy = x.mixedInstancesPolicy
            this.newInstancesProtectedFromScaleIn = x.newInstancesProtectedFromScaleIn
            this.placementGroup = x.placementGroup
            this.predictedCapacity = x.predictedCapacity
            this.serviceLinkedRoleArn = x.serviceLinkedRoleArn
            this.status = x.status
            this.suspendedProcesses = x.suspendedProcesses
            this.tags = x.tags
            this.targetGroupArns = x.targetGroupArns
            this.terminationPolicies = x.terminationPolicies
            this.trafficSources = x.trafficSources
            this.vpcZoneIdentifier = x.vpcZoneIdentifier
            this.warmPoolConfiguration = x.warmPoolConfiguration
            this.warmPoolSize = x.warmPoolSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.AutoScalingGroup = AutoScalingGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy] inside the given [block]
         */
        public fun instanceMaintenancePolicy(block: aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy.Builder.() -> kotlin.Unit) {
            this.instanceMaintenancePolicy = aws.sdk.kotlin.services.autoscaling.model.InstanceMaintenancePolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy] inside the given [block]
         */
        public fun mixedInstancesPolicy(block: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.Builder.() -> kotlin.Unit) {
            this.mixedInstancesPolicy = aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.WarmPoolConfiguration] inside the given [block]
         */
        public fun warmPoolConfiguration(block: aws.sdk.kotlin.services.autoscaling.model.WarmPoolConfiguration.Builder.() -> kotlin.Unit) {
            this.warmPoolConfiguration = aws.sdk.kotlin.services.autoscaling.model.WarmPoolConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
