// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.autoscaling.auth.AutoScalingAuthSchemeProvider
import aws.sdk.kotlin.services.autoscaling.auth.DefaultAutoScalingAuthSchemeProvider
import aws.sdk.kotlin.services.autoscaling.endpoints.AutoScalingEndpointParameters
import aws.sdk.kotlin.services.autoscaling.endpoints.AutoScalingEndpointProvider
import aws.sdk.kotlin.services.autoscaling.endpoints.DefaultAutoScalingEndpointProvider
import aws.sdk.kotlin.services.autoscaling.model.AttachInstancesRequest
import aws.sdk.kotlin.services.autoscaling.model.AttachInstancesResponse
import aws.sdk.kotlin.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse
import aws.sdk.kotlin.services.autoscaling.model.AttachLoadBalancersRequest
import aws.sdk.kotlin.services.autoscaling.model.AttachLoadBalancersResponse
import aws.sdk.kotlin.services.autoscaling.model.AttachTrafficSourcesRequest
import aws.sdk.kotlin.services.autoscaling.model.AttachTrafficSourcesResponse
import aws.sdk.kotlin.services.autoscaling.model.BatchDeleteScheduledActionRequest
import aws.sdk.kotlin.services.autoscaling.model.BatchDeleteScheduledActionResponse
import aws.sdk.kotlin.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest
import aws.sdk.kotlin.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse
import aws.sdk.kotlin.services.autoscaling.model.CancelInstanceRefreshRequest
import aws.sdk.kotlin.services.autoscaling.model.CancelInstanceRefreshResponse
import aws.sdk.kotlin.services.autoscaling.model.CompleteLifecycleActionRequest
import aws.sdk.kotlin.services.autoscaling.model.CompleteLifecycleActionResponse
import aws.sdk.kotlin.services.autoscaling.model.CreateAutoScalingGroupRequest
import aws.sdk.kotlin.services.autoscaling.model.CreateAutoScalingGroupResponse
import aws.sdk.kotlin.services.autoscaling.model.CreateLaunchConfigurationRequest
import aws.sdk.kotlin.services.autoscaling.model.CreateLaunchConfigurationResponse
import aws.sdk.kotlin.services.autoscaling.model.CreateOrUpdateTagsRequest
import aws.sdk.kotlin.services.autoscaling.model.CreateOrUpdateTagsResponse
import aws.sdk.kotlin.services.autoscaling.model.DeleteAutoScalingGroupRequest
import aws.sdk.kotlin.services.autoscaling.model.DeleteAutoScalingGroupResponse
import aws.sdk.kotlin.services.autoscaling.model.DeleteLaunchConfigurationRequest
import aws.sdk.kotlin.services.autoscaling.model.DeleteLaunchConfigurationResponse
import aws.sdk.kotlin.services.autoscaling.model.DeleteLifecycleHookRequest
import aws.sdk.kotlin.services.autoscaling.model.DeleteLifecycleHookResponse
import aws.sdk.kotlin.services.autoscaling.model.DeleteNotificationConfigurationRequest
import aws.sdk.kotlin.services.autoscaling.model.DeleteNotificationConfigurationResponse
import aws.sdk.kotlin.services.autoscaling.model.DeletePolicyRequest
import aws.sdk.kotlin.services.autoscaling.model.DeletePolicyResponse
import aws.sdk.kotlin.services.autoscaling.model.DeleteScheduledActionRequest
import aws.sdk.kotlin.services.autoscaling.model.DeleteScheduledActionResponse
import aws.sdk.kotlin.services.autoscaling.model.DeleteTagsRequest
import aws.sdk.kotlin.services.autoscaling.model.DeleteTagsResponse
import aws.sdk.kotlin.services.autoscaling.model.DeleteWarmPoolRequest
import aws.sdk.kotlin.services.autoscaling.model.DeleteWarmPoolResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeAdjustmentTypesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAdjustmentTypesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingInstancesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingInstancesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeInstanceRefreshesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeInstanceRefreshesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLaunchConfigurationsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLaunchConfigurationsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLifecycleHookTypesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLifecycleHookTypesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLifecycleHooksRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLifecycleHooksResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeMetricCollectionTypesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeMetricCollectionTypesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeNotificationConfigurationsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeNotificationConfigurationsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribePoliciesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribePoliciesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingActivitiesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingActivitiesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingProcessTypesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingProcessTypesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeScheduledActionsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeTagsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeTagsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeTerminationPolicyTypesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeTerminationPolicyTypesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeTrafficSourcesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeWarmPoolRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeWarmPoolResponse
import aws.sdk.kotlin.services.autoscaling.model.DetachInstancesRequest
import aws.sdk.kotlin.services.autoscaling.model.DetachInstancesResponse
import aws.sdk.kotlin.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse
import aws.sdk.kotlin.services.autoscaling.model.DetachLoadBalancersRequest
import aws.sdk.kotlin.services.autoscaling.model.DetachLoadBalancersResponse
import aws.sdk.kotlin.services.autoscaling.model.DetachTrafficSourcesRequest
import aws.sdk.kotlin.services.autoscaling.model.DetachTrafficSourcesResponse
import aws.sdk.kotlin.services.autoscaling.model.DisableMetricsCollectionRequest
import aws.sdk.kotlin.services.autoscaling.model.DisableMetricsCollectionResponse
import aws.sdk.kotlin.services.autoscaling.model.EnableMetricsCollectionRequest
import aws.sdk.kotlin.services.autoscaling.model.EnableMetricsCollectionResponse
import aws.sdk.kotlin.services.autoscaling.model.EnterStandbyRequest
import aws.sdk.kotlin.services.autoscaling.model.EnterStandbyResponse
import aws.sdk.kotlin.services.autoscaling.model.ExecutePolicyRequest
import aws.sdk.kotlin.services.autoscaling.model.ExecutePolicyResponse
import aws.sdk.kotlin.services.autoscaling.model.ExitStandbyRequest
import aws.sdk.kotlin.services.autoscaling.model.ExitStandbyResponse
import aws.sdk.kotlin.services.autoscaling.model.GetPredictiveScalingForecastRequest
import aws.sdk.kotlin.services.autoscaling.model.GetPredictiveScalingForecastResponse
import aws.sdk.kotlin.services.autoscaling.model.PutLifecycleHookRequest
import aws.sdk.kotlin.services.autoscaling.model.PutLifecycleHookResponse
import aws.sdk.kotlin.services.autoscaling.model.PutNotificationConfigurationRequest
import aws.sdk.kotlin.services.autoscaling.model.PutNotificationConfigurationResponse
import aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyRequest
import aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyResponse
import aws.sdk.kotlin.services.autoscaling.model.PutScheduledUpdateGroupActionRequest
import aws.sdk.kotlin.services.autoscaling.model.PutScheduledUpdateGroupActionResponse
import aws.sdk.kotlin.services.autoscaling.model.PutWarmPoolRequest
import aws.sdk.kotlin.services.autoscaling.model.PutWarmPoolResponse
import aws.sdk.kotlin.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest
import aws.sdk.kotlin.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse
import aws.sdk.kotlin.services.autoscaling.model.ResumeProcessesRequest
import aws.sdk.kotlin.services.autoscaling.model.ResumeProcessesResponse
import aws.sdk.kotlin.services.autoscaling.model.RollbackInstanceRefreshRequest
import aws.sdk.kotlin.services.autoscaling.model.RollbackInstanceRefreshResponse
import aws.sdk.kotlin.services.autoscaling.model.SetDesiredCapacityRequest
import aws.sdk.kotlin.services.autoscaling.model.SetDesiredCapacityResponse
import aws.sdk.kotlin.services.autoscaling.model.SetInstanceHealthRequest
import aws.sdk.kotlin.services.autoscaling.model.SetInstanceHealthResponse
import aws.sdk.kotlin.services.autoscaling.model.SetInstanceProtectionRequest
import aws.sdk.kotlin.services.autoscaling.model.SetInstanceProtectionResponse
import aws.sdk.kotlin.services.autoscaling.model.StartInstanceRefreshRequest
import aws.sdk.kotlin.services.autoscaling.model.StartInstanceRefreshResponse
import aws.sdk.kotlin.services.autoscaling.model.SuspendProcessesRequest
import aws.sdk.kotlin.services.autoscaling.model.SuspendProcessesResponse
import aws.sdk.kotlin.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest
import aws.sdk.kotlin.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse
import aws.sdk.kotlin.services.autoscaling.model.UpdateAutoScalingGroupRequest
import aws.sdk.kotlin.services.autoscaling.model.UpdateAutoScalingGroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Auto Scaling"
public const val SdkVersion: String = "1.0.43"
public const val ServiceApiVersion: String = "2011-01-01"

/**
 * # Amazon EC2 Auto Scaling
 * Amazon EC2 Auto Scaling is designed to automatically launch and terminate EC2 instances based on user-defined scaling policies, scheduled actions, and health checks.
 *
 * For more information, see the [Amazon EC2 Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/) and the [Amazon EC2 Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/Welcome.html).
 */
public interface AutoScalingClient : SdkClient {
    /**
     * AutoScalingClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AutoScalingClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AutoScaling",
                "AUTO_SCALING",
                "auto_scaling",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AutoScalingClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AutoScalingClient = DefaultAutoScalingClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AutoScalingEndpointProvider = builder.endpointProvider ?: DefaultAutoScalingEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AutoScalingAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAutoScalingAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Auto Scaling"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AutoScalingEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AutoScalingAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Attaches one or more EC2 instances to the specified Auto Scaling group.
     *
     * When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of instances being attached. If the number of instances being attached plus the desired capacity of the group exceeds the maximum size of the group, the operation fails.
     *
     * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also registered with the target groups.
     *
     * For more information, see [Attach EC2 instances to your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachInstances.sample
     */
    public suspend fun attachInstances(input: AttachInstancesRequest): AttachInstancesResponse

    /**
     * This API operation is superseded by AttachTrafficSources, which can attach multiple traffic sources types. We recommend using `AttachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `AttachLoadBalancerTargetGroups`. You can use both the original `AttachLoadBalancerTargetGroups` API operation and `AttachTrafficSources` on the same Auto Scaling group.
     *
     * Attaches one or more target groups to the specified Auto Scaling group.
     *
     * This operation is used with the following load balancer types:
     * + Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
     * + Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
     * + Gateway Load Balancer - Operates at the network layer (layer 3).
     *
     * To describe the target groups for an Auto Scaling group, call the DescribeLoadBalancerTargetGroups API. To detach the target group from the Auto Scaling group, call the DetachLoadBalancerTargetGroups API.
     *
     * This operation is additive and does not detach existing target groups or Classic Load Balancers from the Auto Scaling group.
     *
     * For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachLoadBalancerTargetGroups.sample
     */
    public suspend fun attachLoadBalancerTargetGroups(input: AttachLoadBalancerTargetGroupsRequest): AttachLoadBalancerTargetGroupsResponse

    /**
     * This API operation is superseded by AttachTrafficSources, which can attach multiple traffic sources types. We recommend using `AttachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `AttachLoadBalancers`. You can use both the original `AttachLoadBalancers` API operation and `AttachTrafficSources` on the same Auto Scaling group.
     *
     * Attaches one or more Classic Load Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling registers the running instances with these Classic Load Balancers.
     *
     * To describe the load balancers for an Auto Scaling group, call the DescribeLoadBalancers API. To detach a load balancer from the Auto Scaling group, call the DetachLoadBalancers API.
     *
     * This operation is additive and does not detach existing Classic Load Balancers or target groups from the Auto Scaling group.
     *
     * For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachLoadBalancers.sample
     */
    public suspend fun attachLoadBalancers(input: AttachLoadBalancersRequest): AttachLoadBalancersResponse

    /**
     * Attaches one or more traffic sources to the specified Auto Scaling group.
     *
     * You can use any of the following as traffic sources for an Auto Scaling group:
     * + Application Load Balancer
     * + Classic Load Balancer
     * + Gateway Load Balancer
     * + Network Load Balancer
     * + VPC Lattice
     *
     * This operation is additive and does not detach existing traffic sources from the Auto Scaling group.
     *
     * After the operation completes, use the DescribeTrafficSources API to return details about the state of the attachments between traffic sources and your Auto Scaling group. To detach a traffic source from the Auto Scaling group, call the DetachTrafficSources API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachTrafficSources.sample
     */
    public suspend fun attachTrafficSources(input: AttachTrafficSourcesRequest): AttachTrafficSourcesResponse

    /**
     * Deletes one or more scheduled actions for the specified Auto Scaling group.
     */
    public suspend fun batchDeleteScheduledAction(input: BatchDeleteScheduledActionRequest): BatchDeleteScheduledActionResponse

    /**
     * Creates or updates one or more scheduled scaling actions for an Auto Scaling group.
     */
    public suspend fun batchPutScheduledUpdateGroupAction(input: BatchPutScheduledUpdateGroupActionRequest): BatchPutScheduledUpdateGroupActionResponse

    /**
     * Cancels an instance refresh or rollback that is in progress. If an instance refresh or rollback is not in progress, an `ActiveInstanceRefreshNotFound` error occurs.
     *
     * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.
     *
     * When you cancel an instance refresh, this does not roll back any changes that it made. Use the RollbackInstanceRefresh API to roll back instead.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.CancelInstanceRefresh.sample
     */
    public suspend fun cancelInstanceRefresh(input: CancelInstanceRefreshRequest): CancelInstanceRefreshResponse

    /**
     * Completes the lifecycle action for the specified token or instance with the specified result.
     *
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * + (Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.
     * + (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.
     * + (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * + Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * + If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.
     * + **If you finish before the timeout period ends, send a callback by using the CompleteLifecycleAction API call.**
     *
     * For more information, see [Complete a lifecycle action](https://docs.aws.amazon.com/autoscaling/ec2/userguide/completing-lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.CompleteLifecycleAction.sample
     */
    public suspend fun completeLifecycleAction(input: CompleteLifecycleActionRequest): CompleteLifecycleActionResponse

    /**
     * **We strongly recommend using a launch template when calling this operation to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.**
     *
     * Creates an Auto Scaling group with the specified name and attributes.
     *
     * If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the DescribeAccountLimits API. For information about updating this limit, see [Quotas for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * For introductory exercises for creating an Auto Scaling group, see [Getting started with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html) and [Tutorial: Set up a scaled and load-balanced application](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html) in the *Amazon EC2 Auto Scaling User Guide*. For more information, see [Auto Scaling groups](https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Every Auto Scaling group has three size properties (`DesiredCapacity`, `MaxSize`, and `MinSize`). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.CreateAutoScalingGroup.sample
     */
    public suspend fun createAutoScalingGroup(input: CreateAutoScalingGroupRequest): CreateAutoScalingGroupResponse

    /**
     * Creates a launch configuration.
     *
     * If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the DescribeAccountLimits API. For information about updating this limit, see [Quotas for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a launch template or a launch configuration. We strongly recommend that you do not use launch configurations. They do not provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For information about using launch templates, see [Launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.CreateLaunchConfiguration.sample
     */
    public suspend fun createLaunchConfiguration(input: CreateLaunchConfigurationRequest): CreateLaunchConfigurationResponse

    /**
     * Creates or updates tags for the specified Auto Scaling group.
     *
     * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and you do not get an error message.
     *
     * For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.CreateOrUpdateTags.sample
     */
    public suspend fun createOrUpdateTags(input: CreateOrUpdateTagsRequest): CreateOrUpdateTagsResponse

    /**
     * Deletes the specified Auto Scaling group.
     *
     * If the group has instances or scaling activities in progress, you must specify the option to force the deletion in order for it to succeed. The force delete operation will also terminate the EC2 instances. If the group has a warm pool, the force delete option also deletes the warm pool.
     *
     * To remove instances from the Auto Scaling group before deleting it, call the DetachInstances API with the list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling does not launch replacement instances.
     *
     * To terminate all instances before deleting the Auto Scaling group, call the UpdateAutoScalingGroup API and set the minimum size and desired capacity of the Auto Scaling group to zero.
     *
     * If the group has scaling policies, deleting the group deletes the policies, the underlying alarm actions, and any alarm that no longer has an associated action.
     *
     * For more information, see [Delete your Auto Scaling infrastructure](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteAutoScalingGroup.sample
     */
    public suspend fun deleteAutoScalingGroup(input: DeleteAutoScalingGroupRequest): DeleteAutoScalingGroupResponse

    /**
     * Deletes the specified launch configuration.
     *
     * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch configuration is no longer available for use.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteLaunchConfiguration.sample
     */
    public suspend fun deleteLaunchConfiguration(input: DeleteLaunchConfigurationRequest): DeleteLaunchConfigurationResponse

    /**
     * Deletes the specified lifecycle hook.
     *
     * If there are any outstanding lifecycle actions, they are completed first (`ABANDON` for launching instances, `CONTINUE` for terminating instances).
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteLifecycleHook.sample
     */
    public suspend fun deleteLifecycleHook(input: DeleteLifecycleHookRequest): DeleteLifecycleHookResponse

    /**
     * Deletes the specified notification.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteNotificationConfiguration.sample
     */
    public suspend fun deleteNotificationConfiguration(input: DeleteNotificationConfigurationRequest): DeleteNotificationConfigurationResponse

    /**
     * Deletes the specified scaling policy.
     *
     * Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does not delete the alarm, even if it no longer has an associated action.
     *
     * For more information, see [Deleting a scaling policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DeletePolicy.sample
     */
    public suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Deletes the specified scheduled action.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteScheduledAction.sample
     */
    public suspend fun deleteScheduledAction(input: DeleteScheduledActionRequest): DeleteScheduledActionResponse

    /**
     * Deletes the specified tags.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteTags.sample
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes the warm pool for the specified Auto Scaling group.
     *
     * For more information, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public suspend fun deleteWarmPool(input: DeleteWarmPoolRequest): DeleteWarmPoolResponse

    /**
     * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
     *
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto Scaling groups and launch configurations that you can create in a given Region. For more information, see [Quotas for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAccountLimits.sample
     */
    public suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest { }): DescribeAccountLimitsResponse

    /**
     * Describes the available adjustment types for step scaling and simple scaling policies.
     *
     * The following adjustment types are supported:
     * + `ChangeInCapacity`
     * + `ExactCapacity`
     * + `PercentChangeInCapacity`
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAdjustmentTypes.sample
     */
    public suspend fun describeAdjustmentTypes(input: DescribeAdjustmentTypesRequest = DescribeAdjustmentTypesRequest { }): DescribeAdjustmentTypesResponse

    /**
     * Gets information about the Auto Scaling groups in the account and Region.
     *
     * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the filter criteria. If you do not specify group names or filters, the output includes information for all Auto Scaling groups.
     *
     * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the instances in a warm pool, you must call the DescribeWarmPool API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAutoScalingGroups.sample
     */
    public suspend fun describeAutoScalingGroups(input: DescribeAutoScalingGroupsRequest = DescribeAutoScalingGroupsRequest { }): DescribeAutoScalingGroupsResponse

    /**
     * Gets information about the Auto Scaling instances in the account and Region.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAutoScalingInstances.sample
     */
    public suspend fun describeAutoScalingInstances(input: DescribeAutoScalingInstancesRequest = DescribeAutoScalingInstancesRequest { }): DescribeAutoScalingInstancesResponse

    /**
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAutoScalingNotificationTypes.sample
     */
    public suspend fun describeAutoScalingNotificationTypes(input: DescribeAutoScalingNotificationTypesRequest = DescribeAutoScalingNotificationTypesRequest { }): DescribeAutoScalingNotificationTypesResponse

    /**
     * Gets information about the instance refreshes for the specified Auto Scaling group.
     *
     * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.
     *
     * To help you determine the status of an instance refresh, Amazon EC2 Auto Scaling returns information about the instance refreshes you previously initiated, including their status, start time, end time, the percentage of the instance refresh that is complete, and the number of instances remaining to update before the instance refresh is complete. If a rollback is initiated while an instance refresh is in progress, Amazon EC2 Auto Scaling also returns information about the rollback of the instance refresh.
     */
    public suspend fun describeInstanceRefreshes(input: DescribeInstanceRefreshesRequest): DescribeInstanceRefreshesResponse

    /**
     * Gets information about the launch configurations in the account and Region.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLaunchConfigurations.sample
     */
    public suspend fun describeLaunchConfigurations(input: DescribeLaunchConfigurationsRequest = DescribeLaunchConfigurationsRequest { }): DescribeLaunchConfigurationsResponse

    /**
     * Describes the available types of lifecycle hooks.
     *
     * The following hook types are supported:
     * + `autoscaling:EC2_INSTANCE_LAUNCHING`
     * + `autoscaling:EC2_INSTANCE_TERMINATING`
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLifecycleHookTypes.sample
     */
    public suspend fun describeLifecycleHookTypes(input: DescribeLifecycleHookTypesRequest = DescribeLifecycleHookTypesRequest { }): DescribeLifecycleHookTypesResponse

    /**
     * Gets information about the lifecycle hooks for the specified Auto Scaling group.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLifecycleHooks.sample
     */
    public suspend fun describeLifecycleHooks(input: DescribeLifecycleHooksRequest): DescribeLifecycleHooksResponse

    /**
     * This API operation is superseded by DescribeTrafficSources, which can describe multiple traffic sources types. We recommend using `DetachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DescribeLoadBalancerTargetGroups`. You can use both the original `DescribeLoadBalancerTargetGroups` API operation and `DescribeTrafficSources` on the same Auto Scaling group.
     *
     * Gets information about the Elastic Load Balancing target groups for the specified Auto Scaling group.
     *
     * To determine the attachment status of the target group, use the `State` element in the response. When you attach a target group to an Auto Scaling group, the initial `State` value is `Adding`. The state transitions to `Added` after all Auto Scaling instances are registered with the target group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to `InService` after at least one Auto Scaling instance passes the health check. When the target group is in the `InService` state, Amazon EC2 Auto Scaling can terminate and replace any instances that are reported as unhealthy. If no registered instances pass the health checks, the target group doesn't enter the `InService` state.
     *
     * Target groups also have an `InService` state if you attach them in the CreateAutoScalingGroup API call. If your target group state is `InService`, but it is not working properly, check the scaling activities by calling DescribeScalingActivities and take any corrective actions necessary.
     *
     * For help with failed health checks, see [Troubleshooting Amazon EC2 Auto Scaling: Health checks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html) in the *Amazon EC2 Auto Scaling User Guide*. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * You can use this operation to describe target groups that were attached by using AttachLoadBalancerTargetGroups, but not for target groups that were attached by using AttachTrafficSources.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLoadBalancerTargetGroups.sample
     */
    public suspend fun describeLoadBalancerTargetGroups(input: DescribeLoadBalancerTargetGroupsRequest): DescribeLoadBalancerTargetGroupsResponse

    /**
     * This API operation is superseded by DescribeTrafficSources, which can describe multiple traffic sources types. We recommend using `DescribeTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DescribeLoadBalancers`. You can use both the original `DescribeLoadBalancers` API operation and `DescribeTrafficSources` on the same Auto Scaling group.
     *
     * Gets information about the load balancers for the specified Auto Scaling group.
     *
     * This operation describes only Classic Load Balancers. If you have Application Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the DescribeLoadBalancerTargetGroups API instead.
     *
     * To determine the attachment status of the load balancer, use the `State` element in the response. When you attach a load balancer to an Auto Scaling group, the initial `State` value is `Adding`. The state transitions to `Added` after all Auto Scaling instances are registered with the load balancer. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to `InService` after at least one Auto Scaling instance passes the health check. When the load balancer is in the `InService` state, Amazon EC2 Auto Scaling can terminate and replace any instances that are reported as unhealthy. If no registered instances pass the health checks, the load balancer doesn't enter the `InService` state.
     *
     * Load balancers also have an `InService` state if you attach them in the CreateAutoScalingGroup API call. If your load balancer state is `InService`, but it is not working properly, check the scaling activities by calling DescribeScalingActivities and take any corrective actions necessary.
     *
     * For help with failed health checks, see [Troubleshooting Amazon EC2 Auto Scaling: Health checks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html) in the *Amazon EC2 Auto Scaling User Guide*. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLoadBalancers.sample
     */
    public suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest): DescribeLoadBalancersResponse

    /**
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeMetricCollectionTypes.sample
     */
    public suspend fun describeMetricCollectionTypes(input: DescribeMetricCollectionTypesRequest = DescribeMetricCollectionTypesRequest { }): DescribeMetricCollectionTypesResponse

    /**
     * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeNotificationConfigurations.sample
     */
    public suspend fun describeNotificationConfigurations(input: DescribeNotificationConfigurationsRequest = DescribeNotificationConfigurationsRequest { }): DescribeNotificationConfigurationsResponse

    /**
     * Gets information about the scaling policies in the account and Region.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribePolicies.sample
     */
    public suspend fun describePolicies(input: DescribePoliciesRequest = DescribePoliciesRequest { }): DescribePoliciesResponse

    /**
     * Gets information about the scaling activities in the account and Region.
     *
     * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more information, see [Verifying a scaling activity for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * If the scaling event succeeds, the value of the `StatusCode` element in the response is `Successful`. If an attempt to launch instances failed, the `StatusCode` value is `Failed` or `Cancelled` and the `StatusMessage` element in the response indicates the cause of the failure. For help interpreting the `StatusMessage`, see [Troubleshooting Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeScalingActivities.sample
     */
    public suspend fun describeScalingActivities(input: DescribeScalingActivitiesRequest = DescribeScalingActivitiesRequest { }): DescribeScalingActivitiesResponse

    /**
     * Describes the scaling process types for use with the ResumeProcesses and SuspendProcesses APIs.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeScalingProcessTypes.sample
     */
    public suspend fun describeScalingProcessTypes(input: DescribeScalingProcessTypesRequest = DescribeScalingProcessTypesRequest { }): DescribeScalingProcessTypesResponse

    /**
     * Gets information about the scheduled actions that haven't run or that have not reached their end time.
     *
     * To describe the scaling activities for scheduled actions that have already run, call the DescribeScalingActivities API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeScheduledActions.sample
     */
    public suspend fun describeScheduledActions(input: DescribeScheduledActionsRequest = DescribeScheduledActionsRequest { }): DescribeScheduledActionsResponse

    /**
     * Describes the specified tags.
     *
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it to be included in the results.
     *
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches all the filters. If there's no match, no special message is returned.
     *
     * For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeTags.sample
     */
    public suspend fun describeTags(input: DescribeTagsRequest = DescribeTagsRequest { }): DescribeTagsResponse

    /**
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     *
     * For more information, see [Work with Amazon EC2 Auto Scaling termination policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeTerminationPolicyTypes.sample
     */
    public suspend fun describeTerminationPolicyTypes(input: DescribeTerminationPolicyTypesRequest = DescribeTerminationPolicyTypesRequest { }): DescribeTerminationPolicyTypesResponse

    /**
     * Gets information about the traffic sources for the specified Auto Scaling group.
     *
     * You can optionally provide a traffic source type. If you provide a traffic source type, then the results only include that traffic source type.
     *
     * If you do not provide a traffic source type, then the results include all the traffic sources for the specified Auto Scaling group.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeTrafficSources.sample
     */
    public suspend fun describeTrafficSources(input: DescribeTrafficSourcesRequest): DescribeTrafficSourcesResponse

    /**
     * Gets information about a warm pool and its instances.
     *
     * For more information, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public suspend fun describeWarmPool(input: DescribeWarmPoolRequest): DescribeWarmPoolResponse

    /**
     * Removes one or more instances from the specified Auto Scaling group.
     *
     * After the instances are detached, you can manage them independent of the Auto Scaling group.
     *
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are detached.
     *
     * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from the target groups.
     *
     * For more information, see [Detach EC2 instances from your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachInstances.sample
     */
    public suspend fun detachInstances(input: DetachInstancesRequest): DetachInstancesResponse

    /**
     * This API operation is superseded by DetachTrafficSources, which can detach multiple traffic sources types. We recommend using `DetachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DetachLoadBalancerTargetGroups`. You can use both the original `DetachLoadBalancerTargetGroups` API operation and `DetachTrafficSources` on the same Auto Scaling group.
     *
     * Detaches one or more target groups from the specified Auto Scaling group.
     *
     * When you detach a target group, it enters the `Removing` state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the target group using the DescribeLoadBalancerTargetGroups API call. The instances remain running.
     *
     * You can use this operation to detach target groups that were attached by using AttachLoadBalancerTargetGroups, but not for target groups that were attached by using AttachTrafficSources.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachLoadBalancerTargetGroups.sample
     */
    public suspend fun detachLoadBalancerTargetGroups(input: DetachLoadBalancerTargetGroupsRequest): DetachLoadBalancerTargetGroupsResponse

    /**
     * This API operation is superseded by DetachTrafficSources, which can detach multiple traffic sources types. We recommend using `DetachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DetachLoadBalancers`. You can use both the original `DetachLoadBalancers` API operation and `DetachTrafficSources` on the same Auto Scaling group.
     *
     * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
     *
     * This operation detaches only Classic Load Balancers. If you have Application Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the DetachLoadBalancerTargetGroups API instead.
     *
     * When you detach a load balancer, it enters the `Removing` state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the load balancer using the DescribeLoadBalancers API call. The instances remain running.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachLoadBalancers.sample
     */
    public suspend fun detachLoadBalancers(input: DetachLoadBalancersRequest): DetachLoadBalancersResponse

    /**
     * Detaches one or more traffic sources from the specified Auto Scaling group.
     *
     * When you detach a traffic source, it enters the `Removing` state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the traffic source using the DescribeTrafficSources API call. The instances continue to run.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachTrafficSources.sample
     */
    public suspend fun detachTrafficSources(input: DetachTrafficSourcesRequest): DetachTrafficSourcesResponse

    /**
     * Disables group metrics collection for the specified Auto Scaling group.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.DisableMetricsCollection.sample
     */
    public suspend fun disableMetricsCollection(input: DisableMetricsCollectionRequest): DisableMetricsCollectionResponse

    /**
     * Enables group metrics collection for the specified Auto Scaling group.
     *
     * You can use these metrics to track changes in an Auto Scaling group and to set alarms on threshold values. You can view group metrics using the Amazon EC2 Auto Scaling console or the CloudWatch console. For more information, see [Monitor CloudWatch metrics for your Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.EnableMetricsCollection.sample
     */
    public suspend fun enableMetricsCollection(input: EnableMetricsCollectionRequest): EnableMetricsCollectionResponse

    /**
     * Moves the specified instances into the standby state.
     *
     * If you choose to decrement the desired capacity of the Auto Scaling group, the instances can enter standby as long as the desired capacity of the Auto Scaling group after the instances are placed into standby is equal to or greater than the minimum capacity of the group.
     *
     * If you choose not to decrement the desired capacity of the Auto Scaling group, the Auto Scaling group launches new instances to replace the instances on standby.
     *
     * For more information, see [Temporarily removing instances from your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.EnterStandby.sample
     */
    public suspend fun enterStandby(input: EnterStandbyRequest): EnterStandbyResponse

    /**
     * Executes the specified policy. This can be useful for testing the design of your scaling policy.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.ExecutePolicy.sample
     */
    public suspend fun executePolicy(input: ExecutePolicyRequest): ExecutePolicyResponse

    /**
     * Moves the specified instances out of the standby state.
     *
     * After you put the instances back in service, the desired capacity is incremented.
     *
     * For more information, see [Temporarily removing instances from your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.ExitStandby.sample
     */
    public suspend fun exitStandby(input: ExitStandbyRequest): ExitStandbyResponse

    /**
     * Retrieves the forecast data for a predictive scaling policy.
     *
     * Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity that is needed on an hourly basis, based on the hourly load forecast.
     *
     * A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of historical data results in more accurate forecasts.
     *
     * For more information, see [Predictive scaling for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public suspend fun getPredictiveScalingForecast(input: GetPredictiveScalingForecastRequest): GetPredictiveScalingForecastResponse

    /**
     * Creates or updates a lifecycle hook for the specified Auto Scaling group.
     *
     * Lifecycle hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and then perform a custom action on instances when the corresponding lifecycle event occurs.
     *
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * + (Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.
     * + (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.
     * + (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * + **Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.**
     * + If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state using the RecordLifecycleActionHeartbeat API call.
     * + If you finish before the timeout period ends, send a callback by using the CompleteLifecycleAction API call.
     *
     * For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call fails.
     *
     * You can view the lifecycle hooks for an Auto Scaling group using the DescribeLifecycleHooks API call. If you are no longer using a lifecycle hook, you can delete it by calling the DeleteLifecycleHook API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.PutLifecycleHook.sample
     */
    public suspend fun putLifecycleHook(input: PutLifecycleHookRequest): PutLifecycleHookResponse

    /**
     * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the specified topic can have messages delivered to an endpoint such as a web server or an email address.
     *
     * This configuration overwrites any existing configuration.
     *
     * For more information, see [Getting Amazon SNS notifications when your Auto Scaling group scales](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.PutNotificationConfiguration.sample
     */
    public suspend fun putNotificationConfiguration(input: PutNotificationConfigurationRequest): PutNotificationConfigurationResponse

    /**
     * Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling features are not used.
     *
     * For more information about using dynamic scaling, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html) and [Step and simple scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * For more information about using predictive scaling, see [Predictive scaling for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * You can view the scaling policies for an Auto Scaling group using the DescribePolicies API call. If you are no longer using a scaling policy, you can delete it by calling the DeletePolicy API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.PutScalingPolicy.sample
     */
    public suspend fun putScalingPolicy(input: PutScalingPolicyRequest): PutScalingPolicyResponse

    /**
     * Creates or updates a scheduled scaling action for an Auto Scaling group.
     *
     * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * You can view the scheduled actions for an Auto Scaling group using the DescribeScheduledActions API call. If you are no longer using a scheduled action, you can delete it by calling the DeleteScheduledAction API.
     *
     * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.PutScheduledUpdateGroupAction.sample
     */
    public suspend fun putScheduledUpdateGroupAction(input: PutScheduledUpdateGroupActionRequest): PutScheduledUpdateGroupActionResponse

    /**
     * Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity. For more information and example configurations, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * This operation must be called from the Region in which the Auto Scaling group was created. This operation cannot be called on an Auto Scaling group that has a mixed instances policy or a launch template or launch configuration that requests Spot Instances.
     *
     * You can view the instances in the warm pool using the DescribeWarmPool API call. If you are no longer using a warm pool, you can delete it by calling the DeleteWarmPool API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.PutWarmPool.sample
     */
    public suspend fun putWarmPool(input: PutWarmPoolRequest): PutWarmPoolResponse

    /**
     * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the timeout by the length of time defined using the PutLifecycleHook API call.
     *
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * + (Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.
     * + (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.
     * + (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * + Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * + **If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.**
     * + If you finish before the timeout period ends, send a callback by using the CompleteLifecycleAction API call.
     *
     * For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.RecordLifecycleActionHeartbeat.sample
     */
    public suspend fun recordLifecycleActionHeartbeat(input: RecordLifecycleActionHeartbeatRequest): RecordLifecycleActionHeartbeatResponse

    /**
     * Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling group.
     *
     * For more information, see [Suspending and resuming scaling processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.ResumeProcesses.sample
     */
    public suspend fun resumeProcesses(input: ResumeProcessesRequest): ResumeProcessesResponse

    /**
     * Cancels an instance refresh that is in progress and rolls back any changes that it made. Amazon EC2 Auto Scaling replaces any instances that were replaced during the instance refresh. This restores your Auto Scaling group to the configuration that it was using before the start of the instance refresh.
     *
     * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.
     *
     * A rollback is not supported in the following situations:
     * + There is no desired configuration specified for the instance refresh.
     * + The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead of an AMI ID for the `ImageId` property.
     * + The Auto Scaling group uses the launch template's `$Latest` or `$Default` version.
     *
     * When you receive a successful response from this operation, Amazon EC2 Auto Scaling immediately begins replacing instances. You can check the status of this operation through the DescribeInstanceRefreshes API operation.
     */
    public suspend fun rollbackInstanceRefresh(input: RollbackInstanceRefreshRequest): RollbackInstanceRefreshResponse

    /**
     * Sets the size of the specified Auto Scaling group.
     *
     * If a scale-in activity occurs as a result of a new `DesiredCapacity` value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate.
     *
     * For more information, see [Manual scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.SetDesiredCapacity.sample
     */
    public suspend fun setDesiredCapacity(input: SetDesiredCapacityRequest): SetDesiredCapacityResponse

    /**
     * Sets the health status of the specified instance.
     *
     * For more information, see [Health checks for Auto Scaling instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.SetInstanceHealth.sample
     */
    public suspend fun setInstanceHealth(input: SetInstanceHealthRequest): SetInstanceHealthResponse

    /**
     * Updates the instance protection settings of the specified instances. This operation cannot be called on instances in a warm pool.
     *
     * For more information about preventing instances that are part of an Auto Scaling group from terminating on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.SetInstanceProtection.sample
     */
    public suspend fun setInstanceProtection(input: SetInstanceProtectionRequest): SetInstanceProtectionResponse

    /**
     * Starts an instance refresh.
     *
     * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group. This feature is helpful, for example, when you have a new AMI or a new user data script. You just need to create a new launch template that specifies the new AMI or user data script. Then start an instance refresh to immediately begin the process of updating instances in the group.
     *
     * If successful, the request's response contains a unique ID that you can use to track the progress of the instance refresh. To query its status, call the DescribeInstanceRefreshes API. To describe the instance refreshes that have already run, call the DescribeInstanceRefreshes API. To cancel an instance refresh that is in progress, use the CancelInstanceRefresh API.
     *
     * An instance refresh might fail for several reasons, such as EC2 launch failures, misconfigured health checks, or not ignoring or allowing the termination of instances that are in `Standby` state or protected from scale in. You can monitor for failed EC2 launches using the scaling activities. To find the scaling activities, call the DescribeScalingActivities API.
     *
     * If you enable auto rollback, your Auto Scaling group will be rolled back automatically when the instance refresh fails. You can enable this feature before starting an instance refresh by specifying the `AutoRollback` property in the instance refresh preferences. Otherwise, to roll back an instance refresh before it finishes, use the RollbackInstanceRefresh API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.StartInstanceRefresh.sample
     */
    public suspend fun startInstanceRefresh(input: StartInstanceRefreshRequest): StartInstanceRefreshResponse

    /**
     * Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.
     *
     * If you suspend either the `Launch` or `Terminate` process types, it can prevent other process types from functioning properly. For more information, see [Suspending and resuming scaling processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * To resume processes that have been suspended, call the ResumeProcesses API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.SuspendProcesses.sample
     */
    public suspend fun suspendProcesses(input: SuspendProcessesRequest): SuspendProcessesResponse

    /**
     * Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called on instances in a warm pool.
     *
     * This call simply makes a termination request. The instance is not terminated immediately. When an instance is terminated, the instance status changes to `terminated`. You can't connect to or start an instance after you've terminated it.
     *
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are terminated.
     *
     * By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more information, see [Rebalancing activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.TerminateInstanceInAutoScalingGroup.sample
     */
    public suspend fun terminateInstanceInAutoScalingGroup(input: TerminateInstanceInAutoScalingGroupRequest): TerminateInstanceInAutoScalingGroupResponse

    /**
     * **We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.**
     *
     * Updates the configuration for the specified Auto Scaling group.
     *
     * To update an Auto Scaling group, specify the name of the group and the property that you want to change. Any properties that you don't specify are not changed by this update request. The new settings take effect on any scaling activities after this call returns.
     *
     * If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get the updated configuration. Existing instances continue to run with the configuration that they were originally launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or template, existing instances may be replaced to match the new purchasing options that you specified in the policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that updating your group does not compromise the performance or availability of your application.
     *
     * Note the following about changing `DesiredCapacity`, `MaxSize`, or `MinSize`:
     * + If a scale-in activity occurs as a result of a new `DesiredCapacity` value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate.
     * + If you specify a new value for `MinSize` without specifying a value for `DesiredCapacity`, and the new `MinSize` is larger than the current size of the group, this sets the group's `DesiredCapacity` to the new `MinSize` value.
     * + If you specify a new value for `MaxSize` without specifying a value for `DesiredCapacity`, and the new `MaxSize` is smaller than the current size of the group, this sets the group's `DesiredCapacity` to the new `MaxSize` value.
     *
     * To see which properties have been set, call the DescribeAutoScalingGroups API. To view the scaling policies for an Auto Scaling group, call the DescribePolicies API. If the group has scaling policies, you can update them by calling the PutScalingPolicy API.
     *
     * @sample aws.sdk.kotlin.services.autoscaling.samples.UpdateAutoScalingGroup.sample
     */
    public suspend fun updateAutoScalingGroup(input: UpdateAutoScalingGroupRequest): UpdateAutoScalingGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AutoScalingClient.withConfig(block: AutoScalingClient.Config.Builder.() -> Unit): AutoScalingClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAutoScalingClient(newConfig)
}

/**
 * Attaches one or more EC2 instances to the specified Auto Scaling group.
 *
 * When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of instances being attached. If the number of instances being attached plus the desired capacity of the group exceeds the maximum size of the group, the operation fails.
 *
 * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also registered with the target groups.
 *
 * For more information, see [Attach EC2 instances to your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachInstances.sample
 */
public suspend inline fun AutoScalingClient.attachInstances(crossinline block: AttachInstancesRequest.Builder.() -> Unit): AttachInstancesResponse = attachInstances(AttachInstancesRequest.Builder().apply(block).build())

/**
 * This API operation is superseded by AttachTrafficSources, which can attach multiple traffic sources types. We recommend using `AttachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `AttachLoadBalancerTargetGroups`. You can use both the original `AttachLoadBalancerTargetGroups` API operation and `AttachTrafficSources` on the same Auto Scaling group.
 *
 * Attaches one or more target groups to the specified Auto Scaling group.
 *
 * This operation is used with the following load balancer types:
 * + Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
 * + Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
 * + Gateway Load Balancer - Operates at the network layer (layer 3).
 *
 * To describe the target groups for an Auto Scaling group, call the DescribeLoadBalancerTargetGroups API. To detach the target group from the Auto Scaling group, call the DetachLoadBalancerTargetGroups API.
 *
 * This operation is additive and does not detach existing target groups or Classic Load Balancers from the Auto Scaling group.
 *
 * For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachLoadBalancerTargetGroups.sample
 */
public suspend inline fun AutoScalingClient.attachLoadBalancerTargetGroups(crossinline block: AttachLoadBalancerTargetGroupsRequest.Builder.() -> Unit): AttachLoadBalancerTargetGroupsResponse = attachLoadBalancerTargetGroups(AttachLoadBalancerTargetGroupsRequest.Builder().apply(block).build())

/**
 * This API operation is superseded by AttachTrafficSources, which can attach multiple traffic sources types. We recommend using `AttachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `AttachLoadBalancers`. You can use both the original `AttachLoadBalancers` API operation and `AttachTrafficSources` on the same Auto Scaling group.
 *
 * Attaches one or more Classic Load Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling registers the running instances with these Classic Load Balancers.
 *
 * To describe the load balancers for an Auto Scaling group, call the DescribeLoadBalancers API. To detach a load balancer from the Auto Scaling group, call the DetachLoadBalancers API.
 *
 * This operation is additive and does not detach existing Classic Load Balancers or target groups from the Auto Scaling group.
 *
 * For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachLoadBalancers.sample
 */
public suspend inline fun AutoScalingClient.attachLoadBalancers(crossinline block: AttachLoadBalancersRequest.Builder.() -> Unit): AttachLoadBalancersResponse = attachLoadBalancers(AttachLoadBalancersRequest.Builder().apply(block).build())

/**
 * Attaches one or more traffic sources to the specified Auto Scaling group.
 *
 * You can use any of the following as traffic sources for an Auto Scaling group:
 * + Application Load Balancer
 * + Classic Load Balancer
 * + Gateway Load Balancer
 * + Network Load Balancer
 * + VPC Lattice
 *
 * This operation is additive and does not detach existing traffic sources from the Auto Scaling group.
 *
 * After the operation completes, use the DescribeTrafficSources API to return details about the state of the attachments between traffic sources and your Auto Scaling group. To detach a traffic source from the Auto Scaling group, call the DetachTrafficSources API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.AttachTrafficSources.sample
 */
public suspend inline fun AutoScalingClient.attachTrafficSources(crossinline block: AttachTrafficSourcesRequest.Builder.() -> Unit): AttachTrafficSourcesResponse = attachTrafficSources(AttachTrafficSourcesRequest.Builder().apply(block).build())

/**
 * Deletes one or more scheduled actions for the specified Auto Scaling group.
 */
public suspend inline fun AutoScalingClient.batchDeleteScheduledAction(crossinline block: BatchDeleteScheduledActionRequest.Builder.() -> Unit): BatchDeleteScheduledActionResponse = batchDeleteScheduledAction(BatchDeleteScheduledActionRequest.Builder().apply(block).build())

/**
 * Creates or updates one or more scheduled scaling actions for an Auto Scaling group.
 */
public suspend inline fun AutoScalingClient.batchPutScheduledUpdateGroupAction(crossinline block: BatchPutScheduledUpdateGroupActionRequest.Builder.() -> Unit): BatchPutScheduledUpdateGroupActionResponse = batchPutScheduledUpdateGroupAction(BatchPutScheduledUpdateGroupActionRequest.Builder().apply(block).build())

/**
 * Cancels an instance refresh or rollback that is in progress. If an instance refresh or rollback is not in progress, an `ActiveInstanceRefreshNotFound` error occurs.
 *
 * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.
 *
 * When you cancel an instance refresh, this does not roll back any changes that it made. Use the RollbackInstanceRefresh API to roll back instead.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.CancelInstanceRefresh.sample
 */
public suspend inline fun AutoScalingClient.cancelInstanceRefresh(crossinline block: CancelInstanceRefreshRequest.Builder.() -> Unit): CancelInstanceRefreshResponse = cancelInstanceRefresh(CancelInstanceRefreshRequest.Builder().apply(block).build())

/**
 * Completes the lifecycle action for the specified token or instance with the specified result.
 *
 * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
 * + (Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.
 * + (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.
 * + (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
 * + Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
 * + If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.
 * + **If you finish before the timeout period ends, send a callback by using the CompleteLifecycleAction API call.**
 *
 * For more information, see [Complete a lifecycle action](https://docs.aws.amazon.com/autoscaling/ec2/userguide/completing-lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.CompleteLifecycleAction.sample
 */
public suspend inline fun AutoScalingClient.completeLifecycleAction(crossinline block: CompleteLifecycleActionRequest.Builder.() -> Unit): CompleteLifecycleActionResponse = completeLifecycleAction(CompleteLifecycleActionRequest.Builder().apply(block).build())

/**
 * **We strongly recommend using a launch template when calling this operation to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.**
 *
 * Creates an Auto Scaling group with the specified name and attributes.
 *
 * If you exceed your maximum limit of Auto Scaling groups, the call fails. To query this limit, call the DescribeAccountLimits API. For information about updating this limit, see [Quotas for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * For introductory exercises for creating an Auto Scaling group, see [Getting started with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html) and [Tutorial: Set up a scaled and load-balanced application](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html) in the *Amazon EC2 Auto Scaling User Guide*. For more information, see [Auto Scaling groups](https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * Every Auto Scaling group has three size properties (`DesiredCapacity`, `MaxSize`, and `MinSize`). Usually, you set these sizes based on a specific number of instances. However, if you configure a mixed instances policy that defines weights for the instance types, you must specify these sizes with the same units that you use for weighting instances.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.CreateAutoScalingGroup.sample
 */
public suspend inline fun AutoScalingClient.createAutoScalingGroup(crossinline block: CreateAutoScalingGroupRequest.Builder.() -> Unit): CreateAutoScalingGroupResponse = createAutoScalingGroup(CreateAutoScalingGroupRequest.Builder().apply(block).build())

/**
 * Creates a launch configuration.
 *
 * If you exceed your maximum limit of launch configurations, the call fails. To query this limit, call the DescribeAccountLimits API. For information about updating this limit, see [Quotas for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * For more information, see [Launch configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * Amazon EC2 Auto Scaling configures instances launched as part of an Auto Scaling group using either a launch template or a launch configuration. We strongly recommend that you do not use launch configurations. They do not provide full functionality for Amazon EC2 Auto Scaling or Amazon EC2. For information about using launch templates, see [Launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.CreateLaunchConfiguration.sample
 */
public suspend inline fun AutoScalingClient.createLaunchConfiguration(crossinline block: CreateLaunchConfigurationRequest.Builder.() -> Unit): CreateLaunchConfigurationResponse = createLaunchConfiguration(CreateLaunchConfigurationRequest.Builder().apply(block).build())

/**
 * Creates or updates tags for the specified Auto Scaling group.
 *
 * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and you do not get an error message.
 *
 * For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.CreateOrUpdateTags.sample
 */
public suspend inline fun AutoScalingClient.createOrUpdateTags(crossinline block: CreateOrUpdateTagsRequest.Builder.() -> Unit): CreateOrUpdateTagsResponse = createOrUpdateTags(CreateOrUpdateTagsRequest.Builder().apply(block).build())

/**
 * Deletes the specified Auto Scaling group.
 *
 * If the group has instances or scaling activities in progress, you must specify the option to force the deletion in order for it to succeed. The force delete operation will also terminate the EC2 instances. If the group has a warm pool, the force delete option also deletes the warm pool.
 *
 * To remove instances from the Auto Scaling group before deleting it, call the DetachInstances API with the list of instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling does not launch replacement instances.
 *
 * To terminate all instances before deleting the Auto Scaling group, call the UpdateAutoScalingGroup API and set the minimum size and desired capacity of the Auto Scaling group to zero.
 *
 * If the group has scaling policies, deleting the group deletes the policies, the underlying alarm actions, and any alarm that no longer has an associated action.
 *
 * For more information, see [Delete your Auto Scaling infrastructure](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteAutoScalingGroup.sample
 */
public suspend inline fun AutoScalingClient.deleteAutoScalingGroup(crossinline block: DeleteAutoScalingGroupRequest.Builder.() -> Unit): DeleteAutoScalingGroupResponse = deleteAutoScalingGroup(DeleteAutoScalingGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified launch configuration.
 *
 * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch configuration is no longer available for use.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteLaunchConfiguration.sample
 */
public suspend inline fun AutoScalingClient.deleteLaunchConfiguration(crossinline block: DeleteLaunchConfigurationRequest.Builder.() -> Unit): DeleteLaunchConfigurationResponse = deleteLaunchConfiguration(DeleteLaunchConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified lifecycle hook.
 *
 * If there are any outstanding lifecycle actions, they are completed first (`ABANDON` for launching instances, `CONTINUE` for terminating instances).
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteLifecycleHook.sample
 */
public suspend inline fun AutoScalingClient.deleteLifecycleHook(crossinline block: DeleteLifecycleHookRequest.Builder.() -> Unit): DeleteLifecycleHookResponse = deleteLifecycleHook(DeleteLifecycleHookRequest.Builder().apply(block).build())

/**
 * Deletes the specified notification.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteNotificationConfiguration.sample
 */
public suspend inline fun AutoScalingClient.deleteNotificationConfiguration(crossinline block: DeleteNotificationConfigurationRequest.Builder.() -> Unit): DeleteNotificationConfigurationResponse = deleteNotificationConfiguration(DeleteNotificationConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified scaling policy.
 *
 * Deleting either a step scaling policy or a simple scaling policy deletes the underlying alarm action, but does not delete the alarm, even if it no longer has an associated action.
 *
 * For more information, see [Deleting a scaling policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DeletePolicy.sample
 */
public suspend inline fun AutoScalingClient.deletePolicy(crossinline block: DeletePolicyRequest.Builder.() -> Unit): DeletePolicyResponse = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified scheduled action.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteScheduledAction.sample
 */
public suspend inline fun AutoScalingClient.deleteScheduledAction(crossinline block: DeleteScheduledActionRequest.Builder.() -> Unit): DeleteScheduledActionResponse = deleteScheduledAction(DeleteScheduledActionRequest.Builder().apply(block).build())

/**
 * Deletes the specified tags.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DeleteTags.sample
 */
public suspend inline fun AutoScalingClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Deletes the warm pool for the specified Auto Scaling group.
 *
 * For more information, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public suspend inline fun AutoScalingClient.deleteWarmPool(crossinline block: DeleteWarmPoolRequest.Builder.() -> Unit): DeleteWarmPoolResponse = deleteWarmPool(DeleteWarmPoolRequest.Builder().apply(block).build())

/**
 * Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
 *
 * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of Auto Scaling groups and launch configurations that you can create in a given Region. For more information, see [Quotas for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAccountLimits.sample
 */
public suspend inline fun AutoScalingClient.describeAccountLimits(crossinline block: DescribeAccountLimitsRequest.Builder.() -> Unit): DescribeAccountLimitsResponse = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * Describes the available adjustment types for step scaling and simple scaling policies.
 *
 * The following adjustment types are supported:
 * + `ChangeInCapacity`
 * + `ExactCapacity`
 * + `PercentChangeInCapacity`
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAdjustmentTypes.sample
 */
public suspend inline fun AutoScalingClient.describeAdjustmentTypes(crossinline block: DescribeAdjustmentTypesRequest.Builder.() -> Unit): DescribeAdjustmentTypesResponse = describeAdjustmentTypes(DescribeAdjustmentTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the Auto Scaling groups in the account and Region.
 *
 * If you specify Auto Scaling group names, the output includes information for only the specified Auto Scaling groups. If you specify filters, the output includes information for only those Auto Scaling groups that meet the filter criteria. If you do not specify group names or filters, the output includes information for all Auto Scaling groups.
 *
 * This operation also returns information about instances in Auto Scaling groups. To retrieve information about the instances in a warm pool, you must call the DescribeWarmPool API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAutoScalingGroups.sample
 */
public suspend inline fun AutoScalingClient.describeAutoScalingGroups(crossinline block: DescribeAutoScalingGroupsRequest.Builder.() -> Unit): DescribeAutoScalingGroupsResponse = describeAutoScalingGroups(DescribeAutoScalingGroupsRequest.Builder().apply(block).build())

/**
 * Gets information about the Auto Scaling instances in the account and Region.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAutoScalingInstances.sample
 */
public suspend inline fun AutoScalingClient.describeAutoScalingInstances(crossinline block: DescribeAutoScalingInstancesRequest.Builder.() -> Unit): DescribeAutoScalingInstancesResponse = describeAutoScalingInstances(DescribeAutoScalingInstancesRequest.Builder().apply(block).build())

/**
 * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeAutoScalingNotificationTypes.sample
 */
public suspend inline fun AutoScalingClient.describeAutoScalingNotificationTypes(crossinline block: DescribeAutoScalingNotificationTypesRequest.Builder.() -> Unit): DescribeAutoScalingNotificationTypesResponse = describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the instance refreshes for the specified Auto Scaling group.
 *
 * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.
 *
 * To help you determine the status of an instance refresh, Amazon EC2 Auto Scaling returns information about the instance refreshes you previously initiated, including their status, start time, end time, the percentage of the instance refresh that is complete, and the number of instances remaining to update before the instance refresh is complete. If a rollback is initiated while an instance refresh is in progress, Amazon EC2 Auto Scaling also returns information about the rollback of the instance refresh.
 */
public suspend inline fun AutoScalingClient.describeInstanceRefreshes(crossinline block: DescribeInstanceRefreshesRequest.Builder.() -> Unit): DescribeInstanceRefreshesResponse = describeInstanceRefreshes(DescribeInstanceRefreshesRequest.Builder().apply(block).build())

/**
 * Gets information about the launch configurations in the account and Region.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLaunchConfigurations.sample
 */
public suspend inline fun AutoScalingClient.describeLaunchConfigurations(crossinline block: DescribeLaunchConfigurationsRequest.Builder.() -> Unit): DescribeLaunchConfigurationsResponse = describeLaunchConfigurations(DescribeLaunchConfigurationsRequest.Builder().apply(block).build())

/**
 * Describes the available types of lifecycle hooks.
 *
 * The following hook types are supported:
 * + `autoscaling:EC2_INSTANCE_LAUNCHING`
 * + `autoscaling:EC2_INSTANCE_TERMINATING`
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLifecycleHookTypes.sample
 */
public suspend inline fun AutoScalingClient.describeLifecycleHookTypes(crossinline block: DescribeLifecycleHookTypesRequest.Builder.() -> Unit): DescribeLifecycleHookTypesResponse = describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the lifecycle hooks for the specified Auto Scaling group.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLifecycleHooks.sample
 */
public suspend inline fun AutoScalingClient.describeLifecycleHooks(crossinline block: DescribeLifecycleHooksRequest.Builder.() -> Unit): DescribeLifecycleHooksResponse = describeLifecycleHooks(DescribeLifecycleHooksRequest.Builder().apply(block).build())

/**
 * This API operation is superseded by DescribeTrafficSources, which can describe multiple traffic sources types. We recommend using `DetachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DescribeLoadBalancerTargetGroups`. You can use both the original `DescribeLoadBalancerTargetGroups` API operation and `DescribeTrafficSources` on the same Auto Scaling group.
 *
 * Gets information about the Elastic Load Balancing target groups for the specified Auto Scaling group.
 *
 * To determine the attachment status of the target group, use the `State` element in the response. When you attach a target group to an Auto Scaling group, the initial `State` value is `Adding`. The state transitions to `Added` after all Auto Scaling instances are registered with the target group. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to `InService` after at least one Auto Scaling instance passes the health check. When the target group is in the `InService` state, Amazon EC2 Auto Scaling can terminate and replace any instances that are reported as unhealthy. If no registered instances pass the health checks, the target group doesn't enter the `InService` state.
 *
 * Target groups also have an `InService` state if you attach them in the CreateAutoScalingGroup API call. If your target group state is `InService`, but it is not working properly, check the scaling activities by calling DescribeScalingActivities and take any corrective actions necessary.
 *
 * For help with failed health checks, see [Troubleshooting Amazon EC2 Auto Scaling: Health checks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html) in the *Amazon EC2 Auto Scaling User Guide*. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * You can use this operation to describe target groups that were attached by using AttachLoadBalancerTargetGroups, but not for target groups that were attached by using AttachTrafficSources.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLoadBalancerTargetGroups.sample
 */
public suspend inline fun AutoScalingClient.describeLoadBalancerTargetGroups(crossinline block: DescribeLoadBalancerTargetGroupsRequest.Builder.() -> Unit): DescribeLoadBalancerTargetGroupsResponse = describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsRequest.Builder().apply(block).build())

/**
 * This API operation is superseded by DescribeTrafficSources, which can describe multiple traffic sources types. We recommend using `DescribeTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DescribeLoadBalancers`. You can use both the original `DescribeLoadBalancers` API operation and `DescribeTrafficSources` on the same Auto Scaling group.
 *
 * Gets information about the load balancers for the specified Auto Scaling group.
 *
 * This operation describes only Classic Load Balancers. If you have Application Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the DescribeLoadBalancerTargetGroups API instead.
 *
 * To determine the attachment status of the load balancer, use the `State` element in the response. When you attach a load balancer to an Auto Scaling group, the initial `State` value is `Adding`. The state transitions to `Added` after all Auto Scaling instances are registered with the load balancer. If Elastic Load Balancing health checks are enabled for the Auto Scaling group, the state transitions to `InService` after at least one Auto Scaling instance passes the health check. When the load balancer is in the `InService` state, Amazon EC2 Auto Scaling can terminate and replace any instances that are reported as unhealthy. If no registered instances pass the health checks, the load balancer doesn't enter the `InService` state.
 *
 * Load balancers also have an `InService` state if you attach them in the CreateAutoScalingGroup API call. If your load balancer state is `InService`, but it is not working properly, check the scaling activities by calling DescribeScalingActivities and take any corrective actions necessary.
 *
 * For help with failed health checks, see [Troubleshooting Amazon EC2 Auto Scaling: Health checks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html) in the *Amazon EC2 Auto Scaling User Guide*. For more information, see [Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeLoadBalancers.sample
 */
public suspend inline fun AutoScalingClient.describeLoadBalancers(crossinline block: DescribeLoadBalancersRequest.Builder.() -> Unit): DescribeLoadBalancersResponse = describeLoadBalancers(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeMetricCollectionTypes.sample
 */
public suspend inline fun AutoScalingClient.describeMetricCollectionTypes(crossinline block: DescribeMetricCollectionTypesRequest.Builder.() -> Unit): DescribeMetricCollectionTypesResponse = describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeNotificationConfigurations.sample
 */
public suspend inline fun AutoScalingClient.describeNotificationConfigurations(crossinline block: DescribeNotificationConfigurationsRequest.Builder.() -> Unit): DescribeNotificationConfigurationsResponse = describeNotificationConfigurations(DescribeNotificationConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets information about the scaling policies in the account and Region.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribePolicies.sample
 */
public suspend inline fun AutoScalingClient.describePolicies(crossinline block: DescribePoliciesRequest.Builder.() -> Unit): DescribePoliciesResponse = describePolicies(DescribePoliciesRequest.Builder().apply(block).build())

/**
 * Gets information about the scaling activities in the account and Region.
 *
 * When scaling events occur, you see a record of the scaling activity in the scaling activities. For more information, see [Verifying a scaling activity for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * If the scaling event succeeds, the value of the `StatusCode` element in the response is `Successful`. If an attempt to launch instances failed, the `StatusCode` value is `Failed` or `Cancelled` and the `StatusMessage` element in the response indicates the cause of the failure. For help interpreting the `StatusMessage`, see [Troubleshooting Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeScalingActivities.sample
 */
public suspend inline fun AutoScalingClient.describeScalingActivities(crossinline block: DescribeScalingActivitiesRequest.Builder.() -> Unit): DescribeScalingActivitiesResponse = describeScalingActivities(DescribeScalingActivitiesRequest.Builder().apply(block).build())

/**
 * Describes the scaling process types for use with the ResumeProcesses and SuspendProcesses APIs.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeScalingProcessTypes.sample
 */
public suspend inline fun AutoScalingClient.describeScalingProcessTypes(crossinline block: DescribeScalingProcessTypesRequest.Builder.() -> Unit): DescribeScalingProcessTypesResponse = describeScalingProcessTypes(DescribeScalingProcessTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the scheduled actions that haven't run or that have not reached their end time.
 *
 * To describe the scaling activities for scheduled actions that have already run, call the DescribeScalingActivities API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeScheduledActions.sample
 */
public suspend inline fun AutoScalingClient.describeScheduledActions(crossinline block: DescribeScheduledActionsRequest.Builder.() -> Unit): DescribeScheduledActionsResponse = describeScheduledActions(DescribeScheduledActionsRequest.Builder().apply(block).build())

/**
 * Describes the specified tags.
 *
 * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it to be included in the results.
 *
 * You can also specify multiple filters. The result includes information for a particular tag only if it matches all the filters. If there's no match, no special message is returned.
 *
 * For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeTags.sample
 */
public suspend inline fun AutoScalingClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Describes the termination policies supported by Amazon EC2 Auto Scaling.
 *
 * For more information, see [Work with Amazon EC2 Auto Scaling termination policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeTerminationPolicyTypes.sample
 */
public suspend inline fun AutoScalingClient.describeTerminationPolicyTypes(crossinline block: DescribeTerminationPolicyTypesRequest.Builder.() -> Unit): DescribeTerminationPolicyTypesResponse = describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest.Builder().apply(block).build())

/**
 * Gets information about the traffic sources for the specified Auto Scaling group.
 *
 * You can optionally provide a traffic source type. If you provide a traffic source type, then the results only include that traffic source type.
 *
 * If you do not provide a traffic source type, then the results include all the traffic sources for the specified Auto Scaling group.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DescribeTrafficSources.sample
 */
public suspend inline fun AutoScalingClient.describeTrafficSources(crossinline block: DescribeTrafficSourcesRequest.Builder.() -> Unit): DescribeTrafficSourcesResponse = describeTrafficSources(DescribeTrafficSourcesRequest.Builder().apply(block).build())

/**
 * Gets information about a warm pool and its instances.
 *
 * For more information, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public suspend inline fun AutoScalingClient.describeWarmPool(crossinline block: DescribeWarmPoolRequest.Builder.() -> Unit): DescribeWarmPoolResponse = describeWarmPool(DescribeWarmPoolRequest.Builder().apply(block).build())

/**
 * Removes one or more instances from the specified Auto Scaling group.
 *
 * After the instances are detached, you can manage them independent of the Auto Scaling group.
 *
 * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are detached.
 *
 * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from the target groups.
 *
 * For more information, see [Detach EC2 instances from your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachInstances.sample
 */
public suspend inline fun AutoScalingClient.detachInstances(crossinline block: DetachInstancesRequest.Builder.() -> Unit): DetachInstancesResponse = detachInstances(DetachInstancesRequest.Builder().apply(block).build())

/**
 * This API operation is superseded by DetachTrafficSources, which can detach multiple traffic sources types. We recommend using `DetachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DetachLoadBalancerTargetGroups`. You can use both the original `DetachLoadBalancerTargetGroups` API operation and `DetachTrafficSources` on the same Auto Scaling group.
 *
 * Detaches one or more target groups from the specified Auto Scaling group.
 *
 * When you detach a target group, it enters the `Removing` state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the target group using the DescribeLoadBalancerTargetGroups API call. The instances remain running.
 *
 * You can use this operation to detach target groups that were attached by using AttachLoadBalancerTargetGroups, but not for target groups that were attached by using AttachTrafficSources.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachLoadBalancerTargetGroups.sample
 */
public suspend inline fun AutoScalingClient.detachLoadBalancerTargetGroups(crossinline block: DetachLoadBalancerTargetGroupsRequest.Builder.() -> Unit): DetachLoadBalancerTargetGroupsResponse = detachLoadBalancerTargetGroups(DetachLoadBalancerTargetGroupsRequest.Builder().apply(block).build())

/**
 * This API operation is superseded by DetachTrafficSources, which can detach multiple traffic sources types. We recommend using `DetachTrafficSources` to simplify how you manage traffic sources. However, we continue to support `DetachLoadBalancers`. You can use both the original `DetachLoadBalancers` API operation and `DetachTrafficSources` on the same Auto Scaling group.
 *
 * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
 *
 * This operation detaches only Classic Load Balancers. If you have Application Load Balancers, Network Load Balancers, or Gateway Load Balancers, use the DetachLoadBalancerTargetGroups API instead.
 *
 * When you detach a load balancer, it enters the `Removing` state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the load balancer using the DescribeLoadBalancers API call. The instances remain running.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachLoadBalancers.sample
 */
public suspend inline fun AutoScalingClient.detachLoadBalancers(crossinline block: DetachLoadBalancersRequest.Builder.() -> Unit): DetachLoadBalancersResponse = detachLoadBalancers(DetachLoadBalancersRequest.Builder().apply(block).build())

/**
 * Detaches one or more traffic sources from the specified Auto Scaling group.
 *
 * When you detach a traffic source, it enters the `Removing` state while deregistering the instances in the group. When all instances are deregistered, then you can no longer describe the traffic source using the DescribeTrafficSources API call. The instances continue to run.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DetachTrafficSources.sample
 */
public suspend inline fun AutoScalingClient.detachTrafficSources(crossinline block: DetachTrafficSourcesRequest.Builder.() -> Unit): DetachTrafficSourcesResponse = detachTrafficSources(DetachTrafficSourcesRequest.Builder().apply(block).build())

/**
 * Disables group metrics collection for the specified Auto Scaling group.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.DisableMetricsCollection.sample
 */
public suspend inline fun AutoScalingClient.disableMetricsCollection(crossinline block: DisableMetricsCollectionRequest.Builder.() -> Unit): DisableMetricsCollectionResponse = disableMetricsCollection(DisableMetricsCollectionRequest.Builder().apply(block).build())

/**
 * Enables group metrics collection for the specified Auto Scaling group.
 *
 * You can use these metrics to track changes in an Auto Scaling group and to set alarms on threshold values. You can view group metrics using the Amazon EC2 Auto Scaling console or the CloudWatch console. For more information, see [Monitor CloudWatch metrics for your Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.EnableMetricsCollection.sample
 */
public suspend inline fun AutoScalingClient.enableMetricsCollection(crossinline block: EnableMetricsCollectionRequest.Builder.() -> Unit): EnableMetricsCollectionResponse = enableMetricsCollection(EnableMetricsCollectionRequest.Builder().apply(block).build())

/**
 * Moves the specified instances into the standby state.
 *
 * If you choose to decrement the desired capacity of the Auto Scaling group, the instances can enter standby as long as the desired capacity of the Auto Scaling group after the instances are placed into standby is equal to or greater than the minimum capacity of the group.
 *
 * If you choose not to decrement the desired capacity of the Auto Scaling group, the Auto Scaling group launches new instances to replace the instances on standby.
 *
 * For more information, see [Temporarily removing instances from your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.EnterStandby.sample
 */
public suspend inline fun AutoScalingClient.enterStandby(crossinline block: EnterStandbyRequest.Builder.() -> Unit): EnterStandbyResponse = enterStandby(EnterStandbyRequest.Builder().apply(block).build())

/**
 * Executes the specified policy. This can be useful for testing the design of your scaling policy.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.ExecutePolicy.sample
 */
public suspend inline fun AutoScalingClient.executePolicy(crossinline block: ExecutePolicyRequest.Builder.() -> Unit): ExecutePolicyResponse = executePolicy(ExecutePolicyRequest.Builder().apply(block).build())

/**
 * Moves the specified instances out of the standby state.
 *
 * After you put the instances back in service, the desired capacity is incremented.
 *
 * For more information, see [Temporarily removing instances from your Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.ExitStandby.sample
 */
public suspend inline fun AutoScalingClient.exitStandby(crossinline block: ExitStandbyRequest.Builder.() -> Unit): ExitStandbyResponse = exitStandby(ExitStandbyRequest.Builder().apply(block).build())

/**
 * Retrieves the forecast data for a predictive scaling policy.
 *
 * Load forecasts are predictions of the hourly load values using historical load data from CloudWatch and an analysis of historical trends. Capacity forecasts are represented as predicted values for the minimum capacity that is needed on an hourly basis, based on the hourly load forecast.
 *
 * A minimum of 24 hours of data is required to create the initial forecasts. However, having a full 14 days of historical data results in more accurate forecasts.
 *
 * For more information, see [Predictive scaling for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public suspend inline fun AutoScalingClient.getPredictiveScalingForecast(crossinline block: GetPredictiveScalingForecastRequest.Builder.() -> Unit): GetPredictiveScalingForecastResponse = getPredictiveScalingForecast(GetPredictiveScalingForecastRequest.Builder().apply(block).build())

/**
 * Creates or updates a lifecycle hook for the specified Auto Scaling group.
 *
 * Lifecycle hooks let you create solutions that are aware of events in the Auto Scaling instance lifecycle, and then perform a custom action on instances when the corresponding lifecycle event occurs.
 *
 * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
 * + (Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.
 * + (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.
 * + (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
 * + **Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.**
 * + If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state using the RecordLifecycleActionHeartbeat API call.
 * + If you finish before the timeout period ends, send a callback by using the CompleteLifecycleAction API call.
 *
 * For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call fails.
 *
 * You can view the lifecycle hooks for an Auto Scaling group using the DescribeLifecycleHooks API call. If you are no longer using a lifecycle hook, you can delete it by calling the DeleteLifecycleHook API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.PutLifecycleHook.sample
 */
public suspend inline fun AutoScalingClient.putLifecycleHook(crossinline block: PutLifecycleHookRequest.Builder.() -> Unit): PutLifecycleHookResponse = putLifecycleHook(PutLifecycleHookRequest.Builder().apply(block).build())

/**
 * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the specified topic can have messages delivered to an endpoint such as a web server or an email address.
 *
 * This configuration overwrites any existing configuration.
 *
 * For more information, see [Getting Amazon SNS notifications when your Auto Scaling group scales](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * If you exceed your maximum limit of SNS topics, which is 10 per Auto Scaling group, the call fails.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.PutNotificationConfiguration.sample
 */
public suspend inline fun AutoScalingClient.putNotificationConfiguration(crossinline block: PutNotificationConfigurationRequest.Builder.() -> Unit): PutNotificationConfigurationResponse = putNotificationConfiguration(PutNotificationConfigurationRequest.Builder().apply(block).build())

/**
 * Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling features are not used.
 *
 * For more information about using dynamic scaling, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html) and [Step and simple scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * For more information about using predictive scaling, see [Predictive scaling for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * You can view the scaling policies for an Auto Scaling group using the DescribePolicies API call. If you are no longer using a scaling policy, you can delete it by calling the DeletePolicy API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.PutScalingPolicy.sample
 */
public suspend inline fun AutoScalingClient.putScalingPolicy(crossinline block: PutScalingPolicyRequest.Builder.() -> Unit): PutScalingPolicyResponse = putScalingPolicy(PutScalingPolicyRequest.Builder().apply(block).build())

/**
 * Creates or updates a scheduled scaling action for an Auto Scaling group.
 *
 * For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * You can view the scheduled actions for an Auto Scaling group using the DescribeScheduledActions API call. If you are no longer using a scheduled action, you can delete it by calling the DeleteScheduledAction API.
 *
 * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.PutScheduledUpdateGroupAction.sample
 */
public suspend inline fun AutoScalingClient.putScheduledUpdateGroupAction(crossinline block: PutScheduledUpdateGroupActionRequest.Builder.() -> Unit): PutScheduledUpdateGroupActionResponse = putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest.Builder().apply(block).build())

/**
 * Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity. For more information and example configurations, see [Warm pools for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * This operation must be called from the Region in which the Auto Scaling group was created. This operation cannot be called on an Auto Scaling group that has a mixed instances policy or a launch template or launch configuration that requests Spot Instances.
 *
 * You can view the instances in the warm pool using the DescribeWarmPool API call. If you are no longer using a warm pool, you can delete it by calling the DeleteWarmPool API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.PutWarmPool.sample
 */
public suspend inline fun AutoScalingClient.putWarmPool(crossinline block: PutWarmPoolRequest.Builder.() -> Unit): PutWarmPoolResponse = putWarmPool(PutWarmPoolRequest.Builder().apply(block).build())

/**
 * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the timeout by the length of time defined using the PutLifecycleHook API call.
 *
 * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
 * + (Optional) Create a launch template or launch configuration with a user data script that runs while an instance is in a wait state due to a lifecycle hook.
 * + (Optional) Create a Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda function when an instance is put into a wait state due to a lifecycle hook.
 * + (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
 * + Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
 * + **If you need more time, record the lifecycle action heartbeat to keep the instance in a wait state.**
 * + If you finish before the timeout period ends, send a callback by using the CompleteLifecycleAction API call.
 *
 * For more information, see [Amazon EC2 Auto Scaling lifecycle hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.RecordLifecycleActionHeartbeat.sample
 */
public suspend inline fun AutoScalingClient.recordLifecycleActionHeartbeat(crossinline block: RecordLifecycleActionHeartbeatRequest.Builder.() -> Unit): RecordLifecycleActionHeartbeatResponse = recordLifecycleActionHeartbeat(RecordLifecycleActionHeartbeatRequest.Builder().apply(block).build())

/**
 * Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling group.
 *
 * For more information, see [Suspending and resuming scaling processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.ResumeProcesses.sample
 */
public suspend inline fun AutoScalingClient.resumeProcesses(crossinline block: ResumeProcessesRequest.Builder.() -> Unit): ResumeProcessesResponse = resumeProcesses(ResumeProcessesRequest.Builder().apply(block).build())

/**
 * Cancels an instance refresh that is in progress and rolls back any changes that it made. Amazon EC2 Auto Scaling replaces any instances that were replaced during the instance refresh. This restores your Auto Scaling group to the configuration that it was using before the start of the instance refresh.
 *
 * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group after you make configuration changes.
 *
 * A rollback is not supported in the following situations:
 * + There is no desired configuration specified for the instance refresh.
 * + The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead of an AMI ID for the `ImageId` property.
 * + The Auto Scaling group uses the launch template's `$Latest` or `$Default` version.
 *
 * When you receive a successful response from this operation, Amazon EC2 Auto Scaling immediately begins replacing instances. You can check the status of this operation through the DescribeInstanceRefreshes API operation.
 */
public suspend inline fun AutoScalingClient.rollbackInstanceRefresh(crossinline block: RollbackInstanceRefreshRequest.Builder.() -> Unit): RollbackInstanceRefreshResponse = rollbackInstanceRefresh(RollbackInstanceRefreshRequest.Builder().apply(block).build())

/**
 * Sets the size of the specified Auto Scaling group.
 *
 * If a scale-in activity occurs as a result of a new `DesiredCapacity` value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate.
 *
 * For more information, see [Manual scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.SetDesiredCapacity.sample
 */
public suspend inline fun AutoScalingClient.setDesiredCapacity(crossinline block: SetDesiredCapacityRequest.Builder.() -> Unit): SetDesiredCapacityResponse = setDesiredCapacity(SetDesiredCapacityRequest.Builder().apply(block).build())

/**
 * Sets the health status of the specified instance.
 *
 * For more information, see [Health checks for Auto Scaling instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.SetInstanceHealth.sample
 */
public suspend inline fun AutoScalingClient.setInstanceHealth(crossinline block: SetInstanceHealthRequest.Builder.() -> Unit): SetInstanceHealthResponse = setInstanceHealth(SetInstanceHealthRequest.Builder().apply(block).build())

/**
 * Updates the instance protection settings of the specified instances. This operation cannot be called on instances in a warm pool.
 *
 * For more information about preventing instances that are part of an Auto Scaling group from terminating on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * If you exceed your maximum limit of instance IDs, which is 50 per Auto Scaling group, the call fails.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.SetInstanceProtection.sample
 */
public suspend inline fun AutoScalingClient.setInstanceProtection(crossinline block: SetInstanceProtectionRequest.Builder.() -> Unit): SetInstanceProtectionResponse = setInstanceProtection(SetInstanceProtectionRequest.Builder().apply(block).build())

/**
 * Starts an instance refresh.
 *
 * This operation is part of the [instance refresh feature](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html) in Amazon EC2 Auto Scaling, which helps you update instances in your Auto Scaling group. This feature is helpful, for example, when you have a new AMI or a new user data script. You just need to create a new launch template that specifies the new AMI or user data script. Then start an instance refresh to immediately begin the process of updating instances in the group.
 *
 * If successful, the request's response contains a unique ID that you can use to track the progress of the instance refresh. To query its status, call the DescribeInstanceRefreshes API. To describe the instance refreshes that have already run, call the DescribeInstanceRefreshes API. To cancel an instance refresh that is in progress, use the CancelInstanceRefresh API.
 *
 * An instance refresh might fail for several reasons, such as EC2 launch failures, misconfigured health checks, or not ignoring or allowing the termination of instances that are in `Standby` state or protected from scale in. You can monitor for failed EC2 launches using the scaling activities. To find the scaling activities, call the DescribeScalingActivities API.
 *
 * If you enable auto rollback, your Auto Scaling group will be rolled back automatically when the instance refresh fails. You can enable this feature before starting an instance refresh by specifying the `AutoRollback` property in the instance refresh preferences. Otherwise, to roll back an instance refresh before it finishes, use the RollbackInstanceRefresh API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.StartInstanceRefresh.sample
 */
public suspend inline fun AutoScalingClient.startInstanceRefresh(crossinline block: StartInstanceRefreshRequest.Builder.() -> Unit): StartInstanceRefreshResponse = startInstanceRefresh(StartInstanceRefreshRequest.Builder().apply(block).build())

/**
 * Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.
 *
 * If you suspend either the `Launch` or `Terminate` process types, it can prevent other process types from functioning properly. For more information, see [Suspending and resuming scaling processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * To resume processes that have been suspended, call the ResumeProcesses API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.SuspendProcesses.sample
 */
public suspend inline fun AutoScalingClient.suspendProcesses(crossinline block: SuspendProcessesRequest.Builder.() -> Unit): SuspendProcessesResponse = suspendProcesses(SuspendProcessesRequest.Builder().apply(block).build())

/**
 * Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called on instances in a warm pool.
 *
 * This call simply makes a termination request. The instance is not terminated immediately. When an instance is terminated, the instance status changes to `terminated`. You can't connect to or start an instance after you've terminated it.
 *
 * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to replace the ones that are terminated.
 *
 * By default, Amazon EC2 Auto Scaling balances instances across all Availability Zones. If you decrement the desired capacity, your Auto Scaling group can become unbalanced between Availability Zones. Amazon EC2 Auto Scaling tries to rebalance the group, and rebalancing might terminate instances in other zones. For more information, see [Rebalancing activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage) in the *Amazon EC2 Auto Scaling User Guide*.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.TerminateInstanceInAutoScalingGroup.sample
 */
public suspend inline fun AutoScalingClient.terminateInstanceInAutoScalingGroup(crossinline block: TerminateInstanceInAutoScalingGroupRequest.Builder.() -> Unit): TerminateInstanceInAutoScalingGroupResponse = terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest.Builder().apply(block).build())

/**
 * **We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.**
 *
 * Updates the configuration for the specified Auto Scaling group.
 *
 * To update an Auto Scaling group, specify the name of the group and the property that you want to change. Any properties that you don't specify are not changed by this update request. The new settings take effect on any scaling activities after this call returns.
 *
 * If you associate a new launch configuration or template with an Auto Scaling group, all new instances will get the updated configuration. Existing instances continue to run with the configuration that they were originally launched with. When you update a group to specify a mixed instances policy instead of a launch configuration or template, existing instances may be replaced to match the new purchasing options that you specified in the policy. For example, if the group currently has 100% On-Demand capacity and the policy specifies 50% Spot capacity, this means that half of your instances will be gradually terminated and relaunched as Spot Instances. When replacing instances, Amazon EC2 Auto Scaling launches new instances before terminating the old ones, so that updating your group does not compromise the performance or availability of your application.
 *
 * Note the following about changing `DesiredCapacity`, `MaxSize`, or `MinSize`:
 * + If a scale-in activity occurs as a result of a new `DesiredCapacity` value that is lower than the current size of the group, the Auto Scaling group uses its termination policy to determine which instances to terminate.
 * + If you specify a new value for `MinSize` without specifying a value for `DesiredCapacity`, and the new `MinSize` is larger than the current size of the group, this sets the group's `DesiredCapacity` to the new `MinSize` value.
 * + If you specify a new value for `MaxSize` without specifying a value for `DesiredCapacity`, and the new `MaxSize` is smaller than the current size of the group, this sets the group's `DesiredCapacity` to the new `MaxSize` value.
 *
 * To see which properties have been set, call the DescribeAutoScalingGroups API. To view the scaling policies for an Auto Scaling group, call the DescribePolicies API. If the group has scaling policies, you can update them by calling the PutScalingPolicy API.
 *
 * @sample aws.sdk.kotlin.services.autoscaling.samples.UpdateAutoScalingGroup.sample
 */
public suspend inline fun AutoScalingClient.updateAutoScalingGroup(crossinline block: UpdateAutoScalingGroupRequest.Builder.() -> Unit): UpdateAutoScalingGroupResponse = updateAutoScalingGroup(UpdateAutoScalingGroupRequest.Builder().apply(block).build())
