// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.UpdateAutoScalingGroupResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateAutoScalingGroupOperationDeserializer: HttpDeserialize<UpdateAutoScalingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateAutoScalingGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateAutoScalingGroupError(context, call)
        }
        val builder = UpdateAutoScalingGroupResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateAutoScalingGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ScalingActivityInProgress" -> ScalingActivityInProgressFaultDeserializer().deserialize(context, wrappedCall)
        "ServiceLinkedRoleFailure" -> ServiceLinkedRoleFailureDeserializer().deserialize(context, wrappedCall)
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedCall)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
