// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.serde

import aws.sdk.kotlin.services.autoscaling.model.InstanceReusePolicy
import aws.sdk.kotlin.services.autoscaling.model.PutWarmPoolRequest
import aws.sdk.kotlin.services.autoscaling.model.WarmPoolState
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutWarmPoolOperationSerializer: HttpSerialize<PutWarmPoolRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutWarmPoolRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializePutWarmPoolOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializePutWarmPoolOperationBody(context: ExecutionContext, input: PutWarmPoolRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AUTOSCALINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AutoScalingGroupName"))
    val INSTANCEREUSEPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("InstanceReusePolicy"))
    val MAXGROUPPREPAREDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxGroupPreparedCapacity"))
    val MINSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MinSize"))
    val POOLSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("PoolState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("PutWarmPoolType"))
        trait(QueryLiteral("Action", "PutWarmPool"))
        trait(QueryLiteral("Version", "2011-01-01"))
        field(AUTOSCALINGGROUPNAME_DESCRIPTOR)
        field(INSTANCEREUSEPOLICY_DESCRIPTOR)
        field(MAXGROUPPREPAREDCAPACITY_DESCRIPTOR)
        field(MINSIZE_DESCRIPTOR)
        field(POOLSTATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.autoScalingGroupName?.let { field(AUTOSCALINGGROUPNAME_DESCRIPTOR, it) }
        input.instanceReusePolicy?.let { field(INSTANCEREUSEPOLICY_DESCRIPTOR, it, ::serializeInstanceReusePolicyDocument) }
        input.maxGroupPreparedCapacity?.let { field(MAXGROUPPREPAREDCAPACITY_DESCRIPTOR, it) }
        input.minSize?.let { field(MINSIZE_DESCRIPTOR, it) }
        input.poolState?.let { field(POOLSTATE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
