// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes the state of a traffic source.
 */
public class TrafficSourceState private constructor(builder: Builder) {
    /**
     * The unique identifier of the traffic source.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * Describes the current state of a traffic source.
     *
     * The state values are as follows:
     * + `Adding` - The Auto Scaling instances are being registered with the load balancer or target group.
     * + `Added` - All Auto Scaling instances are registered with the load balancer or target group.
     * + `InService` - For an Elastic Load Balancing load balancer or target group, at least one Auto Scaling instance passed an `ELB` health check. For VPC Lattice, at least one Auto Scaling instance passed an `VPC_LATTICE` health check.
     * + `Removing` - The Auto Scaling instances are being deregistered from the load balancer or target group. If connection draining (deregistration delay) is enabled, Elastic Load Balancing or VPC Lattice waits for in-flight requests to complete before deregistering the instances.
     * + `Removed` - All Auto Scaling instances are deregistered from the load balancer or target group.
     */
    public val state: kotlin.String? = builder.state
    /**
     * This is replaced by `Identifier`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val trafficSource: kotlin.String? = builder.trafficSource
    /**
     * Provides additional context for the value of `Identifier`.
     *
     * The following lists the valid values:
     * + `elb` if `Identifier` is the name of a Classic Load Balancer.
     * + `elbv2` if `Identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
     * + `vpc-lattice` if `Identifier` is the ARN of a VPC Lattice target group.
     *
     * Required if the identifier is the name of a Classic Load Balancer.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.TrafficSourceState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficSourceState(")
        append("identifier=$identifier,")
        append("state=$state,")
        append("trafficSource=$trafficSource,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identifier?.hashCode() ?: 0
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (trafficSource?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficSourceState

        if (identifier != other.identifier) return false
        if (state != other.state) return false
        if (trafficSource != other.trafficSource) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.TrafficSourceState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the traffic source.
         */
        public var identifier: kotlin.String? = null
        /**
         * Describes the current state of a traffic source.
         *
         * The state values are as follows:
         * + `Adding` - The Auto Scaling instances are being registered with the load balancer or target group.
         * + `Added` - All Auto Scaling instances are registered with the load balancer or target group.
         * + `InService` - For an Elastic Load Balancing load balancer or target group, at least one Auto Scaling instance passed an `ELB` health check. For VPC Lattice, at least one Auto Scaling instance passed an `VPC_LATTICE` health check.
         * + `Removing` - The Auto Scaling instances are being deregistered from the load balancer or target group. If connection draining (deregistration delay) is enabled, Elastic Load Balancing or VPC Lattice waits for in-flight requests to complete before deregistering the instances.
         * + `Removed` - All Auto Scaling instances are deregistered from the load balancer or target group.
         */
        public var state: kotlin.String? = null
        /**
         * This is replaced by `Identifier`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var trafficSource: kotlin.String? = null
        /**
         * Provides additional context for the value of `Identifier`.
         *
         * The following lists the valid values:
         * + `elb` if `Identifier` is the name of a Classic Load Balancer.
         * + `elbv2` if `Identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
         * + `vpc-lattice` if `Identifier` is the ARN of a VPC Lattice target group.
         *
         * Required if the identifier is the name of a Classic Load Balancer.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.TrafficSourceState) : this() {
            this.identifier = x.identifier
            this.state = x.state
            this.trafficSource = x.trafficSource
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.TrafficSourceState = TrafficSourceState(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
