// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



public class StartInstanceRefreshRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The desired configuration. For example, the desired configuration can specify a new launch template or a new version of the current launch template.
     *
     * Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to reflect the new desired configuration.
     *
     * When you specify a new launch template or a new version of the current launch template for your desired configuration, consider enabling the `SkipMatching` property in preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and instance types. This can help you reduce the number of replacements that are required to apply updates.
     */
    public val desiredConfiguration: aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration? = builder.desiredConfiguration
    /**
     * Sets your preferences for the instance refresh so that it performs as expected when you start it. Includes the instance warmup time, the minimum and maximum healthy percentages, and the behaviors that you want Amazon EC2 Auto Scaling to use if instances that are in `Standby` state or protected from scale in are found. You can also choose to enable additional features, such as the following:
     * + Auto rollback
     * + Checkpoints
     * + CloudWatch alarms
     * + Skip matching
     */
    public val preferences: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences? = builder.preferences
    /**
     * The strategy to use for the instance refresh. The only valid value is `Rolling`.
     */
    public val strategy: aws.sdk.kotlin.services.autoscaling.model.RefreshStrategy? = builder.strategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.StartInstanceRefreshRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartInstanceRefreshRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("desiredConfiguration=$desiredConfiguration,")
        append("preferences=$preferences,")
        append("strategy=$strategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (desiredConfiguration?.hashCode() ?: 0)
        result = 31 * result + (preferences?.hashCode() ?: 0)
        result = 31 * result + (strategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartInstanceRefreshRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (desiredConfiguration != other.desiredConfiguration) return false
        if (preferences != other.preferences) return false
        if (strategy != other.strategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.StartInstanceRefreshRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The desired configuration. For example, the desired configuration can specify a new launch template or a new version of the current launch template.
         *
         * Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to reflect the new desired configuration.
         *
         * When you specify a new launch template or a new version of the current launch template for your desired configuration, consider enabling the `SkipMatching` property in preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and instance types. This can help you reduce the number of replacements that are required to apply updates.
         */
        public var desiredConfiguration: aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration? = null
        /**
         * Sets your preferences for the instance refresh so that it performs as expected when you start it. Includes the instance warmup time, the minimum and maximum healthy percentages, and the behaviors that you want Amazon EC2 Auto Scaling to use if instances that are in `Standby` state or protected from scale in are found. You can also choose to enable additional features, such as the following:
         * + Auto rollback
         * + Checkpoints
         * + CloudWatch alarms
         * + Skip matching
         */
        public var preferences: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences? = null
        /**
         * The strategy to use for the instance refresh. The only valid value is `Rolling`.
         */
        public var strategy: aws.sdk.kotlin.services.autoscaling.model.RefreshStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.StartInstanceRefreshRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.desiredConfiguration = x.desiredConfiguration
            this.preferences = x.preferences
            this.strategy = x.strategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.StartInstanceRefreshRequest = StartInstanceRefreshRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration] inside the given [block]
         */
        public fun desiredConfiguration(block: aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration.Builder.() -> kotlin.Unit) {
            this.desiredConfiguration = aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences] inside the given [block]
         */
        public fun preferences(block: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences.Builder.() -> kotlin.Unit) {
            this.preferences = aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
