// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes the preferences for an instance refresh.
 */
public class RefreshPreferences private constructor(builder: Builder) {
    /**
     * (Optional) The CloudWatch alarm specification. CloudWatch alarms can be used to identify any issues and fail the operation if an alarm threshold is met.
     */
    public val alarmSpecification: aws.sdk.kotlin.services.autoscaling.model.AlarmSpecification? = builder.alarmSpecification
    /**
     * (Optional) Indicates whether to roll back the Auto Scaling group to its previous configuration if the instance refresh fails or a CloudWatch alarm threshold is met. The default is `false`.
     *
     * A rollback is not supported in the following situations:
     * + There is no desired configuration specified for the instance refresh.
     * + The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead of an AMI ID for the `ImageId` property.
     * + The Auto Scaling group uses the launch template's `$Latest` or `$Default` version.
     *
     * For more information, see [Undo changes with a rollback](https://docs.aws.amazon.com/autoscaling/ec2/userguide/instance-refresh-rollback.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val autoRollback: kotlin.Boolean? = builder.autoRollback
    /**
     * (Optional) The amount of time, in seconds, to wait after a checkpoint before continuing. This property is optional, but if you specify a value for it, you must also specify a value for `CheckpointPercentages`. If you specify a value for `CheckpointPercentages` and not for `CheckpointDelay`, the `CheckpointDelay` defaults to `3600` (1 hour).
     */
    public val checkpointDelay: kotlin.Int? = builder.checkpointDelay
    /**
     * (Optional) Threshold values for each checkpoint in ascending order. Each number must be unique. To replace all instances in the Auto Scaling group, the last number in the array must be `100`.
     *
     * For usage examples, see [Adding checkpoints to an instance refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val checkpointPercentages: List<Int>? = builder.checkpointPercentages
    /**
     * A time period, in seconds, during which an instance refresh waits before moving on to replacing the next instance after a new instance enters the `InService` state.
     *
     * This property is not required for normal usage. Instead, use the `DefaultInstanceWarmup` property of the Auto Scaling group. The `InstanceWarmup` and `DefaultInstanceWarmup` properties work the same way. Only specify this property if you must override the `DefaultInstanceWarmup` property.
     *
     *  If you do not specify this property, the instance warmup by default is the value of the `DefaultInstanceWarmup` property, if defined (which is recommended in all cases), or the `HealthCheckGracePeriod` property otherwise.
     */
    public val instanceWarmup: kotlin.Int? = builder.instanceWarmup
    /**
     * Specifies the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. The value is expressed as a percentage of the desired capacity of the Auto Scaling group. Value range is 100 to 200.
     *
     * If you specify `MaxHealthyPercentage`, you must also specify `MinHealthyPercentage`, and the difference between them cannot be greater than 100. A larger range increases the number of instances that can be replaced at the same time.
     *
     * If you do not specify this property, the default is 100 percent, or the percentage set in the instance maintenance policy for the Auto Scaling group, if defined.
     */
    public val maxHealthyPercentage: kotlin.Int? = builder.maxHealthyPercentage
    /**
     * Specifies the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload to allow the operation to continue. The value is expressed as a percentage of the desired capacity of the Auto Scaling group. Value range is 0 to 100.
     *
     * If you do not specify this property, the default is 90 percent, or the percentage set in the instance maintenance policy for the Auto Scaling group, if defined.
     */
    public val minHealthyPercentage: kotlin.Int? = builder.minHealthyPercentage
    /**
     * Choose the behavior that you want Amazon EC2 Auto Scaling to use if instances protected from scale in are found.
     *
     * The following lists the valid values:
     *
     * ## Refresh
     * Amazon EC2 Auto Scaling replaces instances that are protected from scale in.
     *
     * ## Ignore
     * Amazon EC2 Auto Scaling ignores instances that are protected from scale in and continues to replace instances that are not protected.
     *
     * ## Wait (default)
     * Amazon EC2 Auto Scaling waits one hour for you to remove scale-in protection. Otherwise, the instance refresh will fail.
     */
    public val scaleInProtectedInstances: aws.sdk.kotlin.services.autoscaling.model.ScaleInProtectedInstances? = builder.scaleInProtectedInstances
    /**
     * (Optional) Indicates whether skip matching is enabled. If enabled (`true`), then Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired configuration is specified, then it skips replacing instances that have the same launch template and instance types that the Auto Scaling group was using before the start of the instance refresh. The default is `false`.
     *
     * For more information, see [Use an instance refresh with skip matching](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh-skip-matching.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val skipMatching: kotlin.Boolean? = builder.skipMatching
    /**
     * Choose the behavior that you want Amazon EC2 Auto Scaling to use if instances in `Standby` state are found.
     *
     * The following lists the valid values:
     *
     * ## Terminate
     * Amazon EC2 Auto Scaling terminates instances that are in `Standby`.
     *
     * ## Ignore
     * Amazon EC2 Auto Scaling ignores instances that are in `Standby` and continues to replace instances that are in the `InService` state.
     *
     * ## Wait (default)
     * Amazon EC2 Auto Scaling waits one hour for you to return the instances to service. Otherwise, the instance refresh will fail.
     */
    public val standbyInstances: aws.sdk.kotlin.services.autoscaling.model.StandbyInstances? = builder.standbyInstances

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RefreshPreferences(")
        append("alarmSpecification=$alarmSpecification,")
        append("autoRollback=$autoRollback,")
        append("checkpointDelay=$checkpointDelay,")
        append("checkpointPercentages=$checkpointPercentages,")
        append("instanceWarmup=$instanceWarmup,")
        append("maxHealthyPercentage=$maxHealthyPercentage,")
        append("minHealthyPercentage=$minHealthyPercentage,")
        append("scaleInProtectedInstances=$scaleInProtectedInstances,")
        append("skipMatching=$skipMatching,")
        append("standbyInstances=$standbyInstances")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmSpecification?.hashCode() ?: 0
        result = 31 * result + (autoRollback?.hashCode() ?: 0)
        result = 31 * result + (checkpointDelay ?: 0)
        result = 31 * result + (checkpointPercentages?.hashCode() ?: 0)
        result = 31 * result + (instanceWarmup ?: 0)
        result = 31 * result + (maxHealthyPercentage ?: 0)
        result = 31 * result + (minHealthyPercentage ?: 0)
        result = 31 * result + (scaleInProtectedInstances?.hashCode() ?: 0)
        result = 31 * result + (skipMatching?.hashCode() ?: 0)
        result = 31 * result + (standbyInstances?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RefreshPreferences

        if (alarmSpecification != other.alarmSpecification) return false
        if (autoRollback != other.autoRollback) return false
        if (checkpointDelay != other.checkpointDelay) return false
        if (checkpointPercentages != other.checkpointPercentages) return false
        if (instanceWarmup != other.instanceWarmup) return false
        if (maxHealthyPercentage != other.maxHealthyPercentage) return false
        if (minHealthyPercentage != other.minHealthyPercentage) return false
        if (scaleInProtectedInstances != other.scaleInProtectedInstances) return false
        if (skipMatching != other.skipMatching) return false
        if (standbyInstances != other.standbyInstances) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences = Builder(this).apply(block).build()

    public class Builder {
        /**
         * (Optional) The CloudWatch alarm specification. CloudWatch alarms can be used to identify any issues and fail the operation if an alarm threshold is met.
         */
        public var alarmSpecification: aws.sdk.kotlin.services.autoscaling.model.AlarmSpecification? = null
        /**
         * (Optional) Indicates whether to roll back the Auto Scaling group to its previous configuration if the instance refresh fails or a CloudWatch alarm threshold is met. The default is `false`.
         *
         * A rollback is not supported in the following situations:
         * + There is no desired configuration specified for the instance refresh.
         * + The Auto Scaling group has a launch template that uses an Amazon Web Services Systems Manager parameter instead of an AMI ID for the `ImageId` property.
         * + The Auto Scaling group uses the launch template's `$Latest` or `$Default` version.
         *
         * For more information, see [Undo changes with a rollback](https://docs.aws.amazon.com/autoscaling/ec2/userguide/instance-refresh-rollback.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var autoRollback: kotlin.Boolean? = null
        /**
         * (Optional) The amount of time, in seconds, to wait after a checkpoint before continuing. This property is optional, but if you specify a value for it, you must also specify a value for `CheckpointPercentages`. If you specify a value for `CheckpointPercentages` and not for `CheckpointDelay`, the `CheckpointDelay` defaults to `3600` (1 hour).
         */
        public var checkpointDelay: kotlin.Int? = null
        /**
         * (Optional) Threshold values for each checkpoint in ascending order. Each number must be unique. To replace all instances in the Auto Scaling group, the last number in the array must be `100`.
         *
         * For usage examples, see [Adding checkpoints to an instance refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var checkpointPercentages: List<Int>? = null
        /**
         * A time period, in seconds, during which an instance refresh waits before moving on to replacing the next instance after a new instance enters the `InService` state.
         *
         * This property is not required for normal usage. Instead, use the `DefaultInstanceWarmup` property of the Auto Scaling group. The `InstanceWarmup` and `DefaultInstanceWarmup` properties work the same way. Only specify this property if you must override the `DefaultInstanceWarmup` property.
         *
         *  If you do not specify this property, the instance warmup by default is the value of the `DefaultInstanceWarmup` property, if defined (which is recommended in all cases), or the `HealthCheckGracePeriod` property otherwise.
         */
        public var instanceWarmup: kotlin.Int? = null
        /**
         * Specifies the maximum percentage of the group that can be in service and healthy, or pending, to support your workload when replacing instances. The value is expressed as a percentage of the desired capacity of the Auto Scaling group. Value range is 100 to 200.
         *
         * If you specify `MaxHealthyPercentage`, you must also specify `MinHealthyPercentage`, and the difference between them cannot be greater than 100. A larger range increases the number of instances that can be replaced at the same time.
         *
         * If you do not specify this property, the default is 100 percent, or the percentage set in the instance maintenance policy for the Auto Scaling group, if defined.
         */
        public var maxHealthyPercentage: kotlin.Int? = null
        /**
         * Specifies the minimum percentage of the group to keep in service, healthy, and ready to use to support your workload to allow the operation to continue. The value is expressed as a percentage of the desired capacity of the Auto Scaling group. Value range is 0 to 100.
         *
         * If you do not specify this property, the default is 90 percent, or the percentage set in the instance maintenance policy for the Auto Scaling group, if defined.
         */
        public var minHealthyPercentage: kotlin.Int? = null
        /**
         * Choose the behavior that you want Amazon EC2 Auto Scaling to use if instances protected from scale in are found.
         *
         * The following lists the valid values:
         *
         * ## Refresh
         * Amazon EC2 Auto Scaling replaces instances that are protected from scale in.
         *
         * ## Ignore
         * Amazon EC2 Auto Scaling ignores instances that are protected from scale in and continues to replace instances that are not protected.
         *
         * ## Wait (default)
         * Amazon EC2 Auto Scaling waits one hour for you to remove scale-in protection. Otherwise, the instance refresh will fail.
         */
        public var scaleInProtectedInstances: aws.sdk.kotlin.services.autoscaling.model.ScaleInProtectedInstances? = null
        /**
         * (Optional) Indicates whether skip matching is enabled. If enabled (`true`), then Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired configuration is specified, then it skips replacing instances that have the same launch template and instance types that the Auto Scaling group was using before the start of the instance refresh. The default is `false`.
         *
         * For more information, see [Use an instance refresh with skip matching](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh-skip-matching.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var skipMatching: kotlin.Boolean? = null
        /**
         * Choose the behavior that you want Amazon EC2 Auto Scaling to use if instances in `Standby` state are found.
         *
         * The following lists the valid values:
         *
         * ## Terminate
         * Amazon EC2 Auto Scaling terminates instances that are in `Standby`.
         *
         * ## Ignore
         * Amazon EC2 Auto Scaling ignores instances that are in `Standby` and continues to replace instances that are in the `InService` state.
         *
         * ## Wait (default)
         * Amazon EC2 Auto Scaling waits one hour for you to return the instances to service. Otherwise, the instance refresh will fail.
         */
        public var standbyInstances: aws.sdk.kotlin.services.autoscaling.model.StandbyInstances? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences) : this() {
            this.alarmSpecification = x.alarmSpecification
            this.autoRollback = x.autoRollback
            this.checkpointDelay = x.checkpointDelay
            this.checkpointPercentages = x.checkpointPercentages
            this.instanceWarmup = x.instanceWarmup
            this.maxHealthyPercentage = x.maxHealthyPercentage
            this.minHealthyPercentage = x.minHealthyPercentage
            this.scaleInProtectedInstances = x.scaleInProtectedInstances
            this.skipMatching = x.skipMatching
            this.standbyInstances = x.standbyInstances
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences = RefreshPreferences(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.AlarmSpecification] inside the given [block]
         */
        public fun alarmSpecification(block: aws.sdk.kotlin.services.autoscaling.model.AlarmSpecification.Builder.() -> kotlin.Unit) {
            this.alarmSpecification = aws.sdk.kotlin.services.autoscaling.model.AlarmSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
