// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * This structure specifies the metrics and target utilization settings for a predictive scaling policy.
 *
 * You must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the scaling metric.
 *
 * Example
 * + You create a predictive scaling policy and specify `ALBRequestCount` as the value for the metric pair and `1000.0` as the target value. For this type of metric, you must provide the metric dimension for the corresponding target group, so you also provide a resource label for the Application Load Balancer target group that is attached to your Auto Scaling group.
 * + The number of requests the target group receives per minute provides the load metric, and the request count averaged between the members of the target group provides the scaling metric. In CloudWatch, this refers to the `RequestCount` and `RequestCountPerTarget` metrics, respectively.
 * + For optimal use of predictive scaling, you adhere to the best practice of using a dynamic scaling policy to automatically scale between the minimum capacity and maximum capacity in response to real-time changes in resource utilization.
 * + Amazon EC2 Auto Scaling consumes data points for the load metric over the last 14 days and creates an hourly load forecast for predictive scaling. (A minimum of 24 hours of data is required.)
 * + After creating the load forecast, Amazon EC2 Auto Scaling determines when to reduce or increase the capacity of your Auto Scaling group in each hour of the forecast period so that the average number of requests received by each instance is as close to 1000 requests per minute as possible at all times.
 *
 * For information about using custom metrics with predictive scaling, see [Advanced predictive scaling policy configurations using custom metrics](https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public class PredictiveScalingMetricSpecification private constructor(builder: Builder) {
    /**
     * The customized capacity metric specification.
     */
    public val customizedCapacityMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedCapacityMetric? = builder.customizedCapacityMetricSpecification
    /**
     * The customized load metric specification.
     */
    public val customizedLoadMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedLoadMetric? = builder.customizedLoadMetricSpecification
    /**
     * The customized scaling metric specification.
     */
    public val customizedScalingMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedScalingMetric? = builder.customizedScalingMetricSpecification
    /**
     * The predefined load metric specification.
     */
    public val predefinedLoadMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedLoadMetric? = builder.predefinedLoadMetricSpecification
    /**
     * The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
     */
    public val predefinedMetricPairSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair? = builder.predefinedMetricPairSpecification
    /**
     * The predefined scaling metric specification.
     */
    public val predefinedScalingMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedScalingMetric? = builder.predefinedScalingMetricSpecification
    /**
     * Specifies the target utilization.
     *
     * Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
     */
    public val targetValue: kotlin.Double? = builder.targetValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMetricSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredictiveScalingMetricSpecification(")
        append("customizedCapacityMetricSpecification=$customizedCapacityMetricSpecification,")
        append("customizedLoadMetricSpecification=$customizedLoadMetricSpecification,")
        append("customizedScalingMetricSpecification=$customizedScalingMetricSpecification,")
        append("predefinedLoadMetricSpecification=$predefinedLoadMetricSpecification,")
        append("predefinedMetricPairSpecification=$predefinedMetricPairSpecification,")
        append("predefinedScalingMetricSpecification=$predefinedScalingMetricSpecification,")
        append("targetValue=$targetValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedCapacityMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (customizedLoadMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (customizedScalingMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (predefinedLoadMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (predefinedMetricPairSpecification?.hashCode() ?: 0)
        result = 31 * result + (predefinedScalingMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (targetValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredictiveScalingMetricSpecification

        if (customizedCapacityMetricSpecification != other.customizedCapacityMetricSpecification) return false
        if (customizedLoadMetricSpecification != other.customizedLoadMetricSpecification) return false
        if (customizedScalingMetricSpecification != other.customizedScalingMetricSpecification) return false
        if (predefinedLoadMetricSpecification != other.predefinedLoadMetricSpecification) return false
        if (predefinedMetricPairSpecification != other.predefinedMetricPairSpecification) return false
        if (predefinedScalingMetricSpecification != other.predefinedScalingMetricSpecification) return false
        if (targetValue != other.targetValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMetricSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The customized capacity metric specification.
         */
        public var customizedCapacityMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedCapacityMetric? = null
        /**
         * The customized load metric specification.
         */
        public var customizedLoadMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedLoadMetric? = null
        /**
         * The customized scaling metric specification.
         */
        public var customizedScalingMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedScalingMetric? = null
        /**
         * The predefined load metric specification.
         */
        public var predefinedLoadMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedLoadMetric? = null
        /**
         * The predefined metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
         */
        public var predefinedMetricPairSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair? = null
        /**
         * The predefined scaling metric specification.
         */
        public var predefinedScalingMetricSpecification: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedScalingMetric? = null
        /**
         * Specifies the target utilization.
         *
         * Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
         */
        public var targetValue: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMetricSpecification) : this() {
            this.customizedCapacityMetricSpecification = x.customizedCapacityMetricSpecification
            this.customizedLoadMetricSpecification = x.customizedLoadMetricSpecification
            this.customizedScalingMetricSpecification = x.customizedScalingMetricSpecification
            this.predefinedLoadMetricSpecification = x.predefinedLoadMetricSpecification
            this.predefinedMetricPairSpecification = x.predefinedMetricPairSpecification
            this.predefinedScalingMetricSpecification = x.predefinedScalingMetricSpecification
            this.targetValue = x.targetValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMetricSpecification = PredictiveScalingMetricSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedCapacityMetric] inside the given [block]
         */
        public fun customizedCapacityMetricSpecification(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedCapacityMetric.Builder.() -> kotlin.Unit) {
            this.customizedCapacityMetricSpecification = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedCapacityMetric.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedLoadMetric] inside the given [block]
         */
        public fun customizedLoadMetricSpecification(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedLoadMetric.Builder.() -> kotlin.Unit) {
            this.customizedLoadMetricSpecification = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedLoadMetric.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedScalingMetric] inside the given [block]
         */
        public fun customizedScalingMetricSpecification(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedScalingMetric.Builder.() -> kotlin.Unit) {
            this.customizedScalingMetricSpecification = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingCustomizedScalingMetric.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedLoadMetric] inside the given [block]
         */
        public fun predefinedLoadMetricSpecification(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedLoadMetric.Builder.() -> kotlin.Unit) {
            this.predefinedLoadMetricSpecification = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedLoadMetric.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair] inside the given [block]
         */
        public fun predefinedMetricPairSpecification(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair.Builder.() -> kotlin.Unit) {
            this.predefinedMetricPairSpecification = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedScalingMetric] inside the given [block]
         */
        public fun predefinedScalingMetricSpecification(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedScalingMetric.Builder.() -> kotlin.Unit) {
            this.predefinedScalingMetricSpecification = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedScalingMetric.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
