// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes the state of a target group.
 */
public class LoadBalancerTargetGroupState private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the target group.
     */
    public val loadBalancerTargetGroupArn: kotlin.String? = builder.loadBalancerTargetGroupArn
    /**
     * The state of the target group.
     * + `Adding` - The Auto Scaling instances are being registered with the target group.
     * + `Added` - All Auto Scaling instances are registered with the target group.
     * + `InService` - At least one Auto Scaling instance passed an `ELB` health check.
     * + `Removing` - The Auto Scaling instances are being deregistered from the target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.
     * + `Removed` - All Auto Scaling instances are deregistered from the target group.
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.LoadBalancerTargetGroupState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerTargetGroupState(")
        append("loadBalancerTargetGroupArn=$loadBalancerTargetGroupArn,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = loadBalancerTargetGroupArn?.hashCode() ?: 0
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerTargetGroupState

        if (loadBalancerTargetGroupArn != other.loadBalancerTargetGroupArn) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.LoadBalancerTargetGroupState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the target group.
         */
        public var loadBalancerTargetGroupArn: kotlin.String? = null
        /**
         * The state of the target group.
         * + `Adding` - The Auto Scaling instances are being registered with the target group.
         * + `Added` - All Auto Scaling instances are registered with the target group.
         * + `InService` - At least one Auto Scaling instance passed an `ELB` health check.
         * + `Removing` - The Auto Scaling instances are being deregistered from the target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.
         * + `Removed` - All Auto Scaling instances are deregistered from the target group.
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.LoadBalancerTargetGroupState) : this() {
            this.loadBalancerTargetGroupArn = x.loadBalancerTargetGroupArn
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.LoadBalancerTargetGroupState = LoadBalancerTargetGroupState(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
