// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a launch configuration.
 */
public class LaunchConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether to assign a public IPv4 address to the group's instances. If the instance is launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet. For more information, see [Launching Auto Scaling instances in a VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * The block device mapping entries that define the block devices to attach to the instances at launch. By default, the block devices specified in the block device mapping for the AMI are used. For more information, see [Block Device Mapping](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Available for backward compatibility.
     */
    public val classicLinkVpcId: kotlin.String? = builder.classicLinkVpcId
    /**
     * Available for backward compatibility.
     */
    public val classicLinkVpcSecurityGroups: List<String>? = builder.classicLinkVpcSecurityGroups
    /**
     * The creation date and time for the launch configuration.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * Specifies whether the launch configuration is optimized for EBS I/O (`true`) or not (`false`). For more information, see [Amazon EBS-Optimized Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role. For more information, see [IAM role for applications that run on Amazon EC2 instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val iamInstanceProfile: kotlin.String? = builder.iamInstanceProfile
    /**
     * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more information, see [Find a Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * Controls whether instances in this group are launched with detailed (`true`) or basic (`false`) monitoring.
     *
     * For more information, see [Configure Monitoring for Auto Scaling Instances](https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val instanceMonitoring: aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring? = builder.instanceMonitoring
    /**
     * The instance type for the instances. For information about available instance types, see [Available instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The ID of the kernel associated with the AMI.
     */
    public val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair.
     *
     * For more information, see [Amazon EC2 Key Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The Amazon Resource Name (ARN) of the launch configuration.
     */
    public val launchConfigurationArn: kotlin.String? = builder.launchConfigurationArn
    /**
     * The name of the launch configuration.
     */
    public val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The metadata options for the instances. For more information, see [Configuring the Instance Metadata Options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val metadataOptions: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions? = builder.metadataOptions
    /**
     * The tenancy of the instance, either `default` or `dedicated`. An instance with `dedicated` tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.
     *
     * For more information, see [Configuring instance tenancy with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val placementTenancy: kotlin.String? = builder.placementTenancy
    /**
     * The ID of the RAM disk associated with the AMI.
     */
    public val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * A list that contains the security groups to assign to the instances in the Auto Scaling group. For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide*.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see [Requesting Spot Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val spotPrice: kotlin.String? = builder.spotPrice
    /**
     * The user data to make available to the launched EC2 instances. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) (Linux) and [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html) (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.LaunchConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchConfiguration(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("classicLinkVpcId=$classicLinkVpcId,")
        append("classicLinkVpcSecurityGroups=$classicLinkVpcSecurityGroups,")
        append("createdTime=$createdTime,")
        append("ebsOptimized=$ebsOptimized,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceMonitoring=$instanceMonitoring,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("launchConfigurationArn=$launchConfigurationArn,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("metadataOptions=$metadataOptions,")
        append("placementTenancy=$placementTenancy,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroups=$securityGroups,")
        append("spotPrice=$spotPrice,")
        append("userData=$userData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (classicLinkVpcId?.hashCode() ?: 0)
        result = 31 * result + (classicLinkVpcSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceMonitoring?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (placementTenancy?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchConfiguration

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (classicLinkVpcId != other.classicLinkVpcId) return false
        if (classicLinkVpcSecurityGroups != other.classicLinkVpcSecurityGroups) return false
        if (createdTime != other.createdTime) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceMonitoring != other.instanceMonitoring) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (launchConfigurationArn != other.launchConfigurationArn) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (metadataOptions != other.metadataOptions) return false
        if (placementTenancy != other.placementTenancy) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroups != other.securityGroups) return false
        if (spotPrice != other.spotPrice) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.LaunchConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to assign a public IPv4 address to the group's instances. If the instance is launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet. For more information, see [Launching Auto Scaling instances in a VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * The block device mapping entries that define the block devices to attach to the instances at launch. By default, the block devices specified in the block device mapping for the AMI are used. For more information, see [Block Device Mapping](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var blockDeviceMappings: List<BlockDeviceMapping>? = null
        /**
         * Available for backward compatibility.
         */
        public var classicLinkVpcId: kotlin.String? = null
        /**
         * Available for backward compatibility.
         */
        public var classicLinkVpcSecurityGroups: List<String>? = null
        /**
         * The creation date and time for the launch configuration.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the launch configuration is optimized for EBS I/O (`true`) or not (`false`). For more information, see [Amazon EBS-Optimized Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role. For more information, see [IAM role for applications that run on Amazon EC2 instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var iamInstanceProfile: kotlin.String? = null
        /**
         * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more information, see [Find a Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var imageId: kotlin.String? = null
        /**
         * Controls whether instances in this group are launched with detailed (`true`) or basic (`false`) monitoring.
         *
         * For more information, see [Configure Monitoring for Auto Scaling Instances](https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var instanceMonitoring: aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring? = null
        /**
         * The instance type for the instances. For information about available instance types, see [Available instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The ID of the kernel associated with the AMI.
         */
        public var kernelId: kotlin.String? = null
        /**
         * The name of the key pair.
         *
         * For more information, see [Amazon EC2 Key Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var keyName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the launch configuration.
         */
        public var launchConfigurationArn: kotlin.String? = null
        /**
         * The name of the launch configuration.
         */
        public var launchConfigurationName: kotlin.String? = null
        /**
         * The metadata options for the instances. For more information, see [Configuring the Instance Metadata Options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var metadataOptions: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions? = null
        /**
         * The tenancy of the instance, either `default` or `dedicated`. An instance with `dedicated` tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.
         *
         * For more information, see [Configuring instance tenancy with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var placementTenancy: kotlin.String? = null
        /**
         * The ID of the RAM disk associated with the AMI.
         */
        public var ramdiskId: kotlin.String? = null
        /**
         * A list that contains the security groups to assign to the instances in the Auto Scaling group. For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide*.
         */
        public var securityGroups: List<String>? = null
        /**
         * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see [Requesting Spot Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var spotPrice: kotlin.String? = null
        /**
         * The user data to make available to the launched EC2 instances. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) (Linux) and [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html) (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.LaunchConfiguration) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.blockDeviceMappings = x.blockDeviceMappings
            this.classicLinkVpcId = x.classicLinkVpcId
            this.classicLinkVpcSecurityGroups = x.classicLinkVpcSecurityGroups
            this.createdTime = x.createdTime
            this.ebsOptimized = x.ebsOptimized
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceMonitoring = x.instanceMonitoring
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.launchConfigurationArn = x.launchConfigurationArn
            this.launchConfigurationName = x.launchConfigurationName
            this.metadataOptions = x.metadataOptions
            this.placementTenancy = x.placementTenancy
            this.ramdiskId = x.ramdiskId
            this.securityGroups = x.securityGroups
            this.spotPrice = x.spotPrice
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.LaunchConfiguration = LaunchConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring] inside the given [block]
         */
        public fun instanceMonitoring(block: aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring.Builder.() -> kotlin.Unit) {
            this.instanceMonitoring = aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions] inside the given [block]
         */
        public fun metadataOptions(block: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
