// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes an EC2 instance.
 */
public class Instance private constructor(builder: Builder) {
    /**
     * The Availability Zone in which the instance is running.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The last reported health status of the instance. `Healthy` means that the instance is healthy and should remain in service. `Unhealthy` means that the instance is unhealthy and that Amazon EC2 Auto Scaling should terminate and replace it.
     */
    public val healthStatus: kotlin.String? = builder.healthStatus
    /**
     * The ID of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The instance type of the EC2 instance.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The launch configuration associated with the instance.
     */
    public val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The launch template for the instance.
     */
    public val launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * A description of the current lifecycle state. The `Quarantined` state is not used. For information about lifecycle states, see [Instance lifecycle](https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val lifecycleState: aws.sdk.kotlin.services.autoscaling.model.LifecycleState? = builder.lifecycleState
    /**
     * Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.
     */
    public val protectedFromScaleIn: kotlin.Boolean? = builder.protectedFromScaleIn
    /**
     * The number of capacity units contributed by the instance based on its instance type.
     *
     * Valid Range: Minimum value of 1. Maximum value of 999.
     */
    public val weightedCapacity: kotlin.String? = builder.weightedCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("availabilityZone=$availabilityZone,")
        append("healthStatus=$healthStatus,")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("launchTemplate=$launchTemplate,")
        append("lifecycleState=$lifecycleState,")
        append("protectedFromScaleIn=$protectedFromScaleIn,")
        append("weightedCapacity=$weightedCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (lifecycleState?.hashCode() ?: 0)
        result = 31 * result + (protectedFromScaleIn?.hashCode() ?: 0)
        result = 31 * result + (weightedCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (availabilityZone != other.availabilityZone) return false
        if (healthStatus != other.healthStatus) return false
        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (launchTemplate != other.launchTemplate) return false
        if (lifecycleState != other.lifecycleState) return false
        if (protectedFromScaleIn != other.protectedFromScaleIn) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.Instance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone in which the instance is running.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The last reported health status of the instance. `Healthy` means that the instance is healthy and should remain in service. `Unhealthy` means that the instance is unhealthy and that Amazon EC2 Auto Scaling should terminate and replace it.
         */
        public var healthStatus: kotlin.String? = null
        /**
         * The ID of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The instance type of the EC2 instance.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The launch configuration associated with the instance.
         */
        public var launchConfigurationName: kotlin.String? = null
        /**
         * The launch template for the instance.
         */
        public var launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = null
        /**
         * A description of the current lifecycle state. The `Quarantined` state is not used. For information about lifecycle states, see [Instance lifecycle](https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var lifecycleState: aws.sdk.kotlin.services.autoscaling.model.LifecycleState? = null
        /**
         * Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.
         */
        public var protectedFromScaleIn: kotlin.Boolean? = null
        /**
         * The number of capacity units contributed by the instance based on its instance type.
         *
         * Valid Range: Minimum value of 1. Maximum value of 999.
         */
        public var weightedCapacity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.Instance) : this() {
            this.availabilityZone = x.availabilityZone
            this.healthStatus = x.healthStatus
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.launchConfigurationName = x.launchConfigurationName
            this.launchTemplate = x.launchTemplate
            this.lifecycleState = x.lifecycleState
            this.protectedFromScaleIn = x.protectedFromScaleIn
            this.weightedCapacity = x.weightedCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.Instance = Instance(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
