// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes a filter that is used to return a more specific list of results from a describe operation.
 *
 * If you specify multiple filters, the filters are automatically logically joined with an `AND`, and the request returns only the results that match all of the specified filters.
 *
 * For more information, see [Tag Auto Scaling groups and instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public class Filter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     *
     * The valid values for `Name` depend on which API operation you're using with the filter (DescribeAutoScalingGroups or DescribeTags).
     *
     * **DescribeAutoScalingGroups**
     *
     * Valid values for `Name` include the following:
     * + `tag-key` - Accepts tag keys. The results only include information about the Auto Scaling groups associated with these tag keys.
     * + `tag-value` - Accepts tag values. The results only include information about the Auto Scaling groups associated with these tag values.
     * + `tag:<key>` - Accepts the key/value combination of the tag. Use the tag key in the filter name and the tag value as the filter value. The results only include information about the Auto Scaling groups associated with the specified key/value combination.
     *
     * **DescribeTags**
     *
     * Valid values for `Name` include the following:
     * + `auto-scaling-group` - Accepts the names of Auto Scaling groups. The results only include information about the tags associated with these Auto Scaling groups.
     * + `key` - Accepts tag keys. The results only include information about the tags associated with these tag keys.
     * + `value` - Accepts tag values. The results only include information about the tags associated with these tag values.
     * + `propagate-at-launch` - Accepts a Boolean value, which specifies whether tags propagate to instances at launch. The results only include information about the tags associated with the specified Boolean value.
     */
    public val name: kotlin.String? = builder.name
    /**
     * One or more filter values. Filter values are case-sensitive.
     *
     * If you specify multiple values for a filter, the values are automatically logically joined with an `OR`, and the request returns all results that match any of the specified values. For example, specify "tag:environment" for the filter name and "production,development" for the filter values to find Auto Scaling groups with the tag "environment=production" or "environment=development".
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("name=$name,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.Filter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the filter.
         *
         * The valid values for `Name` depend on which API operation you're using with the filter (DescribeAutoScalingGroups or DescribeTags).
         *
         * **DescribeAutoScalingGroups**
         *
         * Valid values for `Name` include the following:
         * + `tag-key` - Accepts tag keys. The results only include information about the Auto Scaling groups associated with these tag keys.
         * + `tag-value` - Accepts tag values. The results only include information about the Auto Scaling groups associated with these tag values.
         * + `tag:<key>` - Accepts the key/value combination of the tag. Use the tag key in the filter name and the tag value as the filter value. The results only include information about the Auto Scaling groups associated with the specified key/value combination.
         *
         * **DescribeTags**
         *
         * Valid values for `Name` include the following:
         * + `auto-scaling-group` - Accepts the names of Auto Scaling groups. The results only include information about the tags associated with these Auto Scaling groups.
         * + `key` - Accepts tag keys. The results only include information about the tags associated with these tag keys.
         * + `value` - Accepts tag values. The results only include information about the tags associated with these tag values.
         * + `propagate-at-launch` - Accepts a Boolean value, which specifies whether tags propagate to instances at launch. The results only include information about the tags associated with the specified Boolean value.
         */
        public var name: kotlin.String? = null
        /**
         * One or more filter values. Filter values are case-sensitive.
         *
         * If you specify multiple values for a filter, the values are automatically logically joined with an `OR`, and the request returns all results that match any of the specified values. For example, specify "tag:environment" for the filter name and "production,development" for the filter values to find Auto Scaling groups with the tag "environment=production" or "environment=development".
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.Filter) : this() {
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.Filter = Filter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
