// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



public class CreateLaunchConfigurationRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to assign a public IPv4 address to the group's instances. If the instance is launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet.
     *
     * If you specify `true`, each instance in the Auto Scaling group receives a unique public IPv4 address. For more information, see [Launching Auto Scaling instances in a VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * If you specify this property, you must specify at least one subnet for `VPCZoneIdentifier` when you create your group.
     */
    public val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * The block device mapping entries that define the block devices to attach to the instances at launch. By default, the block devices specified in the block device mapping for the AMI are used. For more information, see [Block device mappings](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Available for backward compatibility.
     */
    public val classicLinkVpcId: kotlin.String? = builder.classicLinkVpcId
    /**
     * Available for backward compatibility.
     */
    public val classicLinkVpcSecurityGroups: List<String>? = builder.classicLinkVpcSecurityGroups
    /**
     * Specifies whether the launch configuration is optimized for EBS I/O (`true`) or not (`false`). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see [Amazon EBS-optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * The default value is `false`.
     */
    public val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role. For more information, see [IAM role for applications that run on Amazon EC2 instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val iamInstanceProfile: kotlin.String? = builder.iamInstanceProfile
    /**
     * The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see [Finding a Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * If you specify `InstanceId`, an `ImageId` is not required.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping.
     *
     * To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.
     *
     * For more information, see [Creating a launch configuration using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Controls whether instances in this group are launched with detailed (`true`) or basic (`false`) monitoring.
     *
     * The default value is `true` (enabled).
     *
     * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see [Configure Monitoring for Auto Scaling Instances](https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val instanceMonitoring: aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring? = builder.instanceMonitoring
    /**
     * Specifies the instance type of the EC2 instance. For information about available instance types, see [Available instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * If you specify `InstanceId`, an `InstanceType` is not required.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The ID of the kernel associated with the AMI.
     *
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The name of the launch configuration. This name must be unique per Region per account.
     */
    public val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The metadata options for the instances. For more information, see [Configuring the Instance Metadata Options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val metadataOptions: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions? = builder.metadataOptions
    /**
     * The tenancy of the instance, either `default` or `dedicated`. An instance with `dedicated` tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC. To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to `default`), you must set the value of this property to `dedicated`. For more information, see [Configuring instance tenancy with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * If you specify `PlacementTenancy`, you must specify at least one subnet for `VPCZoneIdentifier` when you create your group.
     *
     * Valid values: `default` | `dedicated`
     */
    public val placementTenancy: kotlin.String? = builder.placementTenancy
    /**
     * The ID of the RAM disk to select.
     *
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    public val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For more information, see [Control traffic to resources using security groups](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide*.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see [Request Spot Instances for fault-tolerant and flexible applications](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Valid Range: Minimum value of 0.001
     *
     * When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.
     */
    public val spotPrice: kotlin.String? = builder.spotPrice
    /**
     * The user data to make available to the launched EC2 instances. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) (Linux) and [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html) (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.CreateLaunchConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLaunchConfigurationRequest(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("classicLinkVpcId=$classicLinkVpcId,")
        append("classicLinkVpcSecurityGroups=$classicLinkVpcSecurityGroups,")
        append("ebsOptimized=$ebsOptimized,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceId=$instanceId,")
        append("instanceMonitoring=$instanceMonitoring,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("metadataOptions=$metadataOptions,")
        append("placementTenancy=$placementTenancy,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroups=$securityGroups,")
        append("spotPrice=$spotPrice,")
        append("userData=$userData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (classicLinkVpcId?.hashCode() ?: 0)
        result = 31 * result + (classicLinkVpcSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceMonitoring?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (placementTenancy?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLaunchConfigurationRequest

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (classicLinkVpcId != other.classicLinkVpcId) return false
        if (classicLinkVpcSecurityGroups != other.classicLinkVpcSecurityGroups) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceId != other.instanceId) return false
        if (instanceMonitoring != other.instanceMonitoring) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (metadataOptions != other.metadataOptions) return false
        if (placementTenancy != other.placementTenancy) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroups != other.securityGroups) return false
        if (spotPrice != other.spotPrice) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.CreateLaunchConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to assign a public IPv4 address to the group's instances. If the instance is launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet.
         *
         * If you specify `true`, each instance in the Auto Scaling group receives a unique public IPv4 address. For more information, see [Launching Auto Scaling instances in a VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * If you specify this property, you must specify at least one subnet for `VPCZoneIdentifier` when you create your group.
         */
        public var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * The block device mapping entries that define the block devices to attach to the instances at launch. By default, the block devices specified in the block device mapping for the AMI are used. For more information, see [Block device mappings](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var blockDeviceMappings: List<BlockDeviceMapping>? = null
        /**
         * Available for backward compatibility.
         */
        public var classicLinkVpcId: kotlin.String? = null
        /**
         * Available for backward compatibility.
         */
        public var classicLinkVpcSecurityGroups: List<String>? = null
        /**
         * Specifies whether the launch configuration is optimized for EBS I/O (`true`) or not (`false`). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see [Amazon EBS-optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * The default value is `false`.
         */
        public var ebsOptimized: kotlin.Boolean? = null
        /**
         * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role. For more information, see [IAM role for applications that run on Amazon EC2 instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var iamInstanceProfile: kotlin.String? = null
        /**
         * The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see [Finding a Linux AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * If you specify `InstanceId`, an `ImageId` is not required.
         */
        public var imageId: kotlin.String? = null
        /**
         * The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping.
         *
         * To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.
         *
         * For more information, see [Creating a launch configuration using an EC2 instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Controls whether instances in this group are launched with detailed (`true`) or basic (`false`) monitoring.
         *
         * The default value is `true` (enabled).
         *
         * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see [Configure Monitoring for Auto Scaling Instances](https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var instanceMonitoring: aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring? = null
        /**
         * Specifies the instance type of the EC2 instance. For information about available instance types, see [Available instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * If you specify `InstanceId`, an `InstanceType` is not required.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The ID of the kernel associated with the AMI.
         *
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var kernelId: kotlin.String? = null
        /**
         * The name of the key pair. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var keyName: kotlin.String? = null
        /**
         * The name of the launch configuration. This name must be unique per Region per account.
         */
        public var launchConfigurationName: kotlin.String? = null
        /**
         * The metadata options for the instances. For more information, see [Configuring the Instance Metadata Options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var metadataOptions: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions? = null
        /**
         * The tenancy of the instance, either `default` or `dedicated`. An instance with `dedicated` tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC. To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to `default`), you must set the value of this property to `dedicated`. For more information, see [Configuring instance tenancy with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * If you specify `PlacementTenancy`, you must specify at least one subnet for `VPCZoneIdentifier` when you create your group.
         *
         * Valid values: `default` | `dedicated`
         */
        public var placementTenancy: kotlin.String? = null
        /**
         * The ID of the RAM disk to select.
         *
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [User provided kernels](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        public var ramdiskId: kotlin.String? = null
        /**
         * A list that contains the security group IDs to assign to the instances in the Auto Scaling group. For more information, see [Control traffic to resources using security groups](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide*.
         */
        public var securityGroups: List<String>? = null
        /**
         * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see [Request Spot Instances for fault-tolerant and flexible applications](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Valid Range: Minimum value of 0.001
         *
         * When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.
         */
        public var spotPrice: kotlin.String? = null
        /**
         * The user data to make available to the launched EC2 instances. For more information, see [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) (Linux) and [Instance metadata and user data](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html) (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.CreateLaunchConfigurationRequest) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.blockDeviceMappings = x.blockDeviceMappings
            this.classicLinkVpcId = x.classicLinkVpcId
            this.classicLinkVpcSecurityGroups = x.classicLinkVpcSecurityGroups
            this.ebsOptimized = x.ebsOptimized
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceId = x.instanceId
            this.instanceMonitoring = x.instanceMonitoring
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.launchConfigurationName = x.launchConfigurationName
            this.metadataOptions = x.metadataOptions
            this.placementTenancy = x.placementTenancy
            this.ramdiskId = x.ramdiskId
            this.securityGroups = x.securityGroups
            this.spotPrice = x.spotPrice
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.CreateLaunchConfigurationRequest = CreateLaunchConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring] inside the given [block]
         */
        public fun instanceMonitoring(block: aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring.Builder.() -> kotlin.Unit) {
            this.instanceMonitoring = aws.sdk.kotlin.services.autoscaling.model.InstanceMonitoring.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions] inside the given [block]
         */
        public fun metadataOptions(block: aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.autoscaling.model.InstanceMetadataOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
