// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.waiters

import aws.sdk.kotlin.services.autoscaling.AutoScalingClient
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import aws.smithy.kotlin.runtime.util.length
import kotlin.time.Duration.Companion.milliseconds


public suspend fun AutoScalingClient.waitUntilGroupExists(request: DescribeAutoScalingGroupsRequest): Outcome<DescribeAutoScalingGroupsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val autoScalingGroups = it?.autoScalingGroups
            val length = autoScalingGroups?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val autoScalingGroups = it?.autoScalingGroups
            val length = autoScalingGroups?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAutoScalingGroups(request) }
}

public suspend fun AutoScalingClient.waitUntilGroupExists(block: DescribeAutoScalingGroupsRequest.Builder.() -> Unit): Outcome<DescribeAutoScalingGroupsResponse> =
    waitUntilGroupExists(DescribeAutoScalingGroupsRequest.Builder().apply(block).build())

public suspend fun AutoScalingClient.waitUntilGroupInService(request: DescribeAutoScalingGroupsRequest): Outcome<DescribeAutoScalingGroupsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val autoScalingGroups = it?.autoScalingGroups
            val autoScalingGroupsOrEmpty = autoScalingGroups?.flattenIfPossible() ?: listOf()
            val projection = autoScalingGroupsOrEmpty.flatMap {
                val multiSelect = listOfNotNull(
                    run {
                        val instances = it?.instances
                        val instancesFiltered = (instances ?: listOf()).filter {
                            val lifecycleState = it?.lifecycleState
                            val string = "InService"
                            val comparison = if (lifecycleState == null || string == null) null else lifecycleState.toString().compareTo(string) == 0
                            comparison == true
                        }
                        val length = instancesFiltered?.length ?: 0
                        val minSize = it?.minSize
                        val comparison = if (length == null || minSize == null) null else length.compareTo(minSize) >= 0
                        comparison
                    },
                )
                multiSelect
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val bool = false
            val contains = projectionOrEmpty?.contains(bool) ?: false
            contains == false
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val autoScalingGroups = it?.autoScalingGroups
            val autoScalingGroupsOrEmpty = autoScalingGroups?.flattenIfPossible() ?: listOf()
            val projection = autoScalingGroupsOrEmpty.flatMap {
                val multiSelect = listOfNotNull(
                    run {
                        val instances = it?.instances
                        val instancesFiltered = (instances ?: listOf()).filter {
                            val lifecycleState = it?.lifecycleState
                            val string = "InService"
                            val comparison = if (lifecycleState == null || string == null) null else lifecycleState.toString().compareTo(string) == 0
                            comparison == true
                        }
                        val length = instancesFiltered?.length ?: 0
                        val minSize = it?.minSize
                        val comparison = if (length == null || minSize == null) null else length.compareTo(minSize) >= 0
                        comparison
                    },
                )
                multiSelect
            }
            val projectionOrEmpty = projection?.flattenIfPossible() ?: listOf()
            val bool = false
            val contains = projectionOrEmpty?.contains(bool) ?: false
            contains == true
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAutoScalingGroups(request) }
}

public suspend fun AutoScalingClient.waitUntilGroupInService(block: DescribeAutoScalingGroupsRequest.Builder.() -> Unit): Outcome<DescribeAutoScalingGroupsResponse> =
    waitUntilGroupInService(DescribeAutoScalingGroupsRequest.Builder().apply(block).build())

public suspend fun AutoScalingClient.waitUntilGroupNotExists(request: DescribeAutoScalingGroupsRequest): Outcome<DescribeAutoScalingGroupsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val autoScalingGroups = it?.autoScalingGroups
            val length = autoScalingGroups?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == false
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val autoScalingGroups = it?.autoScalingGroups
            val length = autoScalingGroups?.length ?: 0
            val number = 0.0
            val comparison = if (length == null || number == null) null else length.compareTo(number) > 0
            comparison == true
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAutoScalingGroups(request) }
}

public suspend fun AutoScalingClient.waitUntilGroupNotExists(block: DescribeAutoScalingGroupsRequest.Builder.() -> Unit): Outcome<DescribeAutoScalingGroupsResponse> =
    waitUntilGroupNotExists(DescribeAutoScalingGroupsRequest.Builder().apply(block).build())
