// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.autoscaling.model.Activity
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class TerminateInstanceInAutoScalingGroupOperationDeserializer: HttpDeserialize<TerminateInstanceInAutoScalingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TerminateInstanceInAutoScalingGroupResponse {
        if (!response.status.isSuccess()) {
            throwTerminateInstanceInAutoScalingGroupError(context, response)
        }
        val builder = TerminateInstanceInAutoScalingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTerminateInstanceInAutoScalingGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwTerminateInstanceInAutoScalingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedResponse)
        "ScalingActivityInProgress" -> ScalingActivityInProgressFaultDeserializer().deserialize(context, wrappedResponse)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTerminateInstanceInAutoScalingGroupOperationBody(builder: TerminateInstanceInAutoScalingGroupResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("TerminateInstanceInAutoScalingGroupResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("TerminateInstanceInAutoScalingGroupResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap TerminateInstanceInAutoScalingGroup response")
    }
    // end unwrap response wrapper

    val ACTIVITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Activity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://autoscaling.amazonaws.com/doc/2011-01-01/"))
        trait(XmlSerialName("TerminateInstanceInAutoScalingGroupResult"))
        field(ACTIVITY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVITY_DESCRIPTOR.index -> builder.activity = deserializeActivityDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
