// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.transform

import aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration
import aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences
import aws.sdk.kotlin.services.autoscaling.model.RefreshStrategy
import aws.sdk.kotlin.services.autoscaling.model.StartInstanceRefreshRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartInstanceRefreshOperationSerializer: HttpSerialize<StartInstanceRefreshRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartInstanceRefreshRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeStartInstanceRefreshOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeStartInstanceRefreshOperationBody(context: ExecutionContext, input: StartInstanceRefreshRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AUTOSCALINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AutoScalingGroupName"))
    val DESIREDCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("DesiredConfiguration"))
    val PREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("Preferences"))
    val STRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("Strategy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("StartInstanceRefreshType"))
        trait(QueryLiteral("Action", "StartInstanceRefresh"))
        trait(QueryLiteral("Version", "2011-01-01"))
        field(AUTOSCALINGGROUPNAME_DESCRIPTOR)
        field(DESIREDCONFIGURATION_DESCRIPTOR)
        field(PREFERENCES_DESCRIPTOR)
        field(STRATEGY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.autoScalingGroupName?.let { field(AUTOSCALINGGROUPNAME_DESCRIPTOR, it) }
        input.desiredConfiguration?.let { field(DESIREDCONFIGURATION_DESCRIPTOR, it, ::serializeDesiredConfigurationDocument) }
        input.preferences?.let { field(PREFERENCES_DESCRIPTOR, it, ::serializeRefreshPreferencesDocument) }
        input.strategy?.let { field(STRATEGY_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
