// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.transform

import aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration
import aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyRequest
import aws.sdk.kotlin.services.autoscaling.model.StepAdjustment
import aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutScalingPolicyOperationSerializer: HttpSerialize<PutScalingPolicyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutScalingPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializePutScalingPolicyOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializePutScalingPolicyOperationBody(context: ExecutionContext, input: PutScalingPolicyRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ADJUSTMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AdjustmentType"))
    val AUTOSCALINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AutoScalingGroupName"))
    val COOLDOWN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Cooldown"))
    val ENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("Enabled"))
    val ESTIMATEDINSTANCEWARMUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("EstimatedInstanceWarmup"))
    val METRICAGGREGATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MetricAggregationType"))
    val MINADJUSTMENTMAGNITUDE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MinAdjustmentMagnitude"))
    val MINADJUSTMENTSTEP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MinAdjustmentStep"))
    val POLICYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PolicyName"))
    val POLICYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PolicyType"))
    val PREDICTIVESCALINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("PredictiveScalingConfiguration"))
    val SCALINGADJUSTMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("ScalingAdjustment"))
    val STEPADJUSTMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("StepAdjustments"))
    val TARGETTRACKINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("TargetTrackingConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("PutScalingPolicyType"))
        trait(QueryLiteral("Action", "PutScalingPolicy"))
        trait(QueryLiteral("Version", "2011-01-01"))
        field(ADJUSTMENTTYPE_DESCRIPTOR)
        field(AUTOSCALINGGROUPNAME_DESCRIPTOR)
        field(COOLDOWN_DESCRIPTOR)
        field(ENABLED_DESCRIPTOR)
        field(ESTIMATEDINSTANCEWARMUP_DESCRIPTOR)
        field(METRICAGGREGATIONTYPE_DESCRIPTOR)
        field(MINADJUSTMENTMAGNITUDE_DESCRIPTOR)
        field(MINADJUSTMENTSTEP_DESCRIPTOR)
        field(POLICYNAME_DESCRIPTOR)
        field(POLICYTYPE_DESCRIPTOR)
        field(PREDICTIVESCALINGCONFIGURATION_DESCRIPTOR)
        field(SCALINGADJUSTMENT_DESCRIPTOR)
        field(STEPADJUSTMENTS_DESCRIPTOR)
        field(TARGETTRACKINGCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.adjustmentType?.let { field(ADJUSTMENTTYPE_DESCRIPTOR, it) }
        input.autoScalingGroupName?.let { field(AUTOSCALINGGROUPNAME_DESCRIPTOR, it) }
        input.cooldown?.let { field(COOLDOWN_DESCRIPTOR, it) }
        input.enabled?.let { field(ENABLED_DESCRIPTOR, it) }
        input.estimatedInstanceWarmup?.let { field(ESTIMATEDINSTANCEWARMUP_DESCRIPTOR, it) }
        input.metricAggregationType?.let { field(METRICAGGREGATIONTYPE_DESCRIPTOR, it) }
        input.minAdjustmentMagnitude?.let { field(MINADJUSTMENTMAGNITUDE_DESCRIPTOR, it) }
        input.minAdjustmentStep?.let { field(MINADJUSTMENTSTEP_DESCRIPTOR, it) }
        input.policyName?.let { field(POLICYNAME_DESCRIPTOR, it) }
        input.policyType?.let { field(POLICYTYPE_DESCRIPTOR, it) }
        input.predictiveScalingConfiguration?.let { field(PREDICTIVESCALINGCONFIGURATION_DESCRIPTOR, it, ::serializePredictiveScalingConfigurationDocument) }
        input.scalingAdjustment?.let { field(SCALINGADJUSTMENT_DESCRIPTOR, it) }
        if (input.stepAdjustments != null) {
            listField(STEPADJUSTMENTS_DESCRIPTOR) {
                for (el0 in input.stepAdjustments) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeStepAdjustmentDocument))
                }
            }
        }
        input.targetTrackingConfiguration?.let { field(TARGETTRACKINGCONFIGURATION_DESCRIPTOR, it, ::serializeTargetTrackingConfigurationDocument) }
    }
    return serializer.toByteArray()
}
