// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingInstanceDetails
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingInstancesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeAutoScalingInstancesOperationDeserializer: HttpDeserialize<DescribeAutoScalingInstancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAutoScalingInstancesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAutoScalingInstancesError(context, response)
        }
        val builder = DescribeAutoScalingInstancesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAutoScalingInstancesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAutoScalingInstancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedResponse)
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedResponse)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAutoScalingInstancesOperationBody(builder: DescribeAutoScalingInstancesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeAutoScalingInstancesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeAutoScalingInstancesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeAutoScalingInstances response")
    }
    // end unwrap response wrapper

    val AUTOSCALINGINSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AutoScalingInstances"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://autoscaling.amazonaws.com/doc/2011-01-01/"))
        trait(XmlSerialName("DescribeAutoScalingInstancesResult"))
        field(AUTOSCALINGINSTANCES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOSCALINGINSTANCES_DESCRIPTOR.index -> builder.autoScalingInstances =
                    deserializer.deserializeList(AUTOSCALINGINSTANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoScalingInstanceDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoScalingInstanceDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
