// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingException
import aws.sdk.kotlin.services.autoscaling.model.DescribeAccountLimitsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeAccountLimitsOperationDeserializer: HttpDeserialize<DescribeAccountLimitsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAccountLimitsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAccountLimitsError(context, response)
        }
        val builder = DescribeAccountLimitsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAccountLimitsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAccountLimitsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw AutoScalingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceContention" -> ResourceContentionFaultDeserializer().deserialize(context, wrappedResponse)
        else -> AutoScalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccountLimitsOperationBody(builder: DescribeAccountLimitsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeAccountLimitsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeAccountLimitsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeAccountLimits response")
    }
    // end unwrap response wrapper

    val MAXNUMBEROFAUTOSCALINGGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("MaxNumberOfAutoScalingGroups"))
    val MAXNUMBEROFLAUNCHCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("MaxNumberOfLaunchConfigurations"))
    val NUMBEROFAUTOSCALINGGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("NumberOfAutoScalingGroups"))
    val NUMBEROFLAUNCHCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("NumberOfLaunchConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://autoscaling.amazonaws.com/doc/2011-01-01/"))
        trait(XmlSerialName("DescribeAccountLimitsResult"))
        field(MAXNUMBEROFAUTOSCALINGGROUPS_DESCRIPTOR)
        field(MAXNUMBEROFLAUNCHCONFIGURATIONS_DESCRIPTOR)
        field(NUMBEROFAUTOSCALINGGROUPS_DESCRIPTOR)
        field(NUMBEROFLAUNCHCONFIGURATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MAXNUMBEROFAUTOSCALINGGROUPS_DESCRIPTOR.index -> builder.maxNumberOfAutoScalingGroups = deserializeInt()
                MAXNUMBEROFLAUNCHCONFIGURATIONS_DESCRIPTOR.index -> builder.maxNumberOfLaunchConfigurations = deserializeInt()
                NUMBEROFAUTOSCALINGGROUPS_DESCRIPTOR.index -> builder.numberOfAutoScalingGroups = deserializeInt()
                NUMBEROFLAUNCHCONFIGURATIONS_DESCRIPTOR.index -> builder.numberOfLaunchConfigurations = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
