// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.paginators

import aws.sdk.kotlin.services.autoscaling.AutoScalingClient
import aws.sdk.kotlin.services.autoscaling.model.Activity
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingGroup
import aws.sdk.kotlin.services.autoscaling.model.AutoScalingInstanceDetails
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingGroupsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingInstancesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeAutoScalingInstancesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeLaunchConfigurationsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeLaunchConfigurationsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeNotificationConfigurationsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeNotificationConfigurationsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribePoliciesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribePoliciesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingActivitiesRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeScalingActivitiesResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeScheduledActionsResponse
import aws.sdk.kotlin.services.autoscaling.model.DescribeTagsRequest
import aws.sdk.kotlin.services.autoscaling.model.DescribeTagsResponse
import aws.sdk.kotlin.services.autoscaling.model.LaunchConfiguration
import aws.sdk.kotlin.services.autoscaling.model.NotificationConfiguration
import aws.sdk.kotlin.services.autoscaling.model.ScalingPolicy
import aws.sdk.kotlin.services.autoscaling.model.ScheduledUpdateGroupAction
import aws.sdk.kotlin.services.autoscaling.model.TagDescription
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAutoScalingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAutoScalingGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingGroupsResponse]
 */
public fun AutoScalingClient.describeAutoScalingGroupsPaginated(initialRequest: DescribeAutoScalingGroupsRequest): Flow<DescribeAutoScalingGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAutoScalingGroupsPaginated.describeAutoScalingGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAutoScalingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingGroupsResponse]
 */
public fun AutoScalingClient.describeAutoScalingGroupsPaginated(block: DescribeAutoScalingGroupsRequest.Builder.() -> Unit): Flow<DescribeAutoScalingGroupsResponse> =
    describeAutoScalingGroupsPaginated(DescribeAutoScalingGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAutoScalingGroupsPaginated]
 * to access the nested member [AutoScalingGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AutoScalingGroup]
 */
@JvmName("describeAutoScalingGroupsResponseAutoScalingGroup")
public fun Flow<DescribeAutoScalingGroupsResponse>.autoScalingGroups(): Flow<AutoScalingGroup> =
    transform() { response ->
        response.autoScalingGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeAutoScalingInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAutoScalingInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingInstancesResponse]
 */
public fun AutoScalingClient.describeAutoScalingInstancesPaginated(initialRequest: DescribeAutoScalingInstancesRequest): Flow<DescribeAutoScalingInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAutoScalingInstancesPaginated.describeAutoScalingInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAutoScalingInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAutoScalingInstancesResponse]
 */
public fun AutoScalingClient.describeAutoScalingInstancesPaginated(block: DescribeAutoScalingInstancesRequest.Builder.() -> Unit): Flow<DescribeAutoScalingInstancesResponse> =
    describeAutoScalingInstancesPaginated(DescribeAutoScalingInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAutoScalingInstancesPaginated]
 * to access the nested member [AutoScalingInstanceDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AutoScalingInstanceDetails]
 */
@JvmName("describeAutoScalingInstancesResponseAutoScalingInstanceDetails")
public fun Flow<DescribeAutoScalingInstancesResponse>.autoScalingInstances(): Flow<AutoScalingInstanceDetails> =
    transform() { response ->
        response.autoScalingInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeLaunchConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLaunchConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLaunchConfigurationsResponse]
 */
public fun AutoScalingClient.describeLaunchConfigurationsPaginated(initialRequest: DescribeLaunchConfigurationsRequest): Flow<DescribeLaunchConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeLaunchConfigurationsPaginated.describeLaunchConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLaunchConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLaunchConfigurationsResponse]
 */
public fun AutoScalingClient.describeLaunchConfigurationsPaginated(block: DescribeLaunchConfigurationsRequest.Builder.() -> Unit): Flow<DescribeLaunchConfigurationsResponse> =
    describeLaunchConfigurationsPaginated(DescribeLaunchConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeLaunchConfigurationsPaginated]
 * to access the nested member [LaunchConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LaunchConfiguration]
 */
@JvmName("describeLaunchConfigurationsResponseLaunchConfiguration")
public fun Flow<DescribeLaunchConfigurationsResponse>.launchConfigurations(): Flow<LaunchConfiguration> =
    transform() { response ->
        response.launchConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeNotificationConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeNotificationConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationConfigurationsResponse]
 */
public fun AutoScalingClient.describeNotificationConfigurationsPaginated(initialRequest: DescribeNotificationConfigurationsRequest): Flow<DescribeNotificationConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeNotificationConfigurationsPaginated.describeNotificationConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeNotificationConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeNotificationConfigurationsResponse]
 */
public fun AutoScalingClient.describeNotificationConfigurationsPaginated(block: DescribeNotificationConfigurationsRequest.Builder.() -> Unit): Flow<DescribeNotificationConfigurationsResponse> =
    describeNotificationConfigurationsPaginated(DescribeNotificationConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeNotificationConfigurationsPaginated]
 * to access the nested member [NotificationConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NotificationConfiguration]
 */
@JvmName("describeNotificationConfigurationsResponseNotificationConfiguration")
public fun Flow<DescribeNotificationConfigurationsResponse>.notificationConfigurations(): Flow<NotificationConfiguration> =
    transform() { response ->
        response.notificationConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePoliciesResponse]
 */
public fun AutoScalingClient.describePoliciesPaginated(initialRequest: DescribePoliciesRequest): Flow<DescribePoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePoliciesPaginated.describePolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePoliciesResponse]
 */
public fun AutoScalingClient.describePoliciesPaginated(block: DescribePoliciesRequest.Builder.() -> Unit): Flow<DescribePoliciesResponse> =
    describePoliciesPaginated(DescribePoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describePoliciesPaginated]
 * to access the nested member [ScalingPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScalingPolicy]
 */
@JvmName("describePoliciesResponseScalingPolicy")
public fun Flow<DescribePoliciesResponse>.scalingPolicies(): Flow<ScalingPolicy> =
    transform() { response ->
        response.scalingPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScalingActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScalingActivitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingActivitiesResponse]
 */
public fun AutoScalingClient.describeScalingActivitiesPaginated(initialRequest: DescribeScalingActivitiesRequest): Flow<DescribeScalingActivitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScalingActivitiesPaginated.describeScalingActivities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScalingActivitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScalingActivitiesResponse]
 */
public fun AutoScalingClient.describeScalingActivitiesPaginated(block: DescribeScalingActivitiesRequest.Builder.() -> Unit): Flow<DescribeScalingActivitiesResponse> =
    describeScalingActivitiesPaginated(DescribeScalingActivitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScalingActivitiesPaginated]
 * to access the nested member [Activity]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Activity]
 */
@JvmName("describeScalingActivitiesResponseActivity")
public fun Flow<DescribeScalingActivitiesResponse>.activities(): Flow<Activity> =
    transform() { response ->
        response.activities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeScheduledActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
public fun AutoScalingClient.describeScheduledActionsPaginated(initialRequest: DescribeScheduledActionsRequest): Flow<DescribeScheduledActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeScheduledActionsPaginated.describeScheduledActions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeScheduledActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeScheduledActionsResponse]
 */
public fun AutoScalingClient.describeScheduledActionsPaginated(block: DescribeScheduledActionsRequest.Builder.() -> Unit): Flow<DescribeScheduledActionsResponse> =
    describeScheduledActionsPaginated(DescribeScheduledActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeScheduledActionsPaginated]
 * to access the nested member [ScheduledUpdateGroupAction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduledUpdateGroupAction]
 */
@JvmName("describeScheduledActionsResponseScheduledUpdateGroupAction")
public fun Flow<DescribeScheduledActionsResponse>.scheduledUpdateGroupActions(): Flow<ScheduledUpdateGroupAction> =
    transform() { response ->
        response.scheduledUpdateGroupActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun AutoScalingClient.describeTagsPaginated(initialRequest: DescribeTagsRequest): Flow<DescribeTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeTagsPaginated.describeTags(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun AutoScalingClient.describeTagsPaginated(block: DescribeTagsRequest.Builder.() -> Unit): Flow<DescribeTagsResponse> =
    describeTagsPaginated(DescribeTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTagsPaginated]
 * to access the nested member [TagDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TagDescription]
 */
@JvmName("describeTagsResponseTagDescription")
public fun Flow<DescribeTagsResponse>.tags(): Flow<TagDescription> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
