// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes a scaling policy.
 */
public class ScalingPolicy private constructor(builder: Builder) {
    /**
     * Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
     */
    public val adjustmentType: kotlin.String? = builder.adjustmentType
    /**
     * The CloudWatch alarms related to the policy.
     */
    public val alarms: List<Alarm>? = builder.alarms
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The duration of the policy's cooldown period, in seconds.
     */
    public val cooldown: kotlin.Int? = builder.cooldown
    /**
     * Indicates whether the policy is enabled (`true`) or disabled (`false`).
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     */
    public val estimatedInstanceWarmup: kotlin.Int? = builder.estimatedInstanceWarmup
    /**
     * The aggregation type for the CloudWatch metrics. The valid values are `Minimum`, `Maximum`, and `Average`.
     */
    public val metricAggregationType: kotlin.String? = builder.metricAggregationType
    /**
     * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity`.
     */
    public val minAdjustmentMagnitude: kotlin.Int? = builder.minAdjustmentMagnitude
    /**
     * Available for backward compatibility. Use `MinAdjustmentMagnitude` instead.
     */
    public val minAdjustmentStep: kotlin.Int? = builder.minAdjustmentStep
    /**
     * The Amazon Resource Name (ARN) of the policy.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * The name of the scaling policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * One of the following policy types:
     * + `TargetTrackingScaling`
     * + `StepScaling`
     * + `SimpleScaling` (default)
     * + `PredictiveScaling`
     *
     * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html) and [Step and simple scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val policyType: kotlin.String? = builder.policyType
    /**
     * A predictive scaling policy.
     */
    public val predictiveScalingConfiguration: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration? = builder.predictiveScalingConfiguration
    /**
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity.
     */
    public val scalingAdjustment: kotlin.Int? = builder.scalingAdjustment
    /**
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     */
    public val stepAdjustments: List<StepAdjustment>? = builder.stepAdjustments
    /**
     * A target tracking scaling policy.
     */
    public val targetTrackingConfiguration: aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration? = builder.targetTrackingConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.ScalingPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingPolicy(")
        append("adjustmentType=$adjustmentType,")
        append("alarms=$alarms,")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("cooldown=$cooldown,")
        append("enabled=$enabled,")
        append("estimatedInstanceWarmup=$estimatedInstanceWarmup,")
        append("metricAggregationType=$metricAggregationType,")
        append("minAdjustmentMagnitude=$minAdjustmentMagnitude,")
        append("minAdjustmentStep=$minAdjustmentStep,")
        append("policyArn=$policyArn,")
        append("policyName=$policyName,")
        append("policyType=$policyType,")
        append("predictiveScalingConfiguration=$predictiveScalingConfiguration,")
        append("scalingAdjustment=$scalingAdjustment,")
        append("stepAdjustments=$stepAdjustments,")
        append("targetTrackingConfiguration=$targetTrackingConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjustmentType?.hashCode() ?: 0
        result = 31 * result + (alarms?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroupName?.hashCode() ?: 0)
        result = 31 * result + (cooldown ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (estimatedInstanceWarmup ?: 0)
        result = 31 * result + (metricAggregationType?.hashCode() ?: 0)
        result = 31 * result + (minAdjustmentMagnitude ?: 0)
        result = 31 * result + (minAdjustmentStep ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (predictiveScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scalingAdjustment ?: 0)
        result = 31 * result + (stepAdjustments?.hashCode() ?: 0)
        result = 31 * result + (targetTrackingConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingPolicy

        if (adjustmentType != other.adjustmentType) return false
        if (alarms != other.alarms) return false
        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (cooldown != other.cooldown) return false
        if (enabled != other.enabled) return false
        if (estimatedInstanceWarmup != other.estimatedInstanceWarmup) return false
        if (metricAggregationType != other.metricAggregationType) return false
        if (minAdjustmentMagnitude != other.minAdjustmentMagnitude) return false
        if (minAdjustmentStep != other.minAdjustmentStep) return false
        if (policyArn != other.policyArn) return false
        if (policyName != other.policyName) return false
        if (policyType != other.policyType) return false
        if (predictiveScalingConfiguration != other.predictiveScalingConfiguration) return false
        if (scalingAdjustment != other.scalingAdjustment) return false
        if (stepAdjustments != other.stepAdjustments) return false
        if (targetTrackingConfiguration != other.targetTrackingConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.ScalingPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
         */
        public var adjustmentType: kotlin.String? = null
        /**
         * The CloudWatch alarms related to the policy.
         */
        public var alarms: List<Alarm>? = null
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The duration of the policy's cooldown period, in seconds.
         */
        public var cooldown: kotlin.Int? = null
        /**
         * Indicates whether the policy is enabled (`true`) or disabled (`false`).
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
         */
        public var estimatedInstanceWarmup: kotlin.Int? = null
        /**
         * The aggregation type for the CloudWatch metrics. The valid values are `Minimum`, `Maximum`, and `Average`.
         */
        public var metricAggregationType: kotlin.String? = null
        /**
         * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity`.
         */
        public var minAdjustmentMagnitude: kotlin.Int? = null
        /**
         * Available for backward compatibility. Use `MinAdjustmentMagnitude` instead.
         */
        public var minAdjustmentStep: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the policy.
         */
        public var policyArn: kotlin.String? = null
        /**
         * The name of the scaling policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * One of the following policy types:
         * + `TargetTrackingScaling`
         * + `StepScaling`
         * + `SimpleScaling` (default)
         * + `PredictiveScaling`
         *
         * For more information, see [Target tracking scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html) and [Step and simple scaling policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var policyType: kotlin.String? = null
        /**
         * A predictive scaling policy.
         */
        public var predictiveScalingConfiguration: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration? = null
        /**
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity.
         */
        public var scalingAdjustment: kotlin.Int? = null
        /**
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         */
        public var stepAdjustments: List<StepAdjustment>? = null
        /**
         * A target tracking scaling policy.
         */
        public var targetTrackingConfiguration: aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.ScalingPolicy) : this() {
            this.adjustmentType = x.adjustmentType
            this.alarms = x.alarms
            this.autoScalingGroupName = x.autoScalingGroupName
            this.cooldown = x.cooldown
            this.enabled = x.enabled
            this.estimatedInstanceWarmup = x.estimatedInstanceWarmup
            this.metricAggregationType = x.metricAggregationType
            this.minAdjustmentMagnitude = x.minAdjustmentMagnitude
            this.minAdjustmentStep = x.minAdjustmentStep
            this.policyArn = x.policyArn
            this.policyName = x.policyName
            this.policyType = x.policyType
            this.predictiveScalingConfiguration = x.predictiveScalingConfiguration
            this.scalingAdjustment = x.scalingAdjustment
            this.stepAdjustments = x.stepAdjustments
            this.targetTrackingConfiguration = x.targetTrackingConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.ScalingPolicy = ScalingPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration] inside the given [block]
         */
        public fun predictiveScalingConfiguration(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.predictiveScalingConfiguration = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration] inside the given [block]
         */
        public fun targetTrackingConfiguration(block: aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration.Builder.() -> kotlin.Unit) {
            this.targetTrackingConfiguration = aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration.invoke(block)
        }
    }
}
