// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes the preferences for an instance refresh.
 */
public class RefreshPreferences private constructor(builder: Builder) {
    /**
     * The amount of time, in seconds, to wait after a checkpoint before continuing. This property is optional, but if you specify a value for it, you must also specify a value for `CheckpointPercentages`. If you specify a value for `CheckpointPercentages` and not for `CheckpointDelay`, the `CheckpointDelay` defaults to `3600` (1 hour).
     */
    public val checkpointDelay: kotlin.Int? = builder.checkpointDelay
    /**
     * Threshold values for each checkpoint in ascending order. Each number must be unique. To replace all instances in the Auto Scaling group, the last number in the array must be `100`.
     *
     * For usage examples, see [Adding checkpoints to an instance refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val checkpointPercentages: List<Int>? = builder.checkpointPercentages
    /**
     * *Not needed if the default instance warmup is defined for the group.*
     *
     * The duration of the instance warmup, in seconds.
     *
     * The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then `InstanceWarmup` falls back to the value of the health check grace period.
     */
    public val instanceWarmup: kotlin.Int? = builder.instanceWarmup
    /**
     * The amount of capacity in the Auto Scaling group that must pass your group's health checks to allow the operation to continue. The value is expressed as a percentage of the desired capacity of the Auto Scaling group (rounded up to the nearest integer). The default is `90`.
     *
     * Setting the minimum healthy percentage to 100 percent limits the rate of replacement to one instance at a time. In contrast, setting it to 0 percent has the effect of replacing all instances at the same time.
     */
    public val minHealthyPercentage: kotlin.Int? = builder.minHealthyPercentage
    /**
     * A boolean value that indicates whether skip matching is enabled. If true, then Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired configuration is specified, then it skips replacing instances that have the same configuration that is already set on the group. The default is `false`.
     */
    public val skipMatching: kotlin.Boolean? = builder.skipMatching

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RefreshPreferences(")
        append("checkpointDelay=$checkpointDelay,")
        append("checkpointPercentages=$checkpointPercentages,")
        append("instanceWarmup=$instanceWarmup,")
        append("minHealthyPercentage=$minHealthyPercentage,")
        append("skipMatching=$skipMatching)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkpointDelay ?: 0
        result = 31 * result + (checkpointPercentages?.hashCode() ?: 0)
        result = 31 * result + (instanceWarmup ?: 0)
        result = 31 * result + (minHealthyPercentage ?: 0)
        result = 31 * result + (skipMatching?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RefreshPreferences

        if (checkpointDelay != other.checkpointDelay) return false
        if (checkpointPercentages != other.checkpointPercentages) return false
        if (instanceWarmup != other.instanceWarmup) return false
        if (minHealthyPercentage != other.minHealthyPercentage) return false
        if (skipMatching != other.skipMatching) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of time, in seconds, to wait after a checkpoint before continuing. This property is optional, but if you specify a value for it, you must also specify a value for `CheckpointPercentages`. If you specify a value for `CheckpointPercentages` and not for `CheckpointDelay`, the `CheckpointDelay` defaults to `3600` (1 hour).
         */
        public var checkpointDelay: kotlin.Int? = null
        /**
         * Threshold values for each checkpoint in ascending order. Each number must be unique. To replace all instances in the Auto Scaling group, the last number in the array must be `100`.
         *
         * For usage examples, see [Adding checkpoints to an instance refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var checkpointPercentages: List<Int>? = null
        /**
         * *Not needed if the default instance warmup is defined for the group.*
         *
         * The duration of the instance warmup, in seconds.
         *
         * The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then `InstanceWarmup` falls back to the value of the health check grace period.
         */
        public var instanceWarmup: kotlin.Int? = null
        /**
         * The amount of capacity in the Auto Scaling group that must pass your group's health checks to allow the operation to continue. The value is expressed as a percentage of the desired capacity of the Auto Scaling group (rounded up to the nearest integer). The default is `90`.
         *
         * Setting the minimum healthy percentage to 100 percent limits the rate of replacement to one instance at a time. In contrast, setting it to 0 percent has the effect of replacing all instances at the same time.
         */
        public var minHealthyPercentage: kotlin.Int? = null
        /**
         * A boolean value that indicates whether skip matching is enabled. If true, then Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired configuration is specified, then it skips replacing instances that have the same configuration that is already set on the group. The default is `false`.
         */
        public var skipMatching: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences) : this() {
            this.checkpointDelay = x.checkpointDelay
            this.checkpointPercentages = x.checkpointPercentages
            this.instanceWarmup = x.instanceWarmup
            this.minHealthyPercentage = x.minHealthyPercentage
            this.skipMatching = x.skipMatching
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.RefreshPreferences = RefreshPreferences(this)
    }
}
