// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



public class PutWarmPoolRequest private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.
     */
    public val instanceReusePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceReusePolicy? = builder.instanceReusePolicy
    /**
     * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except `Terminated` for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.
     *
     * If a value for `MaxGroupPreparedCapacity` is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for `MaxGroupPreparedCapacity`, Amazon EC2 Auto Scaling uses the difference between the `MaxGroupPreparedCapacity` and the desired capacity instead.
     *
     * The size of the warm pool is dynamic. Only when `MaxGroupPreparedCapacity` and `MinSize` are set to the same value does the warm pool have an absolute size.
     *
     * If the desired capacity of the Auto Scaling group is higher than the `MaxGroupPreparedCapacity`, the capacity of the warm pool is 0, unless you specify a value for `MinSize`. To remove a value that you previously set, include the property but specify -1 for the value.
     */
    public val maxGroupPreparedCapacity: kotlin.Int? = builder.maxGroupPreparedCapacity
    /**
     * Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
     */
    public val minSize: kotlin.Int? = builder.minSize
    /**
     * Sets the instance state to transition to after the lifecycle actions are complete. Default is `Stopped`.
     */
    public val poolState: aws.sdk.kotlin.services.autoscaling.model.WarmPoolState? = builder.poolState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PutWarmPoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutWarmPoolRequest(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("instanceReusePolicy=$instanceReusePolicy,")
        append("maxGroupPreparedCapacity=$maxGroupPreparedCapacity,")
        append("minSize=$minSize,")
        append("poolState=$poolState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (instanceReusePolicy?.hashCode() ?: 0)
        result = 31 * result + (maxGroupPreparedCapacity ?: 0)
        result = 31 * result + (minSize ?: 0)
        result = 31 * result + (poolState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutWarmPoolRequest

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (instanceReusePolicy != other.instanceReusePolicy) return false
        if (maxGroupPreparedCapacity != other.maxGroupPreparedCapacity) return false
        if (minSize != other.minSize) return false
        if (poolState != other.poolState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PutWarmPoolRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.
         */
        public var instanceReusePolicy: aws.sdk.kotlin.services.autoscaling.model.InstanceReusePolicy? = null
        /**
         * Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except `Terminated` for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity.
         *
         * If a value for `MaxGroupPreparedCapacity` is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for `MaxGroupPreparedCapacity`, Amazon EC2 Auto Scaling uses the difference between the `MaxGroupPreparedCapacity` and the desired capacity instead.
         *
         * The size of the warm pool is dynamic. Only when `MaxGroupPreparedCapacity` and `MinSize` are set to the same value does the warm pool have an absolute size.
         *
         * If the desired capacity of the Auto Scaling group is higher than the `MaxGroupPreparedCapacity`, the capacity of the warm pool is 0, unless you specify a value for `MinSize`. To remove a value that you previously set, include the property but specify -1 for the value.
         */
        public var maxGroupPreparedCapacity: kotlin.Int? = null
        /**
         * Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
         */
        public var minSize: kotlin.Int? = null
        /**
         * Sets the instance state to transition to after the lifecycle actions are complete. Default is `Stopped`.
         */
        public var poolState: aws.sdk.kotlin.services.autoscaling.model.WarmPoolState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PutWarmPoolRequest) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.instanceReusePolicy = x.instanceReusePolicy
            this.maxGroupPreparedCapacity = x.maxGroupPreparedCapacity
            this.minSize = x.minSize
            this.poolState = x.poolState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PutWarmPoolRequest = PutWarmPoolRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.InstanceReusePolicy] inside the given [block]
         */
        public fun instanceReusePolicy(block: aws.sdk.kotlin.services.autoscaling.model.InstanceReusePolicy.Builder.() -> kotlin.Unit) {
            this.instanceReusePolicy = aws.sdk.kotlin.services.autoscaling.model.InstanceReusePolicy.invoke(block)
        }
    }
}
