// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



public class PutScalingPolicyRequest private constructor(builder: Builder) {
    /**
     * Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
     *
     * Required if the policy type is `StepScaling` or `SimpleScaling`. For more information, see [Scaling adjustment types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val adjustmentType: kotlin.String? = builder.adjustmentType
    /**
     * The name of the Auto Scaling group.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is specified here, it overrides the default cooldown.
     *
     * Valid only if the policy type is `SimpleScaling`. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Default: None
     */
    public val cooldown: kotlin.Int? = builder.cooldown
    /**
     * Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see [Disabling a scaling policy for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * *Not needed if the default instance warmup is defined for the group.*
     *
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This warm-up period applies to instances launched due to a specific target tracking or step scaling policy. When a warm-up period is specified here, it overrides the default instance warmup.
     *
     * Valid only if the policy type is `TargetTrackingScaling` or `StepScaling`.
     *
     * The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then `EstimatedInstanceWarmup` falls back to the value of default cooldown.
     */
    public val estimatedInstanceWarmup: kotlin.Int? = builder.estimatedInstanceWarmup
    /**
     * The aggregation type for the CloudWatch metrics. The valid values are `Minimum`, `Maximum`, and `Average`. If the aggregation type is null, the value is treated as `Average`.
     *
     * Valid only if the policy type is `StepScaling`.
     */
    public val metricAggregationType: kotlin.String? = builder.metricAggregationType
    /**
     * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity`. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a `MinAdjustmentMagnitude` of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a `MinAdjustmentMagnitude` of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
     *
     * Valid only if the policy type is `StepScaling` or `SimpleScaling`. For more information, see [Scaling adjustment types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment) in the *Amazon EC2 Auto Scaling User Guide*.
     *
     * Some Auto Scaling groups use instance weights. In this case, set the `MinAdjustmentMagnitude` to a value that is at least as large as your largest instance weight.
     */
    public val minAdjustmentMagnitude: kotlin.Int? = builder.minAdjustmentMagnitude
    /**
     * Available for backward compatibility. Use `MinAdjustmentMagnitude` instead.
     */
    public val minAdjustmentStep: kotlin.Int? = builder.minAdjustmentStep
    /**
     * The name of the policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * One of the following policy types:
     * + `TargetTrackingScaling`
     * + `StepScaling`
     * + `SimpleScaling` (default)
     * + `PredictiveScaling`
     */
    public val policyType: kotlin.String? = builder.policyType
    /**
     * A predictive scaling policy. Provides support for predefined and custom metrics.
     *
     * Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
     *
     * For more information, see [PredictiveScalingConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html) in the *Amazon EC2 Auto Scaling API Reference*.
     *
     * Required if the policy type is `PredictiveScaling`.
     */
    public val predictiveScalingConfiguration: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration? = builder.predictiveScalingConfiguration
    /**
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
     *
     * Required if the policy type is `SimpleScaling`. (Not used with any other policy type.)
     */
    public val scalingAdjustment: kotlin.Int? = builder.scalingAdjustment
    /**
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     *
     * Required if the policy type is `StepScaling`. (Not used with any other policy type.)
     */
    public val stepAdjustments: List<StepAdjustment>? = builder.stepAdjustments
    /**
     * A target tracking scaling policy. Provides support for predefined or custom metrics.
     *
     * The following predefined metrics are available:
     * + `ASGAverageCPUUtilization`
     * + `ASGAverageNetworkIn`
     * + `ASGAverageNetworkOut`
     * + `ALBRequestCountPerTarget`
     *
     * If you specify `ALBRequestCountPerTarget` for the metric, you must specify the `ResourceLabel` property with the `PredefinedMetricSpecification`.
     *
     * For more information, see [TargetTrackingConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html) in the *Amazon EC2 Auto Scaling API Reference*.
     *
     * Required if the policy type is `TargetTrackingScaling`.
     */
    public val targetTrackingConfiguration: aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration? = builder.targetTrackingConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutScalingPolicyRequest(")
        append("adjustmentType=$adjustmentType,")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("cooldown=$cooldown,")
        append("enabled=$enabled,")
        append("estimatedInstanceWarmup=$estimatedInstanceWarmup,")
        append("metricAggregationType=$metricAggregationType,")
        append("minAdjustmentMagnitude=$minAdjustmentMagnitude,")
        append("minAdjustmentStep=$minAdjustmentStep,")
        append("policyName=$policyName,")
        append("policyType=$policyType,")
        append("predictiveScalingConfiguration=$predictiveScalingConfiguration,")
        append("scalingAdjustment=$scalingAdjustment,")
        append("stepAdjustments=$stepAdjustments,")
        append("targetTrackingConfiguration=$targetTrackingConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjustmentType?.hashCode() ?: 0
        result = 31 * result + (autoScalingGroupName?.hashCode() ?: 0)
        result = 31 * result + (cooldown ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (estimatedInstanceWarmup ?: 0)
        result = 31 * result + (metricAggregationType?.hashCode() ?: 0)
        result = 31 * result + (minAdjustmentMagnitude ?: 0)
        result = 31 * result + (minAdjustmentStep ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (predictiveScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scalingAdjustment ?: 0)
        result = 31 * result + (stepAdjustments?.hashCode() ?: 0)
        result = 31 * result + (targetTrackingConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutScalingPolicyRequest

        if (adjustmentType != other.adjustmentType) return false
        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (cooldown != other.cooldown) return false
        if (enabled != other.enabled) return false
        if (estimatedInstanceWarmup != other.estimatedInstanceWarmup) return false
        if (metricAggregationType != other.metricAggregationType) return false
        if (minAdjustmentMagnitude != other.minAdjustmentMagnitude) return false
        if (minAdjustmentStep != other.minAdjustmentStep) return false
        if (policyName != other.policyName) return false
        if (policyType != other.policyType) return false
        if (predictiveScalingConfiguration != other.predictiveScalingConfiguration) return false
        if (scalingAdjustment != other.scalingAdjustment) return false
        if (stepAdjustments != other.stepAdjustments) return false
        if (targetTrackingConfiguration != other.targetTrackingConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
         *
         * Required if the policy type is `StepScaling` or `SimpleScaling`. For more information, see [Scaling adjustment types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var adjustmentType: kotlin.String? = null
        /**
         * The name of the Auto Scaling group.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is specified here, it overrides the default cooldown.
         *
         * Valid only if the policy type is `SimpleScaling`. For more information, see [Scaling cooldowns for Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Default: None
         */
        public var cooldown: kotlin.Int? = null
        /**
         * Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see [Disabling a scaling policy for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * *Not needed if the default instance warmup is defined for the group.*
         *
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This warm-up period applies to instances launched due to a specific target tracking or step scaling policy. When a warm-up period is specified here, it overrides the default instance warmup.
         *
         * Valid only if the policy type is `TargetTrackingScaling` or `StepScaling`.
         *
         * The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then `EstimatedInstanceWarmup` falls back to the value of default cooldown.
         */
        public var estimatedInstanceWarmup: kotlin.Int? = null
        /**
         * The aggregation type for the CloudWatch metrics. The valid values are `Minimum`, `Maximum`, and `Average`. If the aggregation type is null, the value is treated as `Average`.
         *
         * Valid only if the policy type is `StepScaling`.
         */
        public var metricAggregationType: kotlin.String? = null
        /**
         * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity`. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a `MinAdjustmentMagnitude` of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a `MinAdjustmentMagnitude` of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
         *
         * Valid only if the policy type is `StepScaling` or `SimpleScaling`. For more information, see [Scaling adjustment types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment) in the *Amazon EC2 Auto Scaling User Guide*.
         *
         * Some Auto Scaling groups use instance weights. In this case, set the `MinAdjustmentMagnitude` to a value that is at least as large as your largest instance weight.
         */
        public var minAdjustmentMagnitude: kotlin.Int? = null
        /**
         * Available for backward compatibility. Use `MinAdjustmentMagnitude` instead.
         */
        public var minAdjustmentStep: kotlin.Int? = null
        /**
         * The name of the policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * One of the following policy types:
         * + `TargetTrackingScaling`
         * + `StepScaling`
         * + `SimpleScaling` (default)
         * + `PredictiveScaling`
         */
        public var policyType: kotlin.String? = null
        /**
         * A predictive scaling policy. Provides support for predefined and custom metrics.
         *
         * Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
         *
         * For more information, see [PredictiveScalingConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html) in the *Amazon EC2 Auto Scaling API Reference*.
         *
         * Required if the policy type is `PredictiveScaling`.
         */
        public var predictiveScalingConfiguration: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration? = null
        /**
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
         *
         * Required if the policy type is `SimpleScaling`. (Not used with any other policy type.)
         */
        public var scalingAdjustment: kotlin.Int? = null
        /**
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         *
         * Required if the policy type is `StepScaling`. (Not used with any other policy type.)
         */
        public var stepAdjustments: List<StepAdjustment>? = null
        /**
         * A target tracking scaling policy. Provides support for predefined or custom metrics.
         *
         * The following predefined metrics are available:
         * + `ASGAverageCPUUtilization`
         * + `ASGAverageNetworkIn`
         * + `ASGAverageNetworkOut`
         * + `ALBRequestCountPerTarget`
         *
         * If you specify `ALBRequestCountPerTarget` for the metric, you must specify the `ResourceLabel` property with the `PredefinedMetricSpecification`.
         *
         * For more information, see [TargetTrackingConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html) in the *Amazon EC2 Auto Scaling API Reference*.
         *
         * Required if the policy type is `TargetTrackingScaling`.
         */
        public var targetTrackingConfiguration: aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyRequest) : this() {
            this.adjustmentType = x.adjustmentType
            this.autoScalingGroupName = x.autoScalingGroupName
            this.cooldown = x.cooldown
            this.enabled = x.enabled
            this.estimatedInstanceWarmup = x.estimatedInstanceWarmup
            this.metricAggregationType = x.metricAggregationType
            this.minAdjustmentMagnitude = x.minAdjustmentMagnitude
            this.minAdjustmentStep = x.minAdjustmentStep
            this.policyName = x.policyName
            this.policyType = x.policyType
            this.predictiveScalingConfiguration = x.predictiveScalingConfiguration
            this.scalingAdjustment = x.scalingAdjustment
            this.stepAdjustments = x.stepAdjustments
            this.targetTrackingConfiguration = x.targetTrackingConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PutScalingPolicyRequest = PutScalingPolicyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration] inside the given [block]
         */
        public fun predictiveScalingConfiguration(block: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.predictiveScalingConfiguration = aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration] inside the given [block]
         */
        public fun targetTrackingConfiguration(block: aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration.Builder.() -> kotlin.Unit) {
            this.targetTrackingConfiguration = aws.sdk.kotlin.services.autoscaling.model.TargetTrackingConfiguration.invoke(block)
        }
    }
}
