// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Represents a metric pair for a predictive scaling policy.
 */
public class PredictiveScalingPredefinedMetricPair private constructor(builder: Builder) {
    /**
     * Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization`, the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
     */
    public val predefinedMetricType: aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricPairType? = builder.predefinedMetricType
    /**
     * A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
     *
     * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
     *
     * `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff`.
     *
     * Where:
     * + app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
     * + targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
     *
     * To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
     */
    public val resourceLabel: kotlin.String? = builder.resourceLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredictiveScalingPredefinedMetricPair(")
        append("predefinedMetricType=$predefinedMetricType,")
        append("resourceLabel=$resourceLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = predefinedMetricType?.hashCode() ?: 0
        result = 31 * result + (resourceLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredictiveScalingPredefinedMetricPair

        if (predefinedMetricType != other.predefinedMetricType) return false
        if (resourceLabel != other.resourceLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization`, the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
         */
        public var predefinedMetricType: aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricPairType? = null
        /**
         * A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
         *
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
         *
         * `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff`.
         *
         * Where:
         * + app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
         * + targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
         *
         * To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
         */
        public var resourceLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair) : this() {
            this.predefinedMetricType = x.predefinedMetricType
            this.resourceLabel = x.resourceLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingPredefinedMetricPair = PredictiveScalingPredefinedMetricPair(this)
    }
}
