// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Represents a predictive scaling policy configuration to use with Amazon EC2 Auto Scaling.
 */
public class PredictiveScalingConfiguration private constructor(builder: Builder) {
    /**
     * Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to `HonorMaxCapacity` if not specified.
     *
     * The following are possible values:
     * + `HonorMaxCapacity` - Amazon EC2 Auto Scaling cannot scale out capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.
     * + `IncreaseMaxCapacity` - Amazon EC2 Auto Scaling can scale out capacity higher than the maximum capacity when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for `MaxCapacityBuffer`.
     */
    public val maxCapacityBreachBehavior: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMaxCapacityBreachBehavior? = builder.maxCapacityBreachBehavior
    /**
     * The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
     *
     * If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
     *
     * Required if the `MaxCapacityBreachBehavior` property is set to `IncreaseMaxCapacity`, and cannot be used otherwise.
     */
    public val maxCapacityBuffer: kotlin.Int? = builder.maxCapacityBuffer
    /**
     * This structure includes the metrics and target utilization to use for predictive scaling.
     *
     * This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
     */
    public val metricSpecifications: List<PredictiveScalingMetricSpecification>? = builder.metricSpecifications
    /**
     * The predictive scaling mode. Defaults to `ForecastOnly` if not specified.
     */
    public val mode: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMode? = builder.mode
    /**
     * The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
     *
     * The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
     */
    public val schedulingBufferTime: kotlin.Int? = builder.schedulingBufferTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredictiveScalingConfiguration(")
        append("maxCapacityBreachBehavior=$maxCapacityBreachBehavior,")
        append("maxCapacityBuffer=$maxCapacityBuffer,")
        append("metricSpecifications=$metricSpecifications,")
        append("mode=$mode,")
        append("schedulingBufferTime=$schedulingBufferTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxCapacityBreachBehavior?.hashCode() ?: 0
        result = 31 * result + (maxCapacityBuffer ?: 0)
        result = 31 * result + (metricSpecifications?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (schedulingBufferTime ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredictiveScalingConfiguration

        if (maxCapacityBreachBehavior != other.maxCapacityBreachBehavior) return false
        if (maxCapacityBuffer != other.maxCapacityBuffer) return false
        if (metricSpecifications != other.metricSpecifications) return false
        if (mode != other.mode) return false
        if (schedulingBufferTime != other.schedulingBufferTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group. Defaults to `HonorMaxCapacity` if not specified.
         *
         * The following are possible values:
         * + `HonorMaxCapacity` - Amazon EC2 Auto Scaling cannot scale out capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.
         * + `IncreaseMaxCapacity` - Amazon EC2 Auto Scaling can scale out capacity higher than the maximum capacity when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for `MaxCapacityBuffer`.
         */
        public var maxCapacityBreachBehavior: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMaxCapacityBreachBehavior? = null
        /**
         * The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity. The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
         *
         * If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
         *
         * Required if the `MaxCapacityBreachBehavior` property is set to `IncreaseMaxCapacity`, and cannot be used otherwise.
         */
        public var maxCapacityBuffer: kotlin.Int? = null
        /**
         * This structure includes the metrics and target utilization to use for predictive scaling.
         *
         * This is an array, but we currently only support a single metric specification. That is, you can specify a target value and a single metric pair, or a target value and one scaling metric and one load metric.
         */
        public var metricSpecifications: List<PredictiveScalingMetricSpecification>? = null
        /**
         * The predictive scaling mode. Defaults to `ForecastOnly` if not specified.
         */
        public var mode: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingMode? = null
        /**
         * The amount of time, in seconds, by which the instance launch time can be advanced. For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
         *
         * The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
         */
        public var schedulingBufferTime: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration) : this() {
            this.maxCapacityBreachBehavior = x.maxCapacityBreachBehavior
            this.maxCapacityBuffer = x.maxCapacityBuffer
            this.metricSpecifications = x.metricSpecifications
            this.mode = x.mode
            this.schedulingBufferTime = x.schedulingBufferTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PredictiveScalingConfiguration = PredictiveScalingConfiguration(this)
    }
}
