// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Represents a predefined metric for a target tracking scaling policy to use with Amazon EC2 Auto Scaling.
 */
public class PredefinedMetricSpecification private constructor(builder: Builder) {
    /**
     * The metric type. The following predefined metrics are available:
     * + `ASGAverageCPUUtilization` - Average CPU utilization of the Auto Scaling group.
     * + `ASGAverageNetworkIn` - Average number of bytes received on all network interfaces by the Auto Scaling group.
     * + `ASGAverageNetworkOut` - Average number of bytes sent out on all network interfaces by the Auto Scaling group.
     * + `ALBRequestCountPerTarget` - Average Application Load Balancer request count per target for your Auto Scaling group.
     */
    public val predefinedMetricType: aws.sdk.kotlin.services.autoscaling.model.MetricType? = builder.predefinedMetricType
    /**
     * A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
     *
     * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
     *
     * `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff`.
     *
     * Where:
     * + app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
     * + targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
     *
     * To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
     */
    public val resourceLabel: kotlin.String? = builder.resourceLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredefinedMetricSpecification(")
        append("predefinedMetricType=$predefinedMetricType,")
        append("resourceLabel=$resourceLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = predefinedMetricType?.hashCode() ?: 0
        result = 31 * result + (resourceLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredefinedMetricSpecification

        if (predefinedMetricType != other.predefinedMetricType) return false
        if (resourceLabel != other.resourceLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metric type. The following predefined metrics are available:
         * + `ASGAverageCPUUtilization` - Average CPU utilization of the Auto Scaling group.
         * + `ASGAverageNetworkIn` - Average number of bytes received on all network interfaces by the Auto Scaling group.
         * + `ASGAverageNetworkOut` - Average number of bytes sent out on all network interfaces by the Auto Scaling group.
         * + `ALBRequestCountPerTarget` - Average Application Load Balancer request count per target for your Auto Scaling group.
         */
        public var predefinedMetricType: aws.sdk.kotlin.services.autoscaling.model.MetricType? = null
        /**
         * A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group. You can't specify a resource label unless the target group is attached to the Auto Scaling group.
         *
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
         *
         * `app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff`.
         *
         * Where:
         * + app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN
         * + targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.
         *
         * To find the ARN for an Application Load Balancer, use the [DescribeLoadBalancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html) API operation. To find the ARN for the target group, use the [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html) API operation.
         */
        public var resourceLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification) : this() {
            this.predefinedMetricType = x.predefinedMetricType
            this.resourceLabel = x.resourceLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.PredefinedMetricSpecification = PredefinedMetricSpecification(this)
    }
}
