// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * The metric data to return. Also defines whether this call is returning data for one metric only, or whether it is performing a math expression on the values of returned metric statistics to create a new time series. A time series is a series of data points, each of which is associated with a timestamp.
 *
 * For more information and examples, see [Advanced predictive scaling policy configurations using custom metrics](https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html) in the *Amazon EC2 Auto Scaling User Guide*.
 */
public class MetricDataQuery private constructor(builder: Builder) {
    /**
     * The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.
     *
     * Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat`, but not both.
     */
    public val expression: kotlin.String? = builder.expression
    /**
     * A short name that identifies the object's results in the response. This name must be unique among all `MetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
     */
    public val label: kotlin.String? = builder.label
    /**
     * Information about the metric data to return.
     *
     * Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat`, but not both.
     */
    public val metricStat: aws.sdk.kotlin.services.autoscaling.model.MetricStat? = builder.metricStat
    /**
     * Indicates whether to return the timestamps and raw data values of this metric.
     *
     * If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.
     *
     * If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData`. This sets it to its default (`true`).
     */
    public val returnData: kotlin.Boolean? = builder.returnData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.MetricDataQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetricDataQuery(")
        append("expression=$expression,")
        append("id=$id,")
        append("label=$label,")
        append("metricStat=$metricStat,")
        append("returnData=$returnData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = expression?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (metricStat?.hashCode() ?: 0)
        result = 31 * result + (returnData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetricDataQuery

        if (expression != other.expression) return false
        if (id != other.id) return false
        if (label != other.label) return false
        if (metricStat != other.metricStat) return false
        if (returnData != other.returnData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.MetricDataQuery = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The math expression to perform on the returned data, if this object is performing a math expression. This expression can use the `Id` of the other metrics to refer to those metrics, and can also use the `Id` of other expressions to use the result of those expressions.
         *
         * Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat`, but not both.
         */
        public var expression: kotlin.String? = null
        /**
         * A short name that identifies the object's results in the response. This name must be unique among all `MetricDataQuery` objects specified for a single scaling policy. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscores. The first character must be a lowercase letter.
         */
        public var id: kotlin.String? = null
        /**
         * A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
         */
        public var label: kotlin.String? = null
        /**
         * Information about the metric data to return.
         *
         * Conditional: Within each `MetricDataQuery` object, you must specify either `Expression` or `MetricStat`, but not both.
         */
        public var metricStat: aws.sdk.kotlin.services.autoscaling.model.MetricStat? = null
        /**
         * Indicates whether to return the timestamps and raw data values of this metric.
         *
         * If you use any math expressions, specify `true` for this value for only the final math expression that the metric specification is based on. You must specify `false` for `ReturnData` for all the other metrics and expressions used in the metric specification.
         *
         * If you are only retrieving metrics and not performing any math expressions, do not specify anything for `ReturnData`. This sets it to its default (`true`).
         */
        public var returnData: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.MetricDataQuery) : this() {
            this.expression = x.expression
            this.id = x.id
            this.label = x.label
            this.metricStat = x.metricStat
            this.returnData = x.returnData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.MetricDataQuery = MetricDataQuery(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.MetricStat] inside the given [block]
         */
        public fun metricStat(block: aws.sdk.kotlin.services.autoscaling.model.MetricStat.Builder.() -> kotlin.Unit) {
            this.metricStat = aws.sdk.kotlin.services.autoscaling.model.MetricStat.invoke(block)
        }
    }
}
