// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes the state of a Classic Load Balancer.
 */
public class LoadBalancerState private constructor(builder: Builder) {
    /**
     * The name of the load balancer.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * One of the following load balancer states:
     * + `Adding` - The Auto Scaling instances are being registered with the load balancer.
     * + `Added` - All Auto Scaling instances are registered with the load balancer.
     * + `InService` - At least one Auto Scaling instance passed an `ELB` health check.
     * + `Removing` - The Auto Scaling instances are being deregistered from the load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.
     * + `Removed` - All Auto Scaling instances are deregistered from the load balancer.
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.LoadBalancerState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerState(")
        append("loadBalancerName=$loadBalancerName,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = loadBalancerName?.hashCode() ?: 0
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerState

        if (loadBalancerName != other.loadBalancerName) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.LoadBalancerState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the load balancer.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * One of the following load balancer states:
         * + `Adding` - The Auto Scaling instances are being registered with the load balancer.
         * + `Added` - All Auto Scaling instances are registered with the load balancer.
         * + `InService` - At least one Auto Scaling instance passed an `ELB` health check.
         * + `Removing` - The Auto Scaling instances are being deregistered from the load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the instances.
         * + `Removed` - All Auto Scaling instances are deregistered from the load balancer.
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.LoadBalancerState) : this() {
            this.loadBalancerName = x.loadBalancerName
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.LoadBalancerState = LoadBalancerState(this)
    }
}
