// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes a lifecycle hook. A lifecycle hook lets you create solutions that are aware of events in the Auto Scaling instance lifecycle, and then perform a custom action on instances when the corresponding lifecycle event occurs.
 */
public class LifecycleHook private constructor(builder: Builder) {
    /**
     * The name of the Auto Scaling group for the lifecycle hook.
     */
    public val autoScalingGroupName: kotlin.String? = builder.autoScalingGroupName
    /**
     * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs.
     *
     * Valid values: `CONTINUE` | `ABANDON`
     */
    public val defaultResult: kotlin.String? = builder.defaultResult
    /**
     * The maximum time, in seconds, that an instance can remain in a wait state. The maximum is 172800 seconds (48 hours) or 100 times `HeartbeatTimeout`, whichever is smaller.
     */
    public val globalTimeout: kotlin.Int? = builder.globalTimeout
    /**
     * The maximum time, in seconds, that can elapse before the lifecycle hook times out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the `DefaultResult` property.
     */
    public val heartbeatTimeout: kotlin.Int? = builder.heartbeatTimeout
    /**
     * The name of the lifecycle hook.
     */
    public val lifecycleHookName: kotlin.String? = builder.lifecycleHookName
    /**
     * The lifecycle transition.
     *
     * Valid values: `autoscaling:EC2_INSTANCE_LAUNCHING` | `autoscaling:EC2_INSTANCE_TERMINATING`
     */
    public val lifecycleTransition: kotlin.String? = builder.lifecycleTransition
    /**
     * Additional information that is included any time Amazon EC2 Auto Scaling sends a message to the notification target.
     */
    public val notificationMetadata: kotlin.String? = builder.notificationMetadata
    /**
     * The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in a wait state for the lifecycle hook.
     */
    public val notificationTargetArn: kotlin.String? = builder.notificationTargetArn
    /**
     * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target (an Amazon SNS topic or an Amazon SQS queue).
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.LifecycleHook = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleHook(")
        append("autoScalingGroupName=$autoScalingGroupName,")
        append("defaultResult=$defaultResult,")
        append("globalTimeout=$globalTimeout,")
        append("heartbeatTimeout=$heartbeatTimeout,")
        append("lifecycleHookName=$lifecycleHookName,")
        append("lifecycleTransition=$lifecycleTransition,")
        append("notificationMetadata=$notificationMetadata,")
        append("notificationTargetArn=$notificationTargetArn,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupName?.hashCode() ?: 0
        result = 31 * result + (defaultResult?.hashCode() ?: 0)
        result = 31 * result + (globalTimeout ?: 0)
        result = 31 * result + (heartbeatTimeout ?: 0)
        result = 31 * result + (lifecycleHookName?.hashCode() ?: 0)
        result = 31 * result + (lifecycleTransition?.hashCode() ?: 0)
        result = 31 * result + (notificationMetadata?.hashCode() ?: 0)
        result = 31 * result + (notificationTargetArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleHook

        if (autoScalingGroupName != other.autoScalingGroupName) return false
        if (defaultResult != other.defaultResult) return false
        if (globalTimeout != other.globalTimeout) return false
        if (heartbeatTimeout != other.heartbeatTimeout) return false
        if (lifecycleHookName != other.lifecycleHookName) return false
        if (lifecycleTransition != other.lifecycleTransition) return false
        if (notificationMetadata != other.notificationMetadata) return false
        if (notificationTargetArn != other.notificationTargetArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.LifecycleHook = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Auto Scaling group for the lifecycle hook.
         */
        public var autoScalingGroupName: kotlin.String? = null
        /**
         * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs.
         *
         * Valid values: `CONTINUE` | `ABANDON`
         */
        public var defaultResult: kotlin.String? = null
        /**
         * The maximum time, in seconds, that an instance can remain in a wait state. The maximum is 172800 seconds (48 hours) or 100 times `HeartbeatTimeout`, whichever is smaller.
         */
        public var globalTimeout: kotlin.Int? = null
        /**
         * The maximum time, in seconds, that can elapse before the lifecycle hook times out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the `DefaultResult` property.
         */
        public var heartbeatTimeout: kotlin.Int? = null
        /**
         * The name of the lifecycle hook.
         */
        public var lifecycleHookName: kotlin.String? = null
        /**
         * The lifecycle transition.
         *
         * Valid values: `autoscaling:EC2_INSTANCE_LAUNCHING` | `autoscaling:EC2_INSTANCE_TERMINATING`
         */
        public var lifecycleTransition: kotlin.String? = null
        /**
         * Additional information that is included any time Amazon EC2 Auto Scaling sends a message to the notification target.
         */
        public var notificationMetadata: kotlin.String? = null
        /**
         * The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in a wait state for the lifecycle hook.
         */
        public var notificationTargetArn: kotlin.String? = null
        /**
         * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target (an Amazon SNS topic or an Amazon SQS queue).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.LifecycleHook) : this() {
            this.autoScalingGroupName = x.autoScalingGroupName
            this.defaultResult = x.defaultResult
            this.globalTimeout = x.globalTimeout
            this.heartbeatTimeout = x.heartbeatTimeout
            this.lifecycleHookName = x.lifecycleHookName
            this.lifecycleTransition = x.lifecycleTransition
            this.notificationMetadata = x.notificationMetadata
            this.notificationTargetArn = x.notificationTargetArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.LifecycleHook = LifecycleHook(this)
    }
}
