// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes information used to set up an Amazon EBS volume specified in a block device mapping.
 */
public class Ebs private constructor(builder: Builder) {
    /**
     * Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the default value is `true`.
     */
    public val deleteOnTermination: kotlin.Boolean? = builder.deleteOnTermination
    /**
     * Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be attached to instances that support Amazon EBS encryption. For more information, see [Supported instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances). If your AMI uses encrypted volumes, you can also only launch it on supported instance types.
     *
     * If you are creating a volume from a snapshot, you cannot create an unencrypted volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when using a launch configuration.
     *
     * If you enable encryption by default, the EBS volumes that you create are always encrypted, either using the Amazon Web Services managed KMS key or a customer-managed KMS key, regardless of whether the snapshot was encrypted.
     *
     * For more information, see [Use Amazon Web Services KMS keys to encrypt Amazon EBS volumes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The number of input/output (I/O) operations per second (IOPS) to provision for the volume. For `gp3` and `io1` volumes, this represents the number of IOPS that are provisioned for the volume. For `gp2` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
     *
     * The following are the supported values for each volume type:
     * + `gp3`: 3,000-16,000 IOPS
     * + `io1`: 100-64,000 IOPS
     *
     * For `io1` volumes, we guarantee 64,000 IOPS only for [Instances built on the Nitro System](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances). Other instance families guarantee performance up to 32,000 IOPS.
     *
     * `Iops` is supported when the volume type is `gp3` or `io1` and required only when the volume type is `io1`. (Not used with `standard`, `gp2`, `st1`, or `sc1` volumes.)
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The snapshot ID of the volume to use.
     *
     * You must specify either a `VolumeSize` or a `SnapshotId`.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The throughput (MiBps) to provision for a `gp3` volume.
     */
    public val throughput: kotlin.Int? = builder.throughput
    /**
     * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
     * + `gp2` and `gp3`: 1-16,384
     * + `io1`: 4-16,384
     * + `st1` and `sc1`: 125-16,384
     * + `standard`: 1-1,024
     *
     * You must specify either a `SnapshotId` or a `VolumeSize`. If you specify both `SnapshotId` and `VolumeSize`, the volume size must be equal or greater than the size of the snapshot.
     */
    public val volumeSize: kotlin.Int? = builder.volumeSize
    /**
     * The volume type. For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) in the *Amazon EC2 User Guide for Linux Instances*.
     *
     * Valid values: `standard` | `io1` | `gp2` | `st1` | `sc1` | `gp3`
     */
    public val volumeType: kotlin.String? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.Ebs = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ebs(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("snapshotId=$snapshotId,")
        append("throughput=$throughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ebs

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (snapshotId != other.snapshotId) return false
        if (throughput != other.throughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.Ebs = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the default value is `true`.
         */
        public var deleteOnTermination: kotlin.Boolean? = null
        /**
         * Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be attached to instances that support Amazon EBS encryption. For more information, see [Supported instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances). If your AMI uses encrypted volumes, you can also only launch it on supported instance types.
         *
         * If you are creating a volume from a snapshot, you cannot create an unencrypted volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when using a launch configuration.
         *
         * If you enable encryption by default, the EBS volumes that you create are always encrypted, either using the Amazon Web Services managed KMS key or a customer-managed KMS key, regardless of whether the snapshot was encrypted.
         *
         * For more information, see [Use Amazon Web Services KMS keys to encrypt Amazon EBS volumes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The number of input/output (I/O) operations per second (IOPS) to provision for the volume. For `gp3` and `io1` volumes, this represents the number of IOPS that are provisioned for the volume. For `gp2` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         *
         * The following are the supported values for each volume type:
         * + `gp3`: 3,000-16,000 IOPS
         * + `io1`: 100-64,000 IOPS
         *
         * For `io1` volumes, we guarantee 64,000 IOPS only for [Instances built on the Nitro System](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances). Other instance families guarantee performance up to 32,000 IOPS.
         *
         * `Iops` is supported when the volume type is `gp3` or `io1` and required only when the volume type is `io1`. (Not used with `standard`, `gp2`, `st1`, or `sc1` volumes.)
         */
        public var iops: kotlin.Int? = null
        /**
         * The snapshot ID of the volume to use.
         *
         * You must specify either a `VolumeSize` or a `SnapshotId`.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The throughput (MiBps) to provision for a `gp3` volume.
         */
        public var throughput: kotlin.Int? = null
        /**
         * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
         * + `gp2` and `gp3`: 1-16,384
         * + `io1`: 4-16,384
         * + `st1` and `sc1`: 125-16,384
         * + `standard`: 1-1,024
         *
         * You must specify either a `SnapshotId` or a `VolumeSize`. If you specify both `SnapshotId` and `VolumeSize`, the volume size must be equal or greater than the size of the snapshot.
         */
        public var volumeSize: kotlin.Int? = null
        /**
         * The volume type. For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) in the *Amazon EC2 User Guide for Linux Instances*.
         *
         * Valid values: `standard` | `io1` | `gp2` | `st1` | `sc1` | `gp3`
         */
        public var volumeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.Ebs) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.snapshotId = x.snapshotId
            this.throughput = x.throughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.Ebs = Ebs(this)
    }
}
