// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscaling.model



/**
 * Describes the desired configuration for an instance refresh.
 *
 * If you specify a desired configuration, you must specify either a `LaunchTemplate` or a `MixedInstancesPolicy`.
 */
public class DesiredConfiguration private constructor(builder: Builder) {
    /**
     * Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses to launch Amazon EC2 instances. For more information about launch templates, see [Launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single Auto Scaling group.
     *
     * A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = builder.mixedInstancesPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DesiredConfiguration(")
        append("launchTemplate=$launchTemplate,")
        append("mixedInstancesPolicy=$mixedInstancesPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = launchTemplate?.hashCode() ?: 0
        result = 31 * result + (mixedInstancesPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DesiredConfiguration

        if (launchTemplate != other.launchTemplate) return false
        if (mixedInstancesPolicy != other.mixedInstancesPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling uses to launch Amazon EC2 instances. For more information about launch templates, see [Launch templates](https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var launchTemplate: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification? = null
        /**
         * Use this structure to launch multiple instance types and On-Demand Instances and Spot Instances within a single Auto Scaling group.
         *
         * A mixed instances policy contains information that Amazon EC2 Auto Scaling can use to launch instances and help optimize your costs. For more information, see [Auto Scaling groups with multiple instance types and purchase options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html) in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var mixedInstancesPolicy: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration) : this() {
            this.launchTemplate = x.launchTemplate
            this.mixedInstancesPolicy = x.mixedInstancesPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.autoscaling.model.DesiredConfiguration = DesiredConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.autoscaling.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy] inside the given [block]
         */
        public fun mixedInstancesPolicy(block: aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.Builder.() -> kotlin.Unit) {
            this.mixedInstancesPolicy = aws.sdk.kotlin.services.autoscaling.model.MixedInstancesPolicy.invoke(block)
        }
    }
}
