// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.auditmanager.model.AuditManagerException
import aws.sdk.kotlin.services.auditmanager.model.ControlMetadata
import aws.sdk.kotlin.services.auditmanager.model.ListControlsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListControlsOperationDeserializer: HttpDeserialize<ListControlsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListControlsResponse {
        if (!response.status.isSuccess()) {
            throwListControlsError(context, response)
        }
        val builder = ListControlsResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListControlsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeListControlsOperationBody(builder: ListControlsResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTROLMETADATALIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("controlMetadataList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTROLMETADATALIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTROLMETADATALIST_DESCRIPTOR.index -> builder.controlMetadataList =
                    deserializer.deserializeList(CONTROLMETADATALIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ControlMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeControlMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListControlsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw AuditManagerException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
