// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The settings object that holds all supported Audit Manager settings.
 */
class Settings private constructor(builder: BuilderImpl) {
    /**
     * The default storage destination for assessment reports.
     */
    val defaultAssessmentReportsDestination: AssessmentReportsDestination? = builder.defaultAssessmentReportsDestination
    /**
     * The designated default audit owners.
     */
    val defaultProcessOwners: List<Role>? = builder.defaultProcessOwners
    /**
     * Specifies whether Organizations is enabled.
     */
    val isAwsOrgEnabled: Boolean? = builder.isAwsOrgEnabled
    /**
     * The KMS key details.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The designated Amazon Simple Notification Service (Amazon SNS) topic.
     */
    val snsTopic: String? = builder.snsTopic

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Settings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Settings(")
        append("defaultAssessmentReportsDestination=$defaultAssessmentReportsDestination,")
        append("defaultProcessOwners=$defaultProcessOwners,")
        append("isAwsOrgEnabled=$isAwsOrgEnabled,")
        append("kmsKey=$kmsKey,")
        append("snsTopic=$snsTopic)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultAssessmentReportsDestination?.hashCode() ?: 0
        result = 31 * result + (defaultProcessOwners?.hashCode() ?: 0)
        result = 31 * result + (isAwsOrgEnabled?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (snsTopic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Settings

        if (defaultAssessmentReportsDestination != other.defaultAssessmentReportsDestination) return false
        if (defaultProcessOwners != other.defaultProcessOwners) return false
        if (isAwsOrgEnabled != other.isAwsOrgEnabled) return false
        if (kmsKey != other.kmsKey) return false
        if (snsTopic != other.snsTopic) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Settings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Settings
        /**
         * The default storage destination for assessment reports.
         */
        fun defaultAssessmentReportsDestination(defaultAssessmentReportsDestination: AssessmentReportsDestination): FluentBuilder
        /**
         * The designated default audit owners.
         */
        fun defaultProcessOwners(defaultProcessOwners: List<Role>): FluentBuilder
        /**
         * Specifies whether Organizations is enabled.
         */
        fun isAwsOrgEnabled(isAwsOrgEnabled: Boolean): FluentBuilder
        /**
         * The KMS key details.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The designated Amazon Simple Notification Service (Amazon SNS) topic.
         */
        fun snsTopic(snsTopic: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The default storage destination for assessment reports.
         */
        var defaultAssessmentReportsDestination: AssessmentReportsDestination?
        /**
         * The designated default audit owners.
         */
        var defaultProcessOwners: List<Role>?
        /**
         * Specifies whether Organizations is enabled.
         */
        var isAwsOrgEnabled: Boolean?
        /**
         * The KMS key details.
         */
        var kmsKey: String?
        /**
         * The designated Amazon Simple Notification Service (Amazon SNS) topic.
         */
        var snsTopic: String?

        fun build(): Settings
        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination] inside the given [block]
         */
        fun defaultAssessmentReportsDestination(block: AssessmentReportsDestination.DslBuilder.() -> kotlin.Unit) {
            this.defaultAssessmentReportsDestination = AssessmentReportsDestination.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var defaultAssessmentReportsDestination: AssessmentReportsDestination? = null
        override var defaultProcessOwners: List<Role>? = null
        override var isAwsOrgEnabled: Boolean? = null
        override var kmsKey: String? = null
        override var snsTopic: String? = null

        constructor(x: Settings) : this() {
            this.defaultAssessmentReportsDestination = x.defaultAssessmentReportsDestination
            this.defaultProcessOwners = x.defaultProcessOwners
            this.isAwsOrgEnabled = x.isAwsOrgEnabled
            this.kmsKey = x.kmsKey
            this.snsTopic = x.snsTopic
        }

        override fun build(): Settings = Settings(this)
        override fun defaultAssessmentReportsDestination(defaultAssessmentReportsDestination: AssessmentReportsDestination): FluentBuilder = apply { this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination }
        override fun defaultProcessOwners(defaultProcessOwners: List<Role>): FluentBuilder = apply { this.defaultProcessOwners = defaultProcessOwners }
        override fun isAwsOrgEnabled(isAwsOrgEnabled: Boolean): FluentBuilder = apply { this.isAwsOrgEnabled = isAwsOrgEnabled }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun snsTopic(snsTopic: String): FluentBuilder = apply { this.snsTopic = snsTopic }
    }
}
