// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The wrapper that contains the Audit Manager role information of the current user, such as the role type and IAM Amazon Resource Name (ARN).
 */
class Role private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The type of customer persona.
     * In CreateAssessment, roleType can only be PROCESS_OWNER.
     * In UpdateSettings, roleType can only be PROCESS_OWNER.
     * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
     */
    val roleType: RoleType? = builder.roleType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Role = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Role(")
        append("roleArn=$roleArn,")
        append("roleType=$roleType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (roleType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Role

        if (roleArn != other.roleArn) return false
        if (roleType != other.roleType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Role = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Role
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The type of customer persona.
         * In CreateAssessment, roleType can only be PROCESS_OWNER.
         * In UpdateSettings, roleType can only be PROCESS_OWNER.
         * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
         */
        fun roleType(roleType: RoleType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        var roleArn: String?
        /**
         * The type of customer persona.
         * In CreateAssessment, roleType can only be PROCESS_OWNER.
         * In UpdateSettings, roleType can only be PROCESS_OWNER.
         * In BatchCreateDelegationByAssessment, roleType can only be RESOURCE_OWNER.
         */
        var roleType: RoleType?

        fun build(): Role
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var roleArn: String? = null
        override var roleType: RoleType? = null

        constructor(x: Role) : this() {
            this.roleArn = x.roleArn
            this.roleType = x.roleType
        }

        override fun build(): Role = Role(this)
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun roleType(roleType: RoleType): FluentBuilder = apply { this.roleType = roleType }
    }
}
