// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The notification used to inform a user of an update in Audit Manager. For example, this includes the notification that is sent when a control set is delegated for review.
 */
class Notification private constructor(builder: BuilderImpl) {
    /**
     * The identifier for the specified assessment.
     */
    val assessmentId: String? = builder.assessmentId
    /**
     * The name of the related assessment.
     */
    val assessmentName: String? = builder.assessmentName
    /**
     * The identifier for the specified control set.
     */
    val controlSetId: String? = builder.controlSetId
    /**
     * Specifies the name of the control set that the notification is about.
     */
    val controlSetName: String? = builder.controlSetName
    /**
     * The description of the notification.
     */
    val description: String? = builder.description
    /**
     * The time when the notification was sent.
     */
    val eventTime: Instant? = builder.eventTime
    /**
     * The unique identifier for the notification.
     */
    val id: String? = builder.id
    /**
     * The sender of the notification.
     */
    val source: String? = builder.source

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Notification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Notification(")
        append("assessmentId=$assessmentId,")
        append("assessmentName=$assessmentName,")
        append("controlSetId=$controlSetId,")
        append("controlSetName=$controlSetName,")
        append("description=$description,")
        append("eventTime=$eventTime,")
        append("id=$id,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (controlSetId?.hashCode() ?: 0)
        result = 31 * result + (controlSetName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Notification

        if (assessmentId != other.assessmentId) return false
        if (assessmentName != other.assessmentName) return false
        if (controlSetId != other.controlSetId) return false
        if (controlSetName != other.controlSetName) return false
        if (description != other.description) return false
        if (eventTime != other.eventTime) return false
        if (id != other.id) return false
        if (source != other.source) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Notification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Notification
        /**
         * The identifier for the specified assessment.
         */
        fun assessmentId(assessmentId: String): FluentBuilder
        /**
         * The name of the related assessment.
         */
        fun assessmentName(assessmentName: String): FluentBuilder
        /**
         * The identifier for the specified control set.
         */
        fun controlSetId(controlSetId: String): FluentBuilder
        /**
         * Specifies the name of the control set that the notification is about.
         */
        fun controlSetName(controlSetName: String): FluentBuilder
        /**
         * The description of the notification.
         */
        fun description(description: String): FluentBuilder
        /**
         * The time when the notification was sent.
         */
        fun eventTime(eventTime: Instant): FluentBuilder
        /**
         * The unique identifier for the notification.
         */
        fun id(id: String): FluentBuilder
        /**
         * The sender of the notification.
         */
        fun source(source: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier for the specified assessment.
         */
        var assessmentId: String?
        /**
         * The name of the related assessment.
         */
        var assessmentName: String?
        /**
         * The identifier for the specified control set.
         */
        var controlSetId: String?
        /**
         * Specifies the name of the control set that the notification is about.
         */
        var controlSetName: String?
        /**
         * The description of the notification.
         */
        var description: String?
        /**
         * The time when the notification was sent.
         */
        var eventTime: Instant?
        /**
         * The unique identifier for the notification.
         */
        var id: String?
        /**
         * The sender of the notification.
         */
        var source: String?

        fun build(): Notification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentId: String? = null
        override var assessmentName: String? = null
        override var controlSetId: String? = null
        override var controlSetName: String? = null
        override var description: String? = null
        override var eventTime: Instant? = null
        override var id: String? = null
        override var source: String? = null

        constructor(x: Notification) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentName = x.assessmentName
            this.controlSetId = x.controlSetId
            this.controlSetName = x.controlSetName
            this.description = x.description
            this.eventTime = x.eventTime
            this.id = x.id
            this.source = x.source
        }

        override fun build(): Notification = Notification(this)
        override fun assessmentId(assessmentId: String): FluentBuilder = apply { this.assessmentId = assessmentId }
        override fun assessmentName(assessmentName: String): FluentBuilder = apply { this.assessmentName = assessmentName }
        override fun controlSetId(controlSetId: String): FluentBuilder = apply { this.controlSetId = controlSetId }
        override fun controlSetName(controlSetName: String): FluentBuilder = apply { this.controlSetName = controlSetName }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun eventTime(eventTime: Instant): FluentBuilder = apply { this.eventTime = eventTime }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun source(source: String): FluentBuilder = apply { this.source = source }
    }
}
