// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The file used to structure and automate Audit Manager assessments for a given compliance standard.
 */
class Framework private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the specified framework.
     */
    val arn: String? = builder.arn
    /**
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    val complianceType: String? = builder.complianceType
    /**
     * The control sets associated with the framework.
     */
    val controlSets: List<ControlSet>? = builder.controlSets
    /**
     * The sources from which Audit Manager collects evidence for the control.
     */
    val controlSources: String? = builder.controlSources
    /**
     * Specifies when the framework was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The IAM user or role that created the framework.
     */
    val createdBy: String? = builder.createdBy
    /**
     * The description of the specified framework.
     */
    val description: String? = builder.description
    /**
     * The unique identifier for the specified framework.
     */
    val id: String? = builder.id
    /**
     * Specifies when the framework was most recently updated.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The IAM user or role that most recently updated the framework.
     */
    val lastUpdatedBy: String? = builder.lastUpdatedBy
    /**
     * The logo associated with the framework.
     */
    val logo: String? = builder.logo
    /**
     * The name of the specified framework.
     */
    val name: String? = builder.name
    /**
     * The tags associated with the framework.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The framework type, such as custom or standard.
     */
    val type: FrameworkType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Framework = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Framework(")
        append("arn=$arn,")
        append("complianceType=$complianceType,")
        append("controlSets=$controlSets,")
        append("controlSources=$controlSources,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("logo=$logo,")
        append("name=$name,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (complianceType?.hashCode() ?: 0)
        result = 31 * result + (controlSets?.hashCode() ?: 0)
        result = 31 * result + (controlSources?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (logo?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Framework

        if (arn != other.arn) return false
        if (complianceType != other.complianceType) return false
        if (controlSets != other.controlSets) return false
        if (controlSources != other.controlSources) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (logo != other.logo) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Framework = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Framework
        /**
         * The Amazon Resource Name (ARN) of the specified framework.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         */
        fun complianceType(complianceType: String): FluentBuilder
        /**
         * The control sets associated with the framework.
         */
        fun controlSets(controlSets: List<ControlSet>): FluentBuilder
        /**
         * The sources from which Audit Manager collects evidence for the control.
         */
        fun controlSources(controlSources: String): FluentBuilder
        /**
         * Specifies when the framework was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The IAM user or role that created the framework.
         */
        fun createdBy(createdBy: String): FluentBuilder
        /**
         * The description of the specified framework.
         */
        fun description(description: String): FluentBuilder
        /**
         * The unique identifier for the specified framework.
         */
        fun id(id: String): FluentBuilder
        /**
         * Specifies when the framework was most recently updated.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The IAM user or role that most recently updated the framework.
         */
        fun lastUpdatedBy(lastUpdatedBy: String): FluentBuilder
        /**
         * The logo associated with the framework.
         */
        fun logo(logo: String): FluentBuilder
        /**
         * The name of the specified framework.
         */
        fun name(name: String): FluentBuilder
        /**
         * The tags associated with the framework.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The framework type, such as custom or standard.
         */
        fun type(type: FrameworkType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the specified framework.
         */
        var arn: String?
        /**
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         */
        var complianceType: String?
        /**
         * The control sets associated with the framework.
         */
        var controlSets: List<ControlSet>?
        /**
         * The sources from which Audit Manager collects evidence for the control.
         */
        var controlSources: String?
        /**
         * Specifies when the framework was created.
         */
        var createdAt: Instant?
        /**
         * The IAM user or role that created the framework.
         */
        var createdBy: String?
        /**
         * The description of the specified framework.
         */
        var description: String?
        /**
         * The unique identifier for the specified framework.
         */
        var id: String?
        /**
         * Specifies when the framework was most recently updated.
         */
        var lastUpdatedAt: Instant?
        /**
         * The IAM user or role that most recently updated the framework.
         */
        var lastUpdatedBy: String?
        /**
         * The logo associated with the framework.
         */
        var logo: String?
        /**
         * The name of the specified framework.
         */
        var name: String?
        /**
         * The tags associated with the framework.
         */
        var tags: Map<String, String>?
        /**
         * The framework type, such as custom or standard.
         */
        var type: FrameworkType?

        fun build(): Framework
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var complianceType: String? = null
        override var controlSets: List<ControlSet>? = null
        override var controlSources: String? = null
        override var createdAt: Instant? = null
        override var createdBy: String? = null
        override var description: String? = null
        override var id: String? = null
        override var lastUpdatedAt: Instant? = null
        override var lastUpdatedBy: String? = null
        override var logo: String? = null
        override var name: String? = null
        override var tags: Map<String, String>? = null
        override var type: FrameworkType? = null

        constructor(x: Framework) : this() {
            this.arn = x.arn
            this.complianceType = x.complianceType
            this.controlSets = x.controlSets
            this.controlSources = x.controlSources
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lastUpdatedBy = x.lastUpdatedBy
            this.logo = x.logo
            this.name = x.name
            this.tags = x.tags
            this.type = x.type
        }

        override fun build(): Framework = Framework(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun complianceType(complianceType: String): FluentBuilder = apply { this.complianceType = complianceType }
        override fun controlSets(controlSets: List<ControlSet>): FluentBuilder = apply { this.controlSets = controlSets }
        override fun controlSources(controlSources: String): FluentBuilder = apply { this.controlSources = controlSources }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun createdBy(createdBy: String): FluentBuilder = apply { this.createdBy = createdBy }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun lastUpdatedBy(lastUpdatedBy: String): FluentBuilder = apply { this.lastUpdatedBy = lastUpdatedBy }
        override fun logo(logo: String): FluentBuilder = apply { this.logo = logo }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: FrameworkType): FluentBuilder = apply { this.type = type }
    }
}
