// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A record that contains the information needed to demonstrate compliance with the requirements specified by a control. Examples of evidence include change activity triggered by a user, or a system configuration snapshot.
 */
class Evidence private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the evidence is included in the assessment report.
     */
    val assessmentReportSelection: String? = builder.assessmentReportSelection
    /**
     * The names and values used by the evidence event, including an attribute name (such as allowUsersToChangePassword) and value (such as true or false).
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * The identifier for the specified account.
     */
    val awsAccountId: String? = builder.awsAccountId
    /**
     * The account from which the evidence is collected, and its organization path.
     */
    val awsOrganization: String? = builder.awsOrganization
    /**
     * The evaluation status for evidence that falls under the compliance check category. For
     * evidence collected from Security Hub, a Pass or
     * Fail result is shown. For evidence collected from Config, a
     * Compliant or Noncompliant result is shown.
     */
    val complianceCheck: String? = builder.complianceCheck
    /**
     * The data source from which the specified evidence was collected.
     */
    val dataSource: String? = builder.dataSource
    /**
     * The name of the specified evidence event.
     */
    val eventName: String? = builder.eventName
    /**
     * The Amazon Web Service from which the evidence is collected.
     */
    val eventSource: String? = builder.eventSource
    /**
     * The identifier for the specified account.
     */
    val evidenceAwsAccountId: String? = builder.evidenceAwsAccountId
    /**
     * The type of automated evidence.
     */
    val evidenceByType: String? = builder.evidenceByType
    /**
     * The identifier for the folder in which the evidence is stored.
     */
    val evidenceFolderId: String? = builder.evidenceFolderId
    /**
     * The unique identifier for the IAM user or role associated with the evidence.
     */
    val iamId: String? = builder.iamId
    /**
     * The identifier for the evidence.
     */
    val id: String? = builder.id
    /**
     * The list of resources assessed to generate the evidence.
     */
    val resourcesIncluded: List<Resource>? = builder.resourcesIncluded
    /**
     * The timestamp that represents when the evidence was collected.
     */
    val time: Instant? = builder.time

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Evidence = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Evidence(")
        append("assessmentReportSelection=$assessmentReportSelection,")
        append("attributes=$attributes,")
        append("awsAccountId=$awsAccountId,")
        append("awsOrganization=$awsOrganization,")
        append("complianceCheck=$complianceCheck,")
        append("dataSource=$dataSource,")
        append("eventName=$eventName,")
        append("eventSource=$eventSource,")
        append("evidenceAwsAccountId=$evidenceAwsAccountId,")
        append("evidenceByType=$evidenceByType,")
        append("evidenceFolderId=$evidenceFolderId,")
        append("iamId=$iamId,")
        append("id=$id,")
        append("resourcesIncluded=$resourcesIncluded,")
        append("time=$time)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentReportSelection?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (awsOrganization?.hashCode() ?: 0)
        result = 31 * result + (complianceCheck?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (eventName?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (evidenceAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (evidenceByType?.hashCode() ?: 0)
        result = 31 * result + (evidenceFolderId?.hashCode() ?: 0)
        result = 31 * result + (iamId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (resourcesIncluded?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Evidence

        if (assessmentReportSelection != other.assessmentReportSelection) return false
        if (attributes != other.attributes) return false
        if (awsAccountId != other.awsAccountId) return false
        if (awsOrganization != other.awsOrganization) return false
        if (complianceCheck != other.complianceCheck) return false
        if (dataSource != other.dataSource) return false
        if (eventName != other.eventName) return false
        if (eventSource != other.eventSource) return false
        if (evidenceAwsAccountId != other.evidenceAwsAccountId) return false
        if (evidenceByType != other.evidenceByType) return false
        if (evidenceFolderId != other.evidenceFolderId) return false
        if (iamId != other.iamId) return false
        if (id != other.id) return false
        if (resourcesIncluded != other.resourcesIncluded) return false
        if (time != other.time) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Evidence = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Evidence
        /**
         * Specifies whether the evidence is included in the assessment report.
         */
        fun assessmentReportSelection(assessmentReportSelection: String): FluentBuilder
        /**
         * The names and values used by the evidence event, including an attribute name (such as allowUsersToChangePassword) and value (such as true or false).
         */
        fun attributes(attributes: Map<String, String>): FluentBuilder
        /**
         * The identifier for the specified account.
         */
        fun awsAccountId(awsAccountId: String): FluentBuilder
        /**
         * The account from which the evidence is collected, and its organization path.
         */
        fun awsOrganization(awsOrganization: String): FluentBuilder
        /**
         * The evaluation status for evidence that falls under the compliance check category. For
         * evidence collected from Security Hub, a Pass or
         * Fail result is shown. For evidence collected from Config, a
         * Compliant or Noncompliant result is shown.
         */
        fun complianceCheck(complianceCheck: String): FluentBuilder
        /**
         * The data source from which the specified evidence was collected.
         */
        fun dataSource(dataSource: String): FluentBuilder
        /**
         * The name of the specified evidence event.
         */
        fun eventName(eventName: String): FluentBuilder
        /**
         * The Amazon Web Service from which the evidence is collected.
         */
        fun eventSource(eventSource: String): FluentBuilder
        /**
         * The identifier for the specified account.
         */
        fun evidenceAwsAccountId(evidenceAwsAccountId: String): FluentBuilder
        /**
         * The type of automated evidence.
         */
        fun evidenceByType(evidenceByType: String): FluentBuilder
        /**
         * The identifier for the folder in which the evidence is stored.
         */
        fun evidenceFolderId(evidenceFolderId: String): FluentBuilder
        /**
         * The unique identifier for the IAM user or role associated with the evidence.
         */
        fun iamId(iamId: String): FluentBuilder
        /**
         * The identifier for the evidence.
         */
        fun id(id: String): FluentBuilder
        /**
         * The list of resources assessed to generate the evidence.
         */
        fun resourcesIncluded(resourcesIncluded: List<Resource>): FluentBuilder
        /**
         * The timestamp that represents when the evidence was collected.
         */
        fun time(time: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the evidence is included in the assessment report.
         */
        var assessmentReportSelection: String?
        /**
         * The names and values used by the evidence event, including an attribute name (such as allowUsersToChangePassword) and value (such as true or false).
         */
        var attributes: Map<String, String>?
        /**
         * The identifier for the specified account.
         */
        var awsAccountId: String?
        /**
         * The account from which the evidence is collected, and its organization path.
         */
        var awsOrganization: String?
        /**
         * The evaluation status for evidence that falls under the compliance check category. For
         * evidence collected from Security Hub, a Pass or
         * Fail result is shown. For evidence collected from Config, a
         * Compliant or Noncompliant result is shown.
         */
        var complianceCheck: String?
        /**
         * The data source from which the specified evidence was collected.
         */
        var dataSource: String?
        /**
         * The name of the specified evidence event.
         */
        var eventName: String?
        /**
         * The Amazon Web Service from which the evidence is collected.
         */
        var eventSource: String?
        /**
         * The identifier for the specified account.
         */
        var evidenceAwsAccountId: String?
        /**
         * The type of automated evidence.
         */
        var evidenceByType: String?
        /**
         * The identifier for the folder in which the evidence is stored.
         */
        var evidenceFolderId: String?
        /**
         * The unique identifier for the IAM user or role associated with the evidence.
         */
        var iamId: String?
        /**
         * The identifier for the evidence.
         */
        var id: String?
        /**
         * The list of resources assessed to generate the evidence.
         */
        var resourcesIncluded: List<Resource>?
        /**
         * The timestamp that represents when the evidence was collected.
         */
        var time: Instant?

        fun build(): Evidence
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentReportSelection: String? = null
        override var attributes: Map<String, String>? = null
        override var awsAccountId: String? = null
        override var awsOrganization: String? = null
        override var complianceCheck: String? = null
        override var dataSource: String? = null
        override var eventName: String? = null
        override var eventSource: String? = null
        override var evidenceAwsAccountId: String? = null
        override var evidenceByType: String? = null
        override var evidenceFolderId: String? = null
        override var iamId: String? = null
        override var id: String? = null
        override var resourcesIncluded: List<Resource>? = null
        override var time: Instant? = null

        constructor(x: Evidence) : this() {
            this.assessmentReportSelection = x.assessmentReportSelection
            this.attributes = x.attributes
            this.awsAccountId = x.awsAccountId
            this.awsOrganization = x.awsOrganization
            this.complianceCheck = x.complianceCheck
            this.dataSource = x.dataSource
            this.eventName = x.eventName
            this.eventSource = x.eventSource
            this.evidenceAwsAccountId = x.evidenceAwsAccountId
            this.evidenceByType = x.evidenceByType
            this.evidenceFolderId = x.evidenceFolderId
            this.iamId = x.iamId
            this.id = x.id
            this.resourcesIncluded = x.resourcesIncluded
            this.time = x.time
        }

        override fun build(): Evidence = Evidence(this)
        override fun assessmentReportSelection(assessmentReportSelection: String): FluentBuilder = apply { this.assessmentReportSelection = assessmentReportSelection }
        override fun attributes(attributes: Map<String, String>): FluentBuilder = apply { this.attributes = attributes }
        override fun awsAccountId(awsAccountId: String): FluentBuilder = apply { this.awsAccountId = awsAccountId }
        override fun awsOrganization(awsOrganization: String): FluentBuilder = apply { this.awsOrganization = awsOrganization }
        override fun complianceCheck(complianceCheck: String): FluentBuilder = apply { this.complianceCheck = complianceCheck }
        override fun dataSource(dataSource: String): FluentBuilder = apply { this.dataSource = dataSource }
        override fun eventName(eventName: String): FluentBuilder = apply { this.eventName = eventName }
        override fun eventSource(eventSource: String): FluentBuilder = apply { this.eventSource = eventSource }
        override fun evidenceAwsAccountId(evidenceAwsAccountId: String): FluentBuilder = apply { this.evidenceAwsAccountId = evidenceAwsAccountId }
        override fun evidenceByType(evidenceByType: String): FluentBuilder = apply { this.evidenceByType = evidenceByType }
        override fun evidenceFolderId(evidenceFolderId: String): FluentBuilder = apply { this.evidenceFolderId = evidenceFolderId }
        override fun iamId(iamId: String): FluentBuilder = apply { this.iamId = iamId }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun resourcesIncluded(resourcesIncluded: List<Resource>): FluentBuilder = apply { this.resourcesIncluded = resourcesIncluded }
        override fun time(time: Instant): FluentBuilder = apply { this.time = time }
    }
}
