// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The metadata associated with the specified delegation.
 */
class DelegationMetadata private constructor(builder: BuilderImpl) {
    /**
     * The unique identifier for the specified assessment.
     */
    val assessmentId: String? = builder.assessmentId
    /**
     * The name of the associated assessment.
     */
    val assessmentName: String? = builder.assessmentName
    /**
     * Specifies the name of the control set delegated for review.
     */
    val controlSetName: String? = builder.controlSetName
    /**
     * Specifies when the delegation was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The unique identifier for the delegation.
     */
    val id: String? = builder.id
    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The current status of the delgation.
     */
    val status: DelegationStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DelegationMetadata = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DelegationMetadata(")
        append("assessmentId=$assessmentId,")
        append("assessmentName=$assessmentName,")
        append("controlSetName=$controlSetName,")
        append("creationTime=$creationTime,")
        append("id=$id,")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (controlSetName?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DelegationMetadata

        if (assessmentId != other.assessmentId) return false
        if (assessmentName != other.assessmentName) return false
        if (controlSetName != other.controlSetName) return false
        if (creationTime != other.creationTime) return false
        if (id != other.id) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DelegationMetadata = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DelegationMetadata
        /**
         * The unique identifier for the specified assessment.
         */
        fun assessmentId(assessmentId: String): FluentBuilder
        /**
         * The name of the associated assessment.
         */
        fun assessmentName(assessmentName: String): FluentBuilder
        /**
         * Specifies the name of the control set delegated for review.
         */
        fun controlSetName(controlSetName: String): FluentBuilder
        /**
         * Specifies when the delegation was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The unique identifier for the delegation.
         */
        fun id(id: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The current status of the delgation.
         */
        fun status(status: DelegationStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique identifier for the specified assessment.
         */
        var assessmentId: String?
        /**
         * The name of the associated assessment.
         */
        var assessmentName: String?
        /**
         * Specifies the name of the control set delegated for review.
         */
        var controlSetName: String?
        /**
         * Specifies when the delegation was created.
         */
        var creationTime: Instant?
        /**
         * The unique identifier for the delegation.
         */
        var id: String?
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        var roleArn: String?
        /**
         * The current status of the delgation.
         */
        var status: DelegationStatus?

        fun build(): DelegationMetadata
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var assessmentId: String? = null
        override var assessmentName: String? = null
        override var controlSetName: String? = null
        override var creationTime: Instant? = null
        override var id: String? = null
        override var roleArn: String? = null
        override var status: DelegationStatus? = null

        constructor(x: DelegationMetadata) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentName = x.assessmentName
            this.controlSetName = x.controlSetName
            this.creationTime = x.creationTime
            this.id = x.id
            this.roleArn = x.roleArn
            this.status = x.status
        }

        override fun build(): DelegationMetadata = DelegationMetadata(this)
        override fun assessmentId(assessmentId: String): FluentBuilder = apply { this.assessmentId = assessmentId }
        override fun assessmentName(assessmentName: String): FluentBuilder = apply { this.assessmentName = assessmentName }
        override fun controlSetName(controlSetName: String): FluentBuilder = apply { this.controlSetName = controlSetName }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun status(status: DelegationStatus): FluentBuilder = apply { this.status = status }
    }
}
